/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleTypeVisitor8;
import javax.tools.Diagnostic;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.jpamodelgen.Context;
import org.hibernate.jpamodelgen.MetaModelGenerationException;
import org.hibernate.jpamodelgen.util.AccessType;
import org.hibernate.jpamodelgen.util.AccessTypeInformation;
import org.hibernate.jpamodelgen.util.NullnessUtil;
import org.hibernate.jpamodelgen.util.StringUtil;
import org.hibernate.jpamodelgen.util.TypeRenderingVisitor;

public final class TypeUtils {
    public static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_ANNOTATION_PARAMETER_NAME = "value";
    private static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TypeKind, @UnknownKeyFor @NonNull @Initialized String> PRIMITIVE_WRAPPERS = new HashMap<TypeKind, String>();
    private static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TypeKind, @UnknownKeyFor @NonNull @Initialized String> PRIMITIVES = new HashMap<TypeKind, String>();
    public static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> PRIMITIVE_TYPES;

    private TypeUtils() {
    }

    public static @UnknownKeyFor @NonNull @Initialized String toTypeString(@UnknownKeyFor @NonNull @Initialized TypeMirror type) {
        return type.getKind().isPrimitive() ? NullnessUtil.castNonNull(PRIMITIVE_WRAPPERS.get((Object)type.getKind())) : TypeRenderingVisitor.toString(type);
    }

    public static @UnknownKeyFor @NonNull @Initialized String toArrayTypeString(@UnknownKeyFor @NonNull @Initialized ArrayType type, @UnknownKeyFor @NonNull @Initialized Context context) {
        TypeMirror componentType = type.getComponentType();
        if (componentType.getKind().isPrimitive()) {
            return PRIMITIVES.get((Object)componentType.getKind()) + "[]";
        }
        TypeMirror component = componentType.accept(new SimpleTypeVisitor8<TypeMirror, Void>(){

            @Override
            protected TypeMirror defaultAction(TypeMirror e, Void aVoid) {
                return e;
            }
        }, null);
        return TypeUtils.extractClosestRealTypeAsString(component, context) + "[]";
    }

    public static @Nullable @UnknownKeyFor @Initialized TypeElement getSuperclassTypeElement(@UnknownKeyFor @NonNull @Initialized TypeElement element) {
        TypeMirror superClass = element.getSuperclass();
        if (superClass.getKind() == TypeKind.DECLARED) {
            Element superClassElement = ((DeclaredType)superClass).asElement();
            return (TypeElement)superClassElement;
        }
        return null;
    }

    public static @UnknownKeyFor @NonNull @Initialized String extractClosestRealTypeAsString(@UnknownKeyFor @NonNull @Initialized TypeMirror type, @UnknownKeyFor @NonNull @Initialized Context context) {
        TypeMirror mirror = TypeUtils.extractClosestRealType(type, context);
        return mirror == null ? "?" : mirror.toString();
    }

    private static @Nullable @UnknownKeyFor @Initialized TypeMirror lowerBound(@UnknownKeyFor @NonNull @Initialized TypeMirror bound) {
        return bound.getKind() == TypeKind.NULL ? null : bound;
    }

    private static @Nullable @UnknownKeyFor @Initialized TypeMirror upperBound(@UnknownKeyFor @NonNull @Initialized TypeMirror bound) {
        return bound.getKind() == TypeKind.DECLARED && bound.toString().equals("java.lang.Object") ? null : bound;
    }

    public static @UnknownKeyFor @NonNull @Initialized TypeMirror extractClosestRealType(@UnknownKeyFor @NonNull @Initialized TypeMirror type, @UnknownKeyFor @NonNull @Initialized Context context) {
        if (type == null) {
            return null;
        }
        switch (type.getKind()) {
            case TYPEVAR: {
                TypeVariable typeVariable = (TypeVariable)type;
                return context.getTypeUtils().getWildcardType(TypeUtils.upperBound(TypeUtils.extractClosestRealType(typeVariable.getUpperBound(), context)), TypeUtils.lowerBound(TypeUtils.extractClosestRealType(typeVariable.getLowerBound(), context)));
            }
            case WILDCARD: {
                WildcardType wildcardType = (WildcardType)type;
                return context.getTypeUtils().getWildcardType(TypeUtils.extractClosestRealType(wildcardType.getExtendsBound(), context), TypeUtils.extractClosestRealType(wildcardType.getSuperBound(), context));
            }
            case DECLARED: {
                DeclaredType declaredType = (DeclaredType)type;
                TypeElement typeElement = (TypeElement)declaredType.asElement();
                return context.getTypeUtils().getDeclaredType(typeElement, (TypeMirror[])declaredType.getTypeArguments().stream().map(arg -> TypeUtils.extractClosestRealType(arg, context)).toArray(TypeMirror[]::new));
            }
        }
        return context.getTypeUtils().erasure(type);
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean containsAnnotation(@UnknownKeyFor @NonNull @Initialized Element element, String ... annotations) {
        assert (element != null);
        assert (annotations != null);
        Set<String> annotationClassNames = Set.of(annotations);
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!annotationClassNames.contains(annotationMirror.getAnnotationType().toString())) continue;
            return true;
        }
        return false;
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean isAnnotationMirrorOfType(@UnknownKeyFor @NonNull @Initialized AnnotationMirror annotationMirror, @UnknownKeyFor @NonNull @Initialized String qualifiedName) {
        assert (annotationMirror != null);
        assert (qualifiedName != null);
        Element element = annotationMirror.getAnnotationType().asElement();
        return ((TypeElement)element).getQualifiedName().contentEquals(qualifiedName);
    }

    public static @Nullable @UnknownKeyFor @Initialized AnnotationMirror getAnnotationMirror(@UnknownKeyFor @NonNull @Initialized Element element, @UnknownKeyFor @NonNull @Initialized String qualifiedName) {
        assert (element != null);
        assert (qualifiedName != null);
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!TypeUtils.isAnnotationMirrorOfType(annotationMirror, qualifiedName)) continue;
            return annotationMirror;
        }
        return null;
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean hasAnnotation(@UnknownKeyFor @NonNull @Initialized Element element, @UnknownKeyFor @NonNull @Initialized String qualifiedName) {
        return TypeUtils.getAnnotationMirror(element, qualifiedName) != null;
    }

    public static @Nullable @UnknownKeyFor @Initialized Object getAnnotationValue(@UnknownKeyFor @NonNull @Initialized AnnotationMirror annotationMirror, @UnknownKeyFor @NonNull @Initialized String parameterValue) {
        assert (annotationMirror != null);
        assert (parameterValue != null);
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
            if (!entry.getKey().getSimpleName().contentEquals(parameterValue)) continue;
            return entry.getValue().getValue();
        }
        return null;
    }

    public static @Nullable @UnknownKeyFor @Initialized AnnotationValue getAnnotationValueRef(@UnknownKeyFor @NonNull @Initialized AnnotationMirror annotationMirror, @UnknownKeyFor @NonNull @Initialized String parameterValue) {
        assert (annotationMirror != null);
        assert (parameterValue != null);
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
            if (!entry.getKey().getSimpleName().contentEquals(parameterValue)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static void determineAccessTypeForHierarchy(@UnknownKeyFor @NonNull @Initialized TypeElement searchedElement, @UnknownKeyFor @NonNull @Initialized Context context) {
        String qualifiedName = searchedElement.getQualifiedName().toString();
        context.logMessage(Diagnostic.Kind.OTHER, "Determining access type for " + qualifiedName);
        AccessTypeInformation accessTypeInfo = context.getAccessTypeInfo(qualifiedName);
        if (accessTypeInfo != null && accessTypeInfo.isAccessTypeResolved()) {
            context.logMessage(Diagnostic.Kind.OTHER, "AccessType for " + searchedElement + " found in cache: " + accessTypeInfo);
        } else {
            AccessType forcedAccessType = TypeUtils.determineAnnotationSpecifiedAccessType(searchedElement);
            if (forcedAccessType != null) {
                context.logMessage(Diagnostic.Kind.OTHER, "Explicit access type on " + searchedElement + ":" + forcedAccessType);
                AccessTypeInformation newAccessTypeInfo = new AccessTypeInformation(qualifiedName, forcedAccessType, null);
                context.addAccessTypeInformation(qualifiedName, newAccessTypeInfo);
                TypeUtils.updateEmbeddableAccessType(searchedElement, context, forcedAccessType);
            } else {
                AccessType defaultAccessType = TypeUtils.getAccessTypeInCaseElementIsRoot(searchedElement, context);
                if (defaultAccessType != null) {
                    AccessTypeInformation newAccessTypeInfo = new AccessTypeInformation(qualifiedName, null, defaultAccessType);
                    context.addAccessTypeInformation(qualifiedName, newAccessTypeInfo);
                    TypeUtils.updateEmbeddableAccessType(searchedElement, context, defaultAccessType);
                    TypeUtils.setDefaultAccessTypeForMappedSuperclassesInHierarchy(searchedElement, defaultAccessType, context);
                } else {
                    AccessType newDefaultAccessType = TypeUtils.getDefaultAccessForHierarchy(searchedElement, context);
                    if (newDefaultAccessType == null) {
                        newDefaultAccessType = AccessType.PROPERTY;
                    }
                    AccessTypeInformation newAccessTypeInfo = new AccessTypeInformation(qualifiedName, null, newDefaultAccessType);
                    context.addAccessTypeInformation(qualifiedName, newAccessTypeInfo);
                    TypeUtils.updateEmbeddableAccessType(searchedElement, context, newDefaultAccessType);
                }
            }
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized TypeMirror getCollectionElementType(@UnknownKeyFor @NonNull @Initialized DeclaredType t, @UnknownKeyFor @NonNull @Initialized String fqNameOfReturnedType, @Nullable @UnknownKeyFor @Initialized String explicitTargetEntityName, @UnknownKeyFor @NonNull @Initialized Context context) {
        if (explicitTargetEntityName != null) {
            return context.getElementUtils().getTypeElement(explicitTargetEntityName).asType();
        }
        List<? extends TypeMirror> typeArguments = t.getTypeArguments();
        if (typeArguments.size() == 0) {
            throw new MetaModelGenerationException("Unable to determine collection type");
        }
        if (Map.class.getCanonicalName().equals(fqNameOfReturnedType)) {
            return t.getTypeArguments().get(1);
        }
        return t.getTypeArguments().get(0);
    }

    private static void updateEmbeddableAccessType(@UnknownKeyFor @NonNull @Initialized TypeElement element, @UnknownKeyFor @NonNull @Initialized Context context, @UnknownKeyFor @NonNull @Initialized AccessType defaultAccessType) {
        for (Element element2 : ElementFilter.fieldsIn(element.getEnclosedElements())) {
            TypeUtils.updateEmbeddableAccessTypeForMember(context, defaultAccessType, element2);
        }
        for (Element element3 : ElementFilter.methodsIn(element.getEnclosedElements())) {
            TypeUtils.updateEmbeddableAccessTypeForMember(context, defaultAccessType, element3);
        }
    }

    private static void updateEmbeddableAccessTypeForMember(@UnknownKeyFor @NonNull @Initialized Context context, @UnknownKeyFor @NonNull @Initialized AccessType defaultAccessType, @UnknownKeyFor @NonNull @Initialized Element member) {
        String embeddedClassName = member.asType().accept(new EmbeddedAttributeVisitor(context), member);
        if (embeddedClassName != null) {
            AccessTypeInformation accessTypeInfo = context.getAccessTypeInfo(embeddedClassName);
            if (accessTypeInfo == null) {
                AccessTypeInformation newAccessTypeInfo = new AccessTypeInformation(embeddedClassName, null, defaultAccessType);
                context.addAccessTypeInformation(embeddedClassName, newAccessTypeInfo);
            } else {
                accessTypeInfo.setDefaultAccessType(defaultAccessType);
            }
        }
    }

    private static @Nullable @UnknownKeyFor @Initialized AccessType getDefaultAccessForHierarchy(@UnknownKeyFor @NonNull @Initialized TypeElement element, @UnknownKeyFor @NonNull @Initialized Context context) {
        AccessType defaultAccessType = null;
        TypeElement superClass = element;
        do {
            if ((superClass = TypeUtils.getSuperclassTypeElement(superClass)) == null) continue;
            String qualifiedName = superClass.getQualifiedName().toString();
            AccessTypeInformation accessTypeInfo = context.getAccessTypeInfo(qualifiedName);
            if (accessTypeInfo != null && accessTypeInfo.getDefaultAccessType() != null) {
                return accessTypeInfo.getDefaultAccessType();
            }
            if (!TypeUtils.containsAnnotation(superClass, "jakarta.persistence.Entity", "jakarta.persistence.MappedSuperclass")) continue;
            defaultAccessType = TypeUtils.getAccessTypeInCaseElementIsRoot(superClass, context);
            if (defaultAccessType != null) {
                AccessTypeInformation newAccessTypeInfo = new AccessTypeInformation(qualifiedName, null, defaultAccessType);
                context.addAccessTypeInformation(qualifiedName, newAccessTypeInfo);
                TypeUtils.setDefaultAccessTypeForMappedSuperclassesInHierarchy(superClass, defaultAccessType, context);
                break;
            }
            defaultAccessType = TypeUtils.getDefaultAccessForHierarchy(superClass, context);
        } while (superClass != null);
        return defaultAccessType;
    }

    private static void setDefaultAccessTypeForMappedSuperclassesInHierarchy(@UnknownKeyFor @NonNull @Initialized TypeElement element, @UnknownKeyFor @NonNull @Initialized AccessType defaultAccessType, @UnknownKeyFor @NonNull @Initialized Context context) {
        TypeElement superClass = element;
        do {
            if ((superClass = TypeUtils.getSuperclassTypeElement(superClass)) == null) continue;
            String qualifiedName = superClass.getQualifiedName().toString();
            if (!TypeUtils.containsAnnotation(superClass, "jakarta.persistence.MappedSuperclass")) continue;
            AccessType forcedAccessType = TypeUtils.determineAnnotationSpecifiedAccessType(superClass);
            AccessTypeInformation accessTypeInfo = forcedAccessType != null ? new AccessTypeInformation(qualifiedName, null, forcedAccessType) : new AccessTypeInformation(qualifiedName, null, defaultAccessType);
            context.addAccessTypeInformation(qualifiedName, accessTypeInfo);
        } while (superClass != null);
    }

    private static @Nullable @UnknownKeyFor @Initialized AccessType getAccessTypeInCaseElementIsRoot(@UnknownKeyFor @NonNull @Initialized TypeElement searchedElement, @UnknownKeyFor @NonNull @Initialized Context context) {
        for (Element element : searchedElement.getEnclosedElements()) {
            for (AnnotationMirror annotationMirror : context.getElementUtils().getAllAnnotationMirrors(element)) {
                if (!TypeUtils.isIdAnnotation(annotationMirror)) continue;
                return TypeUtils.getAccessTypeOfIdAnnotation(element);
            }
        }
        return null;
    }

    private static @Nullable @UnknownKeyFor @Initialized AccessType getAccessTypeOfIdAnnotation(@UnknownKeyFor @NonNull @Initialized Element element) {
        ElementKind kind = element.getKind();
        if (kind == ElementKind.FIELD || kind == ElementKind.METHOD) {
            return kind == ElementKind.FIELD ? AccessType.FIELD : AccessType.PROPERTY;
        }
        return null;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isIdAnnotation(@UnknownKeyFor @NonNull @Initialized AnnotationMirror annotationMirror) {
        return TypeUtils.isAnnotationMirrorOfType(annotationMirror, "jakarta.persistence.Id") || TypeUtils.isAnnotationMirrorOfType(annotationMirror, "jakarta.persistence.EmbeddedId");
    }

    public static @Nullable @UnknownKeyFor @Initialized AccessType determineAnnotationSpecifiedAccessType(@UnknownKeyFor @NonNull @Initialized Element element) {
        Object accessType;
        AnnotationMirror mirror = TypeUtils.getAnnotationMirror(element, "jakarta.persistence.Access");
        if (mirror != null && (accessType = TypeUtils.getAnnotationValue(mirror, DEFAULT_ANNOTATION_PARAMETER_NAME)) instanceof VariableElement) {
            VariableElement enumValue = (VariableElement)accessType;
            if (enumValue.getSimpleName().contentEquals(AccessType.PROPERTY.toString())) {
                return AccessType.PROPERTY;
            }
            if (enumValue.getSimpleName().contentEquals(AccessType.FIELD.toString())) {
                return AccessType.FIELD;
            }
        }
        return null;
    }

    public static @UnknownKeyFor @NonNull @Initialized ElementKind getElementKindForAccessType(@UnknownKeyFor @NonNull @Initialized AccessType accessType) {
        return accessType == AccessType.FIELD ? ElementKind.FIELD : ElementKind.METHOD;
    }

    public static @UnknownKeyFor @NonNull @Initialized String getKeyType(@UnknownKeyFor @NonNull @Initialized DeclaredType type, @UnknownKeyFor @NonNull @Initialized Context context) {
        List<? extends TypeMirror> typeArguments = type.getTypeArguments();
        if (typeArguments.isEmpty()) {
            context.logMessage(Diagnostic.Kind.ERROR, "Unable to determine type argument for " + type);
            return "java.lang.Object";
        }
        return TypeUtils.extractClosestRealTypeAsString(typeArguments.get(0), context);
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean isClassOrRecordType(@UnknownKeyFor @NonNull @Initialized Element element) {
        ElementKind kind = element.getKind();
        return kind.isClass() && kind != ElementKind.ENUM;
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean isPrimitive(@UnknownKeyFor @NonNull @Initialized String paramType) {
        return PRIMITIVE_TYPES.contains(paramType);
    }

    static {
        PRIMITIVE_WRAPPERS.put(TypeKind.CHAR, "Character");
        PRIMITIVE_WRAPPERS.put(TypeKind.BYTE, "Byte");
        PRIMITIVE_WRAPPERS.put(TypeKind.SHORT, "Short");
        PRIMITIVE_WRAPPERS.put(TypeKind.INT, "Integer");
        PRIMITIVE_WRAPPERS.put(TypeKind.LONG, "Long");
        PRIMITIVE_WRAPPERS.put(TypeKind.BOOLEAN, "Boolean");
        PRIMITIVE_WRAPPERS.put(TypeKind.FLOAT, "Float");
        PRIMITIVE_WRAPPERS.put(TypeKind.DOUBLE, "Double");
        PRIMITIVES.put(TypeKind.CHAR, "char");
        PRIMITIVES.put(TypeKind.BYTE, "byte");
        PRIMITIVES.put(TypeKind.SHORT, "short");
        PRIMITIVES.put(TypeKind.INT, "int");
        PRIMITIVES.put(TypeKind.LONG, "long");
        PRIMITIVES.put(TypeKind.BOOLEAN, "boolean");
        PRIMITIVES.put(TypeKind.FLOAT, "float");
        PRIMITIVES.put(TypeKind.DOUBLE, "double");
        PRIMITIVE_TYPES = Set.of("boolean", "char", "long", "int", "short", "byte", "double", "float");
    }

    static class EmbeddedAttributeVisitor
    extends SimpleTypeVisitor8<String, Element> {
        private final @UnknownKeyFor @NonNull @Initialized Context context;

        EmbeddedAttributeVisitor(@UnknownKeyFor @NonNull @Initialized Context context) {
            this.context = context;
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized String visitDeclared(@UnknownKeyFor @NonNull @Initialized DeclaredType declaredType, @UnknownKeyFor @NonNull @Initialized Element element) {
            TypeElement returnedElement = (TypeElement)this.context.getTypeUtils().asElement(declaredType);
            return TypeUtils.containsAnnotation(returnedElement, "jakarta.persistence.Embeddable") ? returnedElement.getQualifiedName().toString() : null;
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized String visitExecutable(@UnknownKeyFor @NonNull @Initialized ExecutableType t, @UnknownKeyFor @NonNull @Initialized Element p) {
            if (p.getKind().equals((Object)ElementKind.METHOD)) {
                String string = p.getSimpleName().toString();
                return StringUtil.isProperty(string, TypeUtils.toTypeString(t.getReturnType())) ? t.getReturnType().accept(this, p) : null;
            }
            return null;
        }
    }
}

