
package org.hibernate.jpamodelgen.xml.jaxb;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for inheritance-type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="inheritance-type">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}token">
 *     <enumeration value="SINGLE_TABLE"/>
 *     <enumeration value="JOINED"/>
 *     <enumeration value="TABLE_PER_CLASS"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "inheritance-type", namespace = "https://jakarta.ee/xml/ns/persistence/orm")
@XmlEnum
public enum InheritanceType {

    SINGLE_TABLE,
    JOINED,
    TABLE_PER_CLASS;

    public String value() {
        return name();
    }

    public static InheritanceType fromValue(String v) {
        return valueOf(v);
    }

}
