
package org.hibernate.jpamodelgen.xml.jaxb;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for lock-mode-type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="lock-mode-type">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}token">
 *     <enumeration value="READ"/>
 *     <enumeration value="WRITE"/>
 *     <enumeration value="OPTIMISTIC"/>
 *     <enumeration value="OPTIMISTIC_FORCE_INCREMENT"/>
 *     <enumeration value="PESSIMISTIC_READ"/>
 *     <enumeration value="PESSIMISTIC_WRITE"/>
 *     <enumeration value="PESSIMISTIC_FORCE_INCREMENT"/>
 *     <enumeration value="NONE"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "lock-mode-type", namespace = "https://jakarta.ee/xml/ns/persistence/orm")
@XmlEnum
public enum LockModeType {

    READ,
    WRITE,
    OPTIMISTIC,
    OPTIMISTIC_FORCE_INCREMENT,
    PESSIMISTIC_READ,
    PESSIMISTIC_WRITE,
    PESSIMISTIC_FORCE_INCREMENT,
    NONE;

    public String value() {
        return name();
    }

    public static LockModeType fromValue(String v) {
        return valueOf(v);
    }

}
