
package org.hibernate.jpamodelgen.xml.jaxb;

import java.util.ArrayList;
import java.util.List;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;


/**
 * 
 * 
 *         @Target({TYPE}) @Retention(RUNTIME)
 *         public @interface SqlResultSetMapping {
 *           String name();
 *           EntityResult[] entities() default {};
 *           ConstructorResult[] classes() default{};
 *           ColumnResult[] columns() default {};
 *         }
 * 
 *       
 * 
 * <p>Java class for sql-result-set-mapping complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="sql-result-set-mapping">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="description" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         <element name="entity-result" type="{https://jakarta.ee/xml/ns/persistence/orm}entity-result" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="constructor-result" type="{https://jakarta.ee/xml/ns/persistence/orm}constructor-result" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="column-result" type="{https://jakarta.ee/xml/ns/persistence/orm}column-result" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *       <attribute name="name" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "sql-result-set-mapping", namespace = "https://jakarta.ee/xml/ns/persistence/orm", propOrder = {
    "description",
    "entityResult",
    "constructorResult",
    "columnResult"
})
public class SqlResultSetMapping {

    @XmlElement(namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected String description;
    @XmlElement(name = "entity-result", namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected List<EntityResult> entityResult;
    @XmlElement(name = "constructor-result", namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected List<ConstructorResult> constructorResult;
    @XmlElement(name = "column-result", namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected List<ColumnResult> columnResult;
    @XmlAttribute(name = "name", required = true)
    protected String name;

    /**
     * Gets the value of the description property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDescription() {
        return description;
    }

    /**
     * Sets the value of the description property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDescription(String value) {
        this.description = value;
    }

    /**
     * Gets the value of the entityResult property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the entityResult property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getEntityResult().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link EntityResult }
     * 
     * 
     * @return
     *     The value of the entityResult property.
     */
    public List<EntityResult> getEntityResult() {
        if (entityResult == null) {
            entityResult = new ArrayList<>();
        }
        return this.entityResult;
    }

    /**
     * Gets the value of the constructorResult property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the constructorResult property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getConstructorResult().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ConstructorResult }
     * 
     * 
     * @return
     *     The value of the constructorResult property.
     */
    public List<ConstructorResult> getConstructorResult() {
        if (constructorResult == null) {
            constructorResult = new ArrayList<>();
        }
        return this.constructorResult;
    }

    /**
     * Gets the value of the columnResult property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the columnResult property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getColumnResult().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ColumnResult }
     * 
     * 
     * @return
     *     The value of the columnResult property.
     */
    public List<ColumnResult> getColumnResult() {
        if (columnResult == null) {
            columnResult = new ArrayList<>();
        }
        return this.columnResult;
    }

    /**
     * Gets the value of the name property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setName(String value) {
        this.name = value;
    }

}
