/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.processor.ClassWriter;
import org.hibernate.processor.ContainsAttributeTypeVisitor;
import org.hibernate.processor.Context;
import org.hibernate.processor.ProcessLaterException;
import org.hibernate.processor.Version;
import org.hibernate.processor.annotation.AnnotationMetaEntity;
import org.hibernate.processor.annotation.AnnotationMetaPackage;
import org.hibernate.processor.model.Metamodel;
import org.hibernate.processor.util.TypeUtils;
import org.hibernate.processor.xml.JpaDescriptorParser;

@SupportedAnnotationTypes(value={"jakarta.persistence.Entity", "jakarta.persistence.MappedSuperclass", "jakarta.persistence.Embeddable", "jakarta.persistence.NamedQuery", "jakarta.persistence.NamedNativeQuery", "jakarta.persistence.NamedEntityGraph", "jakarta.persistence.SqlResultSetMapping", "org.hibernate.annotations.FetchProfile", "org.hibernate.annotations.FilterDef", "org.hibernate.annotations.NamedQuery", "org.hibernate.annotations.NamedNativeQuery", "org.hibernate.annotations.processing.HQL", "org.hibernate.annotations.processing.SQL", "org.hibernate.annotations.processing.Find", "jakarta.data.repository.Repository"})
@SupportedOptions(value={"debug", "persistenceXml", "ormXml", "fullyAnnotationConfigured", "lazyXmlParsing", "addGenerationDate", "addGeneratedAnnotation", "addSuppressWarningsAnnotation", "suppressJakartaDataMetamodel"})
public class HibernateProcessor
extends AbstractProcessor {
    public static final @UnknownKeyFor @NonNull @Initialized String DEBUG_OPTION = "debug";
    public static final @UnknownKeyFor @NonNull @Initialized String PERSISTENCE_XML_OPTION = "persistenceXml";
    public static final @UnknownKeyFor @NonNull @Initialized String ORM_XML_OPTION = "ormXml";
    public static final @UnknownKeyFor @NonNull @Initialized String FULLY_ANNOTATION_CONFIGURED_OPTION = "fullyAnnotationConfigured";
    public static final @UnknownKeyFor @NonNull @Initialized String LAZY_XML_PARSING = "lazyXmlParsing";
    public static final @UnknownKeyFor @NonNull @Initialized String ADD_GENERATED_ANNOTATION = "addGeneratedAnnotation";
    public static final @UnknownKeyFor @NonNull @Initialized String ADD_GENERATION_DATE = "addGenerationDate";
    public static final @UnknownKeyFor @NonNull @Initialized String ADD_SUPPRESS_WARNINGS_ANNOTATION = "addSuppressWarningsAnnotation";
    public static final @UnknownKeyFor @NonNull @Initialized String SUPPRESS_JAKARTA_DATA_METAMODEL = "suppressJakartaDataMetamodel";
    private static final @UnknownKeyFor @NonNull @Initialized boolean ALLOW_OTHER_PROCESSORS_TO_CLAIM_ANNOTATIONS = false;
    private @UnknownKeyFor @NonNull @Initialized Context context;

    @Override
    public synchronized void init(@UnknownKeyFor @NonNull @Initialized ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        this.context = new Context(processingEnvironment);
        this.context.logMessage(Diagnostic.Kind.NOTE, "Hibernate compile-time tooling " + Version.getVersionString());
        boolean fullyAnnotationConfigured = this.handleSettings(processingEnvironment);
        if (!fullyAnnotationConfigured) {
            new JpaDescriptorParser(this.context).parseXml();
            if (this.context.isFullyXmlConfigured()) {
                this.createMetaModelClasses();
            }
        }
    }

    private @UnknownKeyFor @NonNull @Initialized boolean handleSettings(@UnknownKeyFor @NonNull @Initialized ProcessingEnvironment environment) {
        PackageElement jakartaInjectPackage = this.context.getProcessingEnvironment().getElementUtils().getPackageElement("jakarta.inject");
        PackageElement jakartaAnnotationPackage = this.context.getProcessingEnvironment().getElementUtils().getPackageElement("jakarta.annotation");
        PackageElement jakartaContextPackage = this.context.getProcessingEnvironment().getElementUtils().getPackageElement("jakarta.enterprise.context");
        PackageElement jakartaTransactionsPackage = this.context.getProcessingEnvironment().getElementUtils().getPackageElement("jakarta.transactions");
        PackageElement jakartaDataPackage = this.context.getProcessingEnvironment().getElementUtils().getPackageElement("jakarta.data");
        PackageElement quarkusOrmPackage = this.context.getProcessingEnvironment().getElementUtils().getPackageElement("io.quarkus.hibernate.orm");
        PackageElement quarkusOrmPanachePackage = this.context.getProcessingEnvironment().getElementUtils().getPackageElement("io.quarkus.hibernate.orm.panache");
        PackageElement quarkusReactivePanachePackage = this.context.getProcessingEnvironment().getElementUtils().getPackageElement("io.quarkus.hibernate.reactive.panache");
        if (quarkusReactivePanachePackage != null && quarkusOrmPanachePackage != null) {
            this.context.logMessage(Diagnostic.Kind.WARNING, "Both Quarkus Hibernate ORM and Hibernate Reactive with Panache detected: this is not supported, so will proceed as if none were there");
            quarkusReactivePanachePackage = null;
            quarkusOrmPanachePackage = null;
        }
        this.context.setAddInjectAnnotation(jakartaInjectPackage != null);
        this.context.setAddNonnullAnnotation(jakartaAnnotationPackage != null);
        this.context.setAddGeneratedAnnotation(jakartaAnnotationPackage != null);
        this.context.setAddDependentAnnotation(jakartaContextPackage != null);
        this.context.setAddTransactionScopedAnnotation(jakartaTransactionsPackage != null);
        this.context.setQuarkusInjection(quarkusOrmPackage != null);
        this.context.setUsesQuarkusOrm(quarkusOrmPanachePackage != null);
        this.context.setUsesQuarkusReactive(quarkusReactivePanachePackage != null);
        Map<String, String> options = environment.getOptions();
        boolean suppressJakartaData = Boolean.parseBoolean(options.get(SUPPRESS_JAKARTA_DATA_METAMODEL));
        this.context.setGenerateJakartaDataStaticMetamodel(!suppressJakartaData && jakartaDataPackage != null);
        String setting = options.get(ADD_GENERATED_ANNOTATION);
        if (setting != null) {
            this.context.setAddGeneratedAnnotation(Boolean.parseBoolean(setting));
        }
        this.context.setAddGenerationDate(Boolean.parseBoolean(options.get(ADD_GENERATION_DATE)));
        this.context.setAddSuppressWarningsAnnotation(Boolean.parseBoolean(options.get(ADD_SUPPRESS_WARNINGS_ANNOTATION)));
        return Boolean.parseBoolean(options.get(FULLY_ANNOTATION_CONFIGURED_OPTION));
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean process(@UnknownKeyFor @NonNull @Initialized Set<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized TypeElement> annotations, @UnknownKeyFor @NonNull @Initialized RoundEnvironment roundEnvironment) {
        if (roundEnvironment.processingOver()) {
            Set<CharSequence> elementsToRedo = this.context.getElementsToRedo();
            if (!elementsToRedo.isEmpty()) {
                this.context.logMessage(Diagnostic.Kind.ERROR, "Failed to generate code for " + elementsToRedo);
            }
        } else if (this.context.isFullyXmlConfigured()) {
            this.context.logMessage(Diagnostic.Kind.OTHER, "Skipping the processing of annotations since persistence unit is purely XML configured.");
        } else {
            this.context.logMessage(Diagnostic.Kind.OTHER, "Starting new round");
            try {
                this.processClasses(roundEnvironment);
                this.createMetaModelClasses();
            }
            catch (Exception e) {
                StringWriter stack = new StringWriter();
                e.printStackTrace(new PrintWriter(stack));
                Throwable cause = e.getCause();
                String message = cause != null && cause != e ? e.getMessage() + " caused by " + cause.getMessage() : e.getMessage();
                this.context.logMessage(Diagnostic.Kind.ERROR, "Error running Hibernate processor: " + message);
                this.context.logMessage(Diagnostic.Kind.ERROR, stack.toString());
            }
        }
        return false;
    }

    private void processClasses(@UnknownKeyFor @NonNull @Initialized RoundEnvironment roundEnvironment) {
        TypeElement typeElement;
        for (CharSequence charSequence : new HashSet<CharSequence>(this.context.getElementsToRedo())) {
            this.context.logMessage(Diagnostic.Kind.OTHER, "Redoing element '" + charSequence + "'");
            typeElement = this.context.getElementUtils().getTypeElement(charSequence);
            try {
                AnnotationMetaEntity metaEntity = AnnotationMetaEntity.create(typeElement, this.context);
                this.context.addMetaAuxiliary(metaEntity.getQualifiedName(), metaEntity);
                this.context.removeElementToRedo(charSequence);
            }
            catch (ProcessLaterException metaEntity) {}
        }
        for (Element element : roundEnvironment.getRootElements()) {
            try {
                if (HibernateProcessor.isEntityOrEmbeddable(element)) {
                    this.context.logMessage(Diagnostic.Kind.OTHER, "Processing annotated entity class '" + element + "'");
                    this.handleRootElementAnnotationMirrors(element);
                    continue;
                }
                if (this.hasAuxiliaryAnnotations(element)) {
                    this.context.logMessage(Diagnostic.Kind.OTHER, "Processing annotated class '" + element + "'");
                    this.handleRootElementAuxiliaryAnnotationMirrors(element);
                    continue;
                }
                if (!(element instanceof TypeElement)) continue;
                typeElement = (TypeElement)element;
                AnnotationMirror repository = TypeUtils.getAnnotationMirror(element, "jakarta.data.repository.Repository");
                if (repository != null) {
                    String provider = (String)TypeUtils.getAnnotationValue(repository, "provider");
                    if (provider != null && !provider.isEmpty() && !provider.equalsIgnoreCase("hibernate")) continue;
                    this.context.logMessage(Diagnostic.Kind.OTHER, "Processing repository class '" + element + "'");
                    AnnotationMetaEntity annotationMetaEntity = AnnotationMetaEntity.create(typeElement, this.context);
                    this.context.addMetaAuxiliary(annotationMetaEntity.getQualifiedName(), annotationMetaEntity);
                    continue;
                }
                for (Element element2 : typeElement.getEnclosedElements()) {
                    if (!TypeUtils.hasAnnotation(element2, "org.hibernate.annotations.processing.HQL", "org.hibernate.annotations.processing.SQL", "org.hibernate.annotations.processing.Find")) continue;
                    this.context.logMessage(Diagnostic.Kind.OTHER, "Processing annotated class '" + element + "'");
                    AnnotationMetaEntity metaEntity = AnnotationMetaEntity.create(typeElement, this.context);
                    this.context.addMetaAuxiliary(metaEntity.getQualifiedName(), metaEntity);
                }
            }
            catch (ProcessLaterException processLaterException) {
                if (!(element instanceof TypeElement)) continue;
                this.context.logMessage(Diagnostic.Kind.OTHER, "Could not process '" + element + "' (will redo in next round)");
                this.context.addElementToRedo(((TypeElement)element).getQualifiedName());
            }
        }
    }

    private void createMetaModelClasses() {
        for (Metamodel aux : this.context.getMetaAuxiliaries()) {
            if (this.context.isAlreadyGenerated(aux)) continue;
            this.context.logMessage(Diagnostic.Kind.OTHER, "Writing metamodel for auxiliary '" + aux + "'");
            ClassWriter.writeFile(aux, this.context);
            this.context.markGenerated(aux);
        }
        for (Metamodel entity : this.context.getMetaEntities()) {
            if (this.context.isAlreadyGenerated(entity)) continue;
            this.context.logMessage(Diagnostic.Kind.OTHER, "Writing Jakarta Persistence metamodel for entity '" + entity + "'");
            ClassWriter.writeFile(entity, this.context);
            this.context.markGenerated(entity);
        }
        for (Metamodel entity : this.context.getDataMetaEntities()) {
            if (this.context.isAlreadyGenerated(entity)) continue;
            this.context.logMessage(Diagnostic.Kind.OTHER, "Writing Jakarta Data metamodel for entity '" + entity + "'");
            ClassWriter.writeFile(entity, this.context);
            this.context.markGenerated(entity);
        }
        this.processEmbeddables(this.context.getMetaEmbeddables());
        this.processEmbeddables(this.context.getDataMetaEmbeddables());
    }

    private void processEmbeddables(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Metamodel> models) {
        while (!models.isEmpty()) {
            HashSet<Metamodel> processed = new HashSet<Metamodel>();
            int toProcessCountBeforeLoop = models.size();
            for (Metamodel metamodel : models) {
                if (this.context.isAlreadyGenerated(metamodel)) {
                    processed.add(metamodel);
                    continue;
                }
                if (this.modelGenerationNeedsToBeDeferred(models, metamodel)) continue;
                this.context.logMessage(Diagnostic.Kind.OTHER, "Writing metamodel for embeddable " + metamodel);
                ClassWriter.writeFile(metamodel, this.context);
                this.context.markGenerated(metamodel);
                processed.add(metamodel);
            }
            models.removeAll(processed);
            if (models.size() < toProcessCountBeforeLoop) continue;
            this.context.logMessage(Diagnostic.Kind.ERROR, "Potential endless loop in generation of entities.");
        }
    }

    private @UnknownKeyFor @NonNull @Initialized boolean modelGenerationNeedsToBeDeferred(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Metamodel> entities, @UnknownKeyFor @NonNull @Initialized Metamodel containedEntity) {
        Element element = containedEntity.getElement();
        if (element instanceof TypeElement) {
            ContainsAttributeTypeVisitor visitor = new ContainsAttributeTypeVisitor((TypeElement)element, this.context);
            for (Metamodel entity : entities) {
                TypeMirror mirror;
                if (entity.equals(containedEntity)) continue;
                List<? extends Element> enclosedElements = entity.getElement().getEnclosedElements();
                for (Element element2 : ElementFilter.fieldsIn(enclosedElements)) {
                    mirror = element2.asType();
                    if (TypeKind.DECLARED != mirror.getKind() || !mirror.accept(visitor, element2).booleanValue()) continue;
                    return true;
                }
                for (Element element3 : ElementFilter.methodsIn(enclosedElements)) {
                    mirror = element3.asType();
                    if (TypeKind.DECLARED != mirror.getKind() || !mirror.accept(visitor, element3).booleanValue()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isEntityOrEmbeddable(@UnknownKeyFor @NonNull @Initialized Element element) {
        return TypeUtils.containsAnnotation(element, "jakarta.persistence.Entity", "jakarta.persistence.MappedSuperclass", "jakarta.persistence.Embeddable");
    }

    private @UnknownKeyFor @NonNull @Initialized boolean hasAuxiliaryAnnotations(@UnknownKeyFor @NonNull @Initialized Element element) {
        return TypeUtils.containsAnnotation(element, "jakarta.persistence.NamedQuery", "jakarta.persistence.NamedQueries", "jakarta.persistence.NamedNativeQuery", "jakarta.persistence.NamedNativeQueries", "jakarta.persistence.SqlResultSetMapping", "jakarta.persistence.SqlResultSetMappings", "jakarta.persistence.NamedEntityGraph", "jakarta.persistence.NamedEntityGraphs", "org.hibernate.annotations.NamedQuery", "org.hibernate.annotations.NamedQueries", "org.hibernate.annotations.NamedNativeQuery", "org.hibernate.annotations.NamedNativeQueries", "org.hibernate.annotations.FetchProfile", "org.hibernate.annotations.FetchProfiles", "org.hibernate.annotations.FilterDef", "org.hibernate.annotations.FilterDefs");
    }

    private void handleRootElementAnnotationMirrors(@UnknownKeyFor @NonNull @Initialized Element element) {
        if (TypeUtils.isClassOrRecordType(element) && TypeUtils.hasAnnotation(element, "jakarta.persistence.Entity", "jakarta.persistence.MappedSuperclass", "jakarta.persistence.Embeddable")) {
            TypeElement typeElement = (TypeElement)element;
            String qualifiedName = typeElement.getQualifiedName().toString();
            Metamodel alreadyExistingMetaEntity = this.tryGettingExistingEntityFromContext(typeElement, qualifiedName);
            if (alreadyExistingMetaEntity != null && alreadyExistingMetaEntity.isMetaComplete()) {
                this.context.logMessage(Diagnostic.Kind.OTHER, "Skipping processing of annotations for '" + qualifiedName + "' since XML configuration is metadata complete.");
            } else {
                boolean requiresLazyMemberInitialization = TypeUtils.hasAnnotation(element, "jakarta.persistence.Embeddable", "jakarta.persistence.MappedSuperclass");
                AnnotationMetaEntity metaEntity = AnnotationMetaEntity.create(typeElement, this.context, requiresLazyMemberInitialization, true, false);
                if (alreadyExistingMetaEntity != null) {
                    metaEntity.mergeInMembers(alreadyExistingMetaEntity);
                }
                this.addMetamodelToContext(typeElement, metaEntity);
                if (this.context.generateJakartaDataStaticMetamodel() && alreadyExistingMetaEntity == null) {
                    AnnotationMetaEntity dataMetaEntity = AnnotationMetaEntity.create(typeElement, this.context, requiresLazyMemberInitialization, true, true);
                    this.addDataMetamodelToContext(typeElement, dataMetaEntity);
                }
            }
        }
    }

    private void handleRootElementAuxiliaryAnnotationMirrors(@UnknownKeyFor @NonNull @Initialized Element element) {
        if (element instanceof TypeElement) {
            AnnotationMetaEntity metaEntity = AnnotationMetaEntity.create((TypeElement)element, this.context);
            this.context.addMetaAuxiliary(metaEntity.getQualifiedName(), metaEntity);
        } else if (element instanceof PackageElement) {
            AnnotationMetaPackage metaEntity = AnnotationMetaPackage.create((PackageElement)element, this.context);
            this.context.addMetaAuxiliary(metaEntity.getQualifiedName(), metaEntity);
        }
    }

    private @Nullable @UnknownKeyFor @Initialized Metamodel tryGettingExistingEntityFromContext(@UnknownKeyFor @NonNull @Initialized TypeElement typeElement, @UnknownKeyFor @NonNull @Initialized String qualifiedName) {
        if (TypeUtils.hasAnnotation((Element)typeElement, "jakarta.persistence.Entity", "jakarta.persistence.MappedSuperclass")) {
            return this.context.getMetaEntity(qualifiedName);
        }
        if (TypeUtils.hasAnnotation((Element)typeElement, "jakarta.persistence.Embeddable")) {
            return this.context.getMetaEmbeddable(qualifiedName);
        }
        return null;
    }

    private void addMetamodelToContext(@UnknownKeyFor @NonNull @Initialized TypeElement typeElement, @UnknownKeyFor @NonNull @Initialized AnnotationMetaEntity entity) {
        String key = entity.getQualifiedName();
        if (TypeUtils.hasAnnotation((Element)typeElement, "jakarta.persistence.Entity")) {
            this.context.addMetaEntity(key, entity);
        } else if (TypeUtils.hasAnnotation((Element)typeElement, "jakarta.persistence.MappedSuperclass")) {
            this.context.addMetaEntity(key, entity);
        } else if (TypeUtils.hasAnnotation((Element)typeElement, "jakarta.persistence.Embeddable")) {
            this.context.addMetaEmbeddable(key, entity);
        }
    }

    private void addDataMetamodelToContext(@UnknownKeyFor @NonNull @Initialized TypeElement typeElement, @UnknownKeyFor @NonNull @Initialized AnnotationMetaEntity entity) {
        String key = entity.getQualifiedName();
        if (TypeUtils.hasAnnotation((Element)typeElement, "jakarta.persistence.Entity")) {
            this.context.addDataMetaEntity(key, entity);
        } else if (TypeUtils.hasAnnotation((Element)typeElement, "jakarta.persistence.MappedSuperclass")) {
            this.context.addDataMetaEntity(key, entity);
        } else if (TypeUtils.hasAnnotation((Element)typeElement, "jakarta.persistence.Embeddable")) {
            this.context.addDataMetaEmbeddable(key, entity);
        }
    }
}

