/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.annotation;

import java.util.List;
import java.util.stream.Collectors;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.AssertionFailure;
import org.hibernate.processor.annotation.AnnotationMetaEntity;
import org.hibernate.processor.annotation.OrderBy;
import org.hibernate.processor.model.MetaAttribute;
import org.hibernate.processor.model.Metamodel;
import org.hibernate.processor.util.Constants;
import org.hibernate.processor.util.TypeUtils;

public abstract class AbstractQueryMethod
implements MetaAttribute {
    final @UnknownKeyFor @NonNull @Initialized AnnotationMetaEntity annotationMetaEntity;
    final @UnknownKeyFor @NonNull @Initialized String methodName;
    final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramNames;
    final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes;
    final @Nullable @UnknownKeyFor @Initialized String returnTypeName;
    final @UnknownKeyFor @NonNull @Initialized String sessionType;
    final @UnknownKeyFor @NonNull @Initialized String sessionName;
    final @UnknownKeyFor @NonNull @Initialized boolean belongsToDao;
    final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized OrderBy> orderBys;
    final @UnknownKeyFor @NonNull @Initialized boolean addNonnullAnnotation;
    final @UnknownKeyFor @NonNull @Initialized boolean dataRepository;
    static final @UnknownKeyFor @NonNull @Initialized String MAKE_KEYED_SLICE = "\t\tvar _cursors =\n\t\t\t\t_results.getKeyList()\n\t\t\t\t\t\t.stream()\n\t\t\t\t\t\t.map(_key -> Cursor.forKey(_key.toArray()))\n\t\t\t\t\t\t.collect(toList());\n\t\tvar _page =\n\t\t\t\tPageRequest.of(Entity.class)\n\t\t\t\t\t\t.sortBy(pageRequest.sorts())\n\t\t\t\t\t\t.size(pageRequest.size())\n\t\t\t\t\t\t.page(pageRequest.page() + 1);\n\t\treturn new CursoredPageRecord<>(_results.getResultList(), _cursors, _totalResults, pageRequest,\n\t\t\t\t_results.isLastPage() ? null : _page.afterKey(_results.getNextPage().getKey().toArray()),\n\t\t\t\t_results.isFirstPage() ? null : _page.beforeKey(_results.getPreviousPage().getKey().toArray()));";
    static final @UnknownKeyFor @NonNull @Initialized String MAKE_KEYED_PAGE = "\tvar _unkeyedPage =\n\t\t\tpage(pageRequest.size(), (int) pageRequest.page()-1)\n\t\t\t\t\t.keyedBy(_orders);\n\tvar _keyedPage =\n\t\t\tpageRequest.cursor()\n\t\t\t\t\t.map(_cursor -> {\n\t\t\t\t\t\t@SuppressWarnings(\"unchecked\")\n\t\t\t\t\t\tvar _elements = (List<Comparable<?>>) _cursor.elements();\n\t\t\t\t\t\treturn switch (pageRequest.mode()) {\n\t\t\t\t\t\t\tcase CURSOR_NEXT -> _unkeyedPage.withKey(_elements, KEY_OF_LAST_ON_PREVIOUS_PAGE);\n\t\t\t\t\t\t\tcase CURSOR_PREVIOUS -> _unkeyedPage.withKey(_elements, KEY_OF_FIRST_ON_NEXT_PAGE);\n\t\t\t\t\t\t\tdefault -> _unkeyedPage;\n\t\t\t\t\t\t};\n\t\t\t\t\t}).orElse(_unkeyedPage);";

    AbstractQueryMethod(@UnknownKeyFor @NonNull @Initialized AnnotationMetaEntity annotationMetaEntity, @UnknownKeyFor @NonNull @Initialized String methodName, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramNames, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes, @Nullable @UnknownKeyFor @Initialized String returnTypeName, @UnknownKeyFor @NonNull @Initialized String sessionType, @UnknownKeyFor @NonNull @Initialized String sessionName, @UnknownKeyFor @NonNull @Initialized boolean belongsToDao, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized OrderBy> orderBys, @UnknownKeyFor @NonNull @Initialized boolean addNonnullAnnotation, @UnknownKeyFor @NonNull @Initialized boolean dataRepository) {
        this.annotationMetaEntity = annotationMetaEntity;
        this.methodName = methodName;
        this.paramNames = paramNames;
        this.paramTypes = paramTypes;
        this.returnTypeName = returnTypeName;
        this.sessionType = sessionType;
        this.sessionName = sessionName;
        this.belongsToDao = belongsToDao;
        this.orderBys = orderBys;
        this.addNonnullAnnotation = addNonnullAnnotation;
        this.dataRepository = dataRepository;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Metamodel getHostingEntity() {
        return this.annotationMetaEntity;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getMetaType() {
        throw new UnsupportedOperationException("operation not supported");
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getPropertyName() {
        return this.methodName;
    }

    abstract @UnknownKeyFor @NonNull @Initialized boolean isNullable(@UnknownKeyFor @NonNull @Initialized int var1);

    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> parameterTypes() {
        return this.paramTypes.stream().map(paramType -> AbstractQueryMethod.isOrderParam(paramType) && paramType.endsWith("[]") ? paramType.substring(0, paramType.length() - 2) + "..." : paramType).collect(Collectors.toList());
    }

    @UnknownKeyFor @NonNull @Initialized String parameterList() {
        return this.paramTypes.stream().map(this::strip).map(this.annotationMetaEntity::importType).reduce((x, y) -> x + "," + y).orElse("");
    }

    @UnknownKeyFor @NonNull @Initialized String strip(@UnknownKeyFor @NonNull @Initialized String type) {
        int index = type.indexOf("<");
        String stripped = index > 0 ? type.substring(0, index) : type;
        return type.endsWith("...") ? stripped + "..." : stripped;
    }

    void preamble(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration, @UnknownKeyFor @NonNull @Initialized StringBuilder returnType, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes) {
        declaration.append((CharSequence)returnType).append(" ").append(this.methodName);
        this.parameters(paramTypes, declaration);
        declaration.append(" {\n");
    }

    void parameters(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes, @UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        declaration.append("(");
        this.sessionParameter(declaration);
        for (int i = 0; i < this.paramNames.size(); ++i) {
            if (i > 0) {
                declaration.append(", ");
            }
            String paramType = paramTypes.get(i);
            if (!this.isNullable(i) && !TypeUtils.isPrimitive(paramType) || AbstractQueryMethod.isSessionParameter(paramType)) {
                this.notNull(declaration);
            }
            declaration.append(this.annotationMetaEntity.importType(this.importReturnTypeArgument(paramType))).append(" ").append(this.paramNames.get(i).replace('.', '$'));
        }
        declaration.append(")");
    }

    static @UnknownKeyFor @NonNull @Initialized boolean isSessionParameter(@UnknownKeyFor @NonNull @Initialized String paramType) {
        return Constants.SESSION_TYPES.contains(paramType);
    }

    private @UnknownKeyFor @NonNull @Initialized String importReturnTypeArgument(@UnknownKeyFor @NonNull @Initialized String type) {
        return this.returnTypeName != null ? type.replace(this.returnTypeName, this.annotationMetaEntity.importType(this.returnTypeName)) : type;
    }

    void sessionParameter(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        if (!this.belongsToDao) {
            if (this.paramTypes.stream().noneMatch(Constants.SESSION_TYPES::contains)) {
                this.notNull(declaration);
                declaration.append(this.annotationMetaEntity.importType(this.sessionType)).append(' ').append(this.sessionName);
                if (!this.paramNames.isEmpty()) {
                    declaration.append(", ");
                }
            }
        }
    }

    void notNull(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        if (this.addNonnullAnnotation) {
            declaration.append('@').append(this.annotationMetaEntity.importType("jakarta.annotation.Nonnull")).append(' ');
        }
    }

    void see(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        declaration.append("\n * @see ").append(this.annotationMetaEntity.getQualifiedName()).append("#").append(this.methodName).append("(").append(this.parameterList()).append(")");
    }

    @UnknownKeyFor @NonNull @Initialized boolean isUsingEntityManager() {
        return "jakarta.persistence.EntityManager".equals(this.sessionType);
    }

    @UnknownKeyFor @NonNull @Initialized boolean isUsingStatelessSession() {
        return "org.hibernate.StatelessSession".equals(this.sessionType);
    }

    @UnknownKeyFor @NonNull @Initialized boolean isReactive() {
        return "org.hibernate.reactive.mutiny.Mutiny.Session".equals(this.sessionType) || "io.smallrye.mutiny.Uni<org.hibernate.reactive.mutiny.Mutiny.Session>".equals(this.sessionType);
    }

    @UnknownKeyFor @NonNull @Initialized boolean isReactiveSession() {
        return "io.smallrye.mutiny.Uni<org.hibernate.reactive.mutiny.Mutiny.Session>".equals(this.sessionType);
    }

    @UnknownKeyFor @NonNull @Initialized String localSessionName() {
        return this.isReactiveSession() ? "resolvedSession" : this.sessionName;
    }

    void chainSession(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        if (this.isReactiveSession()) {
            declaration.append("\treturn ").append(this.sessionName).append(".chain(").append(this.localSessionName()).append(" -> {\n\t");
        }
    }

    void chainSessionEnd(@UnknownKeyFor @NonNull @Initialized boolean isUpdate, @UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        if (this.isReactiveSession()) {
            declaration.append("\t})");
            if (isUpdate && this.returnTypeName != null && this.returnTypeName.equals("java.lang.Void")) {
                declaration.append(".replaceWithVoid();\n");
            } else {
                declaration.append(";\n");
            }
        }
    }

    void setPage(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration, @UnknownKeyFor @NonNull @Initialized String paramName, @UnknownKeyFor @NonNull @Initialized String paramType) {
        boolean jakartaLimit = "jakarta.data.Limit".equals(paramType);
        boolean jakartaPageRequest = paramType.startsWith("jakarta.data.page.PageRequest");
        if (jakartaLimit || jakartaPageRequest || this.isUsingEntityManager()) {
            String maxResults;
            String firstResult;
            if (jakartaLimit) {
                firstResult = "(int) " + paramName + ".startAt() - 1";
                maxResults = paramName + ".maxResults()";
            } else if (jakartaPageRequest) {
                firstResult = "(int) (" + paramName + ".page()-1) * " + paramName + ".size()";
                maxResults = paramName + ".size()";
            } else {
                firstResult = paramName + ".getFirstResult()";
                maxResults = paramName + ".getMaxResults()";
            }
            declaration.append("\t\t\t.setFirstResult(").append(firstResult).append(")\n").append("\t\t\t.setMaxResults(").append(maxResults).append(")\n");
        } else {
            declaration.append("\t\t\t.setPage(").append(paramName).append(")\n");
        }
    }

    @UnknownKeyFor @NonNull @Initialized boolean applyOrder(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes, @Nullable @UnknownKeyFor @Initialized String containerType, @UnknownKeyFor @NonNull @Initialized boolean unwrapped) {
        if (!AbstractQueryMethod.isJakartaCursoredPage(containerType) && this.hasOrdering(paramTypes)) {
            this.unwrapQuery(declaration, unwrapped);
            declaration.append("\t\t\t.setOrder(_orders)\n");
            return true;
        }
        return unwrapped;
    }

    void handlePageParameters(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes, @Nullable @UnknownKeyFor @Initialized String containerType) {
        if (!AbstractQueryMethod.isJakartaCursoredPage(containerType)) {
            for (int i = 0; i < this.paramNames.size(); ++i) {
                String paramName = this.paramNames.get(i);
                String paramType = paramTypes.get(i);
                if (!AbstractQueryMethod.isPageParam(paramType)) continue;
                this.setPage(declaration, paramName, paramType);
            }
        }
    }

    void convertExceptions(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        if (this.dataRepository) {
            declaration.append("\t}\n");
            if (this.singleResult()) {
                declaration.append("\tcatch (").append(this.annotationMetaEntity.importType("jakarta.persistence.NoResultException")).append(" exception) {\n").append("\t\tthrow new ").append(this.annotationMetaEntity.importType("jakarta.data.exceptions.EmptyResultException")).append("(exception);\n").append("\t}\n").append("\tcatch (").append(this.annotationMetaEntity.importType("jakarta.persistence.NonUniqueResultException")).append(" exception) {\n").append("\t\tthrow new ").append(this.annotationMetaEntity.importType("jakarta.data.exceptions.NonUniqueResultException")).append("(exception);\n").append("\t}\n");
            }
            declaration.append("\tcatch (").append(this.annotationMetaEntity.importType("jakarta.persistence.PersistenceException")).append(" exception) {\n").append("\t\tthrow new ").append(this.annotationMetaEntity.importType("jakarta.data.exceptions.DataException")).append("(exception);\n").append("\t}\n");
        }
    }

    abstract @UnknownKeyFor @NonNull @Initialized boolean singleResult();

    static void closingBrace(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        declaration.append("}");
    }

    void unwrapQuery(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration, @UnknownKeyFor @NonNull @Initialized boolean unwrapped) {
        if (!unwrapped && this.isUsingEntityManager()) {
            declaration.append("\t\t\t.unwrap(").append(this.annotationMetaEntity.importType("org.hibernate.query.SelectionQuery")).append(".class)\n");
        }
    }

    static @UnknownKeyFor @NonNull @Initialized boolean isSpecialParam(@UnknownKeyFor @NonNull @Initialized String parameterType) {
        return AbstractQueryMethod.isPageParam(parameterType) || AbstractQueryMethod.isOrderParam(parameterType) || AbstractQueryMethod.isKeyedPageParam(parameterType) || AbstractQueryMethod.isSessionParameter(parameterType);
    }

    static @UnknownKeyFor @NonNull @Initialized boolean isKeyedPageParam(@UnknownKeyFor @NonNull @Initialized String parameterType) {
        return parameterType.startsWith("org.hibernate.query.KeyedPage");
    }

    static @UnknownKeyFor @NonNull @Initialized boolean isPageParam(@UnknownKeyFor @NonNull @Initialized String parameterType) {
        return "org.hibernate.query.Page".equals(parameterType) || "jakarta.data.Limit".equals(parameterType) || parameterType.startsWith("jakarta.data.page.PageRequest");
    }

    static @UnknownKeyFor @NonNull @Initialized boolean isOrderParam(@UnknownKeyFor @NonNull @Initialized String parameterType) {
        return parameterType.startsWith("org.hibernate.query.Order") || parameterType.startsWith("java.util.List<org.hibernate.query.Order") || parameterType.startsWith("jakarta.data.Sort") || parameterType.startsWith("jakarta.data.Order") || parameterType.startsWith("jakarta.data.page.PageRequest");
    }

    static @UnknownKeyFor @NonNull @Initialized boolean isJakartaCursoredPage(@Nullable @UnknownKeyFor @Initialized String containerType) {
        return "jakarta.data.page.CursoredPage".equals(containerType);
    }

    static @UnknownKeyFor @NonNull @Initialized boolean isJakartaPage(@Nullable @UnknownKeyFor @Initialized String containerType) {
        return "jakarta.data.page.Page".equals(containerType);
    }

    void makeKeyedPage(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes) {
        this.annotationMetaEntity.staticImport("org.hibernate.query.SortDirection", "*");
        this.annotationMetaEntity.staticImport("org.hibernate.query.Order", "by");
        this.annotationMetaEntity.staticImport("org.hibernate.query.Page", "page");
        this.annotationMetaEntity.staticImport("org.hibernate.query.KeyedPage.KeyInterpretation", "*");
        this.annotationMetaEntity.staticImport(Collectors.class.getName(), "toList");
        if (this.returnTypeName == null) {
            throw new AssertionFailure("entity class cannot be null");
        }
        declaration.append(MAKE_KEYED_PAGE.replace("pageRequest", AbstractQueryMethod.parameterName("jakarta.data.page.PageRequest", paramTypes, this.paramNames)).replace("Entity", this.annotationMetaEntity.importType(this.returnTypeName))).append('\n');
    }

    void createQuery(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
    }

    void setParameters(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes, @UnknownKeyFor @NonNull @Initialized String indent) {
    }

    void tryReturn(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes, @Nullable @UnknownKeyFor @Initialized String containerType) {
        if (AbstractQueryMethod.isJakartaCursoredPage(containerType)) {
            this.makeKeyedPage(declaration, paramTypes);
        }
        if (this.dataRepository) {
            declaration.append("\ttry {\n");
        }
        if ("jakarta.data.page.CursoredPage".equals(containerType) || "jakarta.data.page.Page".equals(containerType)) {
            if (this.dataRepository) {
                declaration.append('\t');
            }
            this.totalResults(declaration, paramTypes);
        }
        if (this.dataRepository) {
            declaration.append('\t');
        }
        declaration.append('\t');
        if (AbstractQueryMethod.isJakartaCursoredPage(containerType) || AbstractQueryMethod.isJakartaPage(containerType)) {
            if (this.returnTypeName != null && this.isUsingEntityManager()) {
                declaration.append(this.annotationMetaEntity.importType("org.hibernate.query.KeyedResultList")).append('<').append(this.annotationMetaEntity.importType(this.returnTypeName)).append('>');
            } else {
                declaration.append("var");
            }
            declaration.append(" _results = ");
        } else if (!"void".equals(this.returnTypeName) || this.isReactiveSession()) {
            declaration.append("return ");
        }
    }

    private void totalResults(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes) {
        declaration.append("\tlong _totalResults = \n\t\t\t\t").append(AbstractQueryMethod.parameterName("jakarta.data.page.PageRequest", paramTypes, this.paramNames)).append(".requestTotal()\n\t\t\t\t\t\t? ");
        this.createQuery(declaration);
        this.setParameters(declaration, paramTypes, "\t\t\t\t\t");
        if (this.isUsingEntityManager()) {
            declaration.append("\t\t\t\t\t");
        }
        this.unwrapQuery(declaration, !this.isUsingEntityManager());
        declaration.append("\t\t\t\t\t\t\t\t.getResultCount()\n\t\t\t\t\t\t: -1;\n");
    }

    void collectOrdering(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes) {
        if (this.hasOrdering(paramTypes) && this.returnTypeName != null) {
            declaration.append("\tvar _orders = new ").append(this.annotationMetaEntity.importType("java.util.ArrayList")).append("<").append(this.annotationMetaEntity.importType("org.hibernate.query.Order")).append("<? super ").append(this.annotationMetaEntity.importType(this.returnTypeName)).append(">>();\n");
            for (OrderBy orderBy : this.orderBys) {
                this.annotationMetaEntity.staticImport("org.hibernate.query.SortDirection", "*");
                declaration.append("\t_orders.add(").append(this.annotationMetaEntity.staticImport("org.hibernate.query.Order", "by")).append('(').append(this.annotationMetaEntity.importType(this.returnTypeName)).append(".class, \"").append(orderBy.fieldName).append("\", ").append(orderBy.descending ? "DESCENDING" : "ASCENDING").append(", ").append(orderBy.ignoreCase).append("));\n");
            }
            for (int i = 0; i < paramTypes.size(); ++i) {
                String type = paramTypes.get(i);
                String name = this.paramNames.get(i);
                if (type.startsWith("org.hibernate.query.Order") && type.endsWith("...")) {
                    declaration.append("\tfor (var _sort : ").append(name).append(") {\n").append("\t\t_orders.add(_sort);\n").append("\t}\n");
                    continue;
                }
                if (type.startsWith("org.hibernate.query.Order")) {
                    declaration.append("\t_orders.add(").append(name).append(");\n");
                    continue;
                }
                if (type.startsWith("java.util.List<org.hibernate.query.Order")) {
                    declaration.append("\t_orders.addAll(").append(name).append(");\n");
                    continue;
                }
                if (type.startsWith("jakarta.data.Order") || type.startsWith("jakarta.data.page.PageRequest")) {
                    this.annotationMetaEntity.staticImport("org.hibernate.query.SortDirection", "*");
                    declaration.append("\tfor (var _sort : ").append(name).append(".sorts()) {\n").append("\t\t_orders.add(").append(this.annotationMetaEntity.staticImport("org.hibernate.query.Order", "by")).append('(').append(this.annotationMetaEntity.importType(this.returnTypeName)).append(".class, _sort.property(),").append("\n\t\t\t\t\t\t").append("_sort.isAscending() ? ASCENDING : DESCENDING,").append("\n\t\t\t\t\t\t").append("_sort.ignoreCase()));\n").append("\t}\n");
                    continue;
                }
                if (type.startsWith("jakarta.data.Sort") && type.endsWith("...")) {
                    this.annotationMetaEntity.staticImport("org.hibernate.query.SortDirection", "*");
                    declaration.append("\tfor (var _sort : ").append(name).append(") {\n").append("\t\t_orders.add(").append(this.annotationMetaEntity.staticImport("org.hibernate.query.Order", "by")).append('(').append(this.annotationMetaEntity.importType(this.returnTypeName)).append(".class, _sort.property(),").append("\n\t\t\t\t\t\t").append("_sort.isAscending() ? ASCENDING : DESCENDING,").append("\n\t\t\t\t\t\t").append("_sort.ignoreCase()));\n").append("\t}\n");
                    continue;
                }
                if (!type.startsWith("jakarta.data.Sort")) continue;
                this.annotationMetaEntity.staticImport("org.hibernate.query.SortDirection", "*");
                declaration.append("\t_orders.add(").append(this.annotationMetaEntity.staticImport("org.hibernate.query.Order", "by")).append('(').append(this.annotationMetaEntity.importType(this.returnTypeName)).append(".class, ").append(name).append(".property(),").append("\n\t\t\t\t\t\t").append(name).append(".isAscending() ? ASCENDING : DESCENDING,").append("\n\t\t\t\t\t\t").append(name).append(".ignoreCase()));\n");
            }
        }
    }

    private @UnknownKeyFor @NonNull @Initialized boolean hasOrdering(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes) {
        return paramTypes.stream().anyMatch(AbstractQueryMethod::isOrderParam) || !this.orderBys.isEmpty();
    }

    @UnknownKeyFor @NonNull @Initialized boolean unwrapIfNecessary(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration, @Nullable @UnknownKeyFor @Initialized String containerType, @UnknownKeyFor @NonNull @Initialized boolean unwrapped) {
        if ("java.util.Optional".equals(containerType) || AbstractQueryMethod.isJakartaCursoredPage(containerType)) {
            this.unwrapQuery(declaration, unwrapped);
            unwrapped = true;
        }
        return unwrapped;
    }

    protected void executeSelect(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes, @Nullable @UnknownKeyFor @Initialized String containerType, @UnknownKeyFor @NonNull @Initialized boolean unwrapped, @UnknownKeyFor @NonNull @Initialized boolean mustUnwrap) {
        if (containerType == null) {
            declaration.append("\t\t\t.getSingleResult();");
        } else {
            switch (containerType) {
                case "[]": {
                    if (this.returnTypeName == null) {
                        throw new AssertionFailure("missing return type");
                    }
                    declaration.append("\t\t\t.getResultList()\n\t\t\t.toArray(new ").append(this.annotationMetaEntity.importType(this.returnTypeName)).append("[0]);");
                    break;
                }
                case "java.util.Optional": {
                    declaration.append("\t\t\t.uniqueResultOptional();");
                    break;
                }
                case "java.util.stream.Stream": {
                    declaration.append("\t\t\t.getResultStream();");
                    break;
                }
                case "java.util.List": {
                    declaration.append("\t\t\t.getResultList();");
                    break;
                }
                case "org.hibernate.query.KeyedResultList": {
                    this.unwrapQuery(declaration, unwrapped);
                    declaration.append("\t\t\t.getKeyedResultList(").append(AbstractQueryMethod.parameterName("org.hibernate.query.KeyedPage", paramTypes, this.paramNames)).append(");");
                    break;
                }
                case "jakarta.data.page.Page": {
                    declaration.append("\t\t\t.getResultList();\n").append("\t\treturn new ").append(this.annotationMetaEntity.importType("jakarta.data.page.impl.PageRecord")).append('(').append(AbstractQueryMethod.parameterName("jakarta.data.page.PageRequest", paramTypes, this.paramNames)).append(", _results, _totalResults);");
                    break;
                }
                case "jakarta.data.page.CursoredPage": {
                    if (this.returnTypeName == null) {
                        throw new AssertionFailure("entity class cannot be null");
                    }
                    this.unwrapQuery(declaration, unwrapped);
                    declaration.append("\t\t\t.getKeyedResultList(_keyedPage);\n");
                    this.annotationMetaEntity.importType("jakarta.data.page.PageRequest");
                    this.annotationMetaEntity.importType("jakarta.data.page.PageRequest.Cursor");
                    this.annotationMetaEntity.importType("jakarta.data.page.impl.CursoredPageRecord");
                    String fragment = MAKE_KEYED_SLICE.replace("pageRequest", AbstractQueryMethod.parameterName("jakarta.data.page.PageRequest", paramTypes, this.paramNames)).replace("Entity", this.annotationMetaEntity.importType(this.returnTypeName));
                    declaration.append(fragment);
                    break;
                }
                default: {
                    if (this.isUsingEntityManager() && !unwrapped && mustUnwrap) {
                        declaration.append("\t\t\t.unwrap(").append(this.annotationMetaEntity.importType(containerType)).append(".class);");
                        break;
                    }
                    int lastIndex = declaration.length() - 1;
                    if (declaration.charAt(lastIndex) == '\n') {
                        declaration.setLength(lastIndex);
                    }
                    declaration.append(';');
                }
            }
        }
        declaration.append('\n');
    }

    private static @UnknownKeyFor @NonNull @Initialized String parameterName(@UnknownKeyFor @NonNull @Initialized String paramType, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramNames) {
        for (int i = 0; i < paramTypes.size(); ++i) {
            if (!paramTypes.get(i).startsWith(paramType)) continue;
            return paramNames.get(i);
        }
        throw new AssertionFailure("could not find parameter");
    }
}

