/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.annotation;

import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.hibernate.AssertionFailure;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.processor.Context;
import org.hibernate.processor.ImportContextImpl;
import org.hibernate.processor.ProcessLaterException;
import org.hibernate.processor.annotation.AbstractQueryMethod;
import org.hibernate.processor.annotation.AnnotationMeta;
import org.hibernate.processor.annotation.AnnotationMetaAttribute;
import org.hibernate.processor.annotation.AnnotationMetaType;
import org.hibernate.processor.annotation.CriteriaFinderMethod;
import org.hibernate.processor.annotation.DataAnnotationMetaAttribute;
import org.hibernate.processor.annotation.DataMetaAttributeGenerationVisitor;
import org.hibernate.processor.annotation.DefaultConstructor;
import org.hibernate.processor.annotation.ErrorHandler;
import org.hibernate.processor.annotation.IdFinderMethod;
import org.hibernate.processor.annotation.LifecycleMethod;
import org.hibernate.processor.annotation.MetaAttributeGenerationVisitor;
import org.hibernate.processor.annotation.NaturalIdFinderMethod;
import org.hibernate.processor.annotation.OrderBy;
import org.hibernate.processor.annotation.QueryMethod;
import org.hibernate.processor.annotation.RepositoryConstructor;
import org.hibernate.processor.model.ImportContext;
import org.hibernate.processor.model.MetaAttribute;
import org.hibernate.processor.model.Metamodel;
import org.hibernate.processor.util.AccessType;
import org.hibernate.processor.util.AccessTypeInformation;
import org.hibernate.processor.util.NullnessUtil;
import org.hibernate.processor.util.TypeUtils;
import org.hibernate.processor.validation.ProcessorSessionFactory;
import org.hibernate.processor.validation.Validation;
import org.hibernate.query.criteria.JpaEntityJoin;
import org.hibernate.query.criteria.JpaRoot;
import org.hibernate.query.criteria.JpaSelection;
import org.hibernate.query.sql.internal.ParameterParser;
import org.hibernate.query.sql.spi.ParameterRecognizer;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;

public class AnnotationMetaEntity
extends AnnotationMeta {
    private final @UnknownKeyFor @NonNull @Initialized ImportContext importContext;
    private final @UnknownKeyFor @NonNull @Initialized TypeElement element;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized MetaAttribute> members;
    private final @UnknownKeyFor @NonNull @Initialized Context context;
    private final @UnknownKeyFor @NonNull @Initialized boolean managed;
    private @UnknownKeyFor @NonNull @Initialized boolean jakartaDataRepository;
    private final @UnknownKeyFor @NonNull @Initialized boolean quarkusInjection;
    private @UnknownKeyFor @NonNull @Initialized String qualifiedName;
    private final @UnknownKeyFor @NonNull @Initialized boolean jakartaDataStaticModel;
    private @UnknownKeyFor @NonNull @Initialized AccessTypeInformation entityAccessTypeInfo;
    private @UnknownKeyFor @NonNull @Initialized boolean initialized;
    private @UnknownKeyFor @NonNull @Initialized Metamodel entityToMerge;
    private @UnknownKeyFor @NonNull @Initialized boolean repository = false;
    private @UnknownKeyFor @NonNull @Initialized String sessionType = "jakarta.persistence.EntityManager";
    private @UnknownKeyFor @NonNull @Initialized String sessionGetter = "entityManager";
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> memberTypes = new HashMap<String, String>();
    private static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> LEGAL_RAW_RESULT_TYPES = Set.of("java.util.List", "jakarta.persistence.Query", "org.hibernate.query.Query");
    private static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> LEGAL_GENERIC_RESULT_TYPES = Set.of("java.util.List", "java.util.stream.Stream", "java.util.Optional", "jakarta.persistence.TypedQuery", "org.hibernate.query.Query", "org.hibernate.query.SelectionQuery", "org.hibernate.query.KeyedResultList", "jakarta.data.page.Page", "jakarta.data.page.CursoredPage");

    public AnnotationMetaEntity(@UnknownKeyFor @NonNull @Initialized TypeElement element, @UnknownKeyFor @NonNull @Initialized Context context, @UnknownKeyFor @NonNull @Initialized boolean managed, @UnknownKeyFor @NonNull @Initialized boolean jakartaDataStaticMetamodel) {
        this.element = element;
        this.context = context;
        this.managed = managed;
        this.members = new HashMap<String, MetaAttribute>();
        this.quarkusInjection = context.isQuarkusInjection();
        this.importContext = new ImportContextImpl(AnnotationMetaEntity.getPackageName(context, element));
        this.jakartaDataStaticModel = jakartaDataStaticMetamodel;
    }

    public static @UnknownKeyFor @NonNull @Initialized AnnotationMetaEntity create(@UnknownKeyFor @NonNull @Initialized TypeElement element, @UnknownKeyFor @NonNull @Initialized Context context) {
        return AnnotationMetaEntity.create(element, context, false, false, false);
    }

    public static @UnknownKeyFor @NonNull @Initialized AnnotationMetaEntity create(@UnknownKeyFor @NonNull @Initialized TypeElement element, @UnknownKeyFor @NonNull @Initialized Context context, @UnknownKeyFor @NonNull @Initialized boolean lazilyInitialised, @UnknownKeyFor @NonNull @Initialized boolean managed, @UnknownKeyFor @NonNull @Initialized boolean jakartaData) {
        AnnotationMetaEntity annotationMetaEntity = new AnnotationMetaEntity(element, context, managed, jakartaData);
        if (!lazilyInitialised) {
            annotationMetaEntity.init();
        }
        return annotationMetaEntity;
    }

    public @Nullable @UnknownKeyFor @Initialized String getMemberType(@UnknownKeyFor @NonNull @Initialized String entityType, @UnknownKeyFor @NonNull @Initialized String memberName) {
        return this.memberTypes.get(StringHelper.qualify((String)entityType, (String)memberName));
    }

    public @UnknownKeyFor @NonNull @Initialized AccessTypeInformation getEntityAccessTypeInfo() {
        return this.entityAccessTypeInfo;
    }

    @Override
    public final @UnknownKeyFor @NonNull @Initialized Context getContext() {
        return this.context;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isImplementation() {
        return this.repository;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isJakartaDataStyle() {
        return this.jakartaDataStaticModel;
    }

    @Override
    public final @UnknownKeyFor @NonNull @Initialized String getSimpleName() {
        return this.element.getSimpleName().toString();
    }

    @Override
    public final @UnknownKeyFor @NonNull @Initialized String getQualifiedName() {
        if (this.qualifiedName == null) {
            this.qualifiedName = this.element.getQualifiedName().toString();
        }
        return this.qualifiedName;
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized String getSupertypeName() {
        return TypeUtils.findMappedSuperClass(this, this.context);
    }

    @Override
    public final @UnknownKeyFor @NonNull @Initialized String getPackageName() {
        return AnnotationMetaEntity.getPackageName(this.context, this.element);
    }

    private static @UnknownKeyFor @NonNull @Initialized String getPackageName(@UnknownKeyFor @NonNull @Initialized Context context, @UnknownKeyFor @NonNull @Initialized TypeElement element) {
        return context.getElementUtils().getPackageOf(element).getQualifiedName().toString();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized MetaAttribute> getMembers() {
        if (!this.initialized) {
            this.init();
            if (this.entityToMerge != null) {
                this.mergeInMembers(this.entityToMerge.getMembers());
            }
        }
        return new ArrayList<MetaAttribute>(this.members.values());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isMetaComplete() {
        return false;
    }

    private void mergeInMembers(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized MetaAttribute> attributes) {
        for (MetaAttribute attribute : attributes) {
            this.importType(attribute.getMetaType());
            this.importType(attribute.getTypeDeclaration());
            this.members.put(attribute.getPropertyName(), attribute);
        }
    }

    public void mergeInMembers(@UnknownKeyFor @NonNull @Initialized Metamodel other) {
        if (!this.initialized) {
            this.entityToMerge = other;
        } else {
            this.mergeInMembers(other.getMembers());
        }
    }

    @Override
    public final @UnknownKeyFor @NonNull @Initialized String generateImports() {
        return this.importContext.generateImports();
    }

    @Override
    public final @UnknownKeyFor @NonNull @Initialized String importType(@UnknownKeyFor @NonNull @Initialized String fqcn) {
        return this.importContext.importType(fqcn);
    }

    @Override
    public final @UnknownKeyFor @NonNull @Initialized String staticImport(@UnknownKeyFor @NonNull @Initialized String fqcn, @UnknownKeyFor @NonNull @Initialized String member) {
        return this.importContext.staticImport(fqcn, member);
    }

    @Override
    public final @UnknownKeyFor @NonNull @Initialized TypeElement getElement() {
        return this.element;
    }

    @Override
    void putMember(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized MetaAttribute nameMetaAttribute) {
        this.members.put(name, nameMetaAttribute);
    }

    @Override
    @UnknownKeyFor @NonNull @Initialized boolean isRepository() {
        return this.repository;
    }

    @Override
    @UnknownKeyFor @NonNull @Initialized String getSessionType() {
        return this.sessionType;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isInjectable() {
        return this.repository;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String scope() {
        if (this.jakartaDataRepository && !this.quarkusInjection) {
            return this.context.addTransactionScopedAnnotation() ? "javax.transaction.TransactionScoped" : "jakarta.enterprise.context.RequestScoped";
        }
        return "jakarta.enterprise.context.Dependent";
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "AnnotationMetaEntity" + "{element=" + this.element + ", members=" + this.members + '}';
    }

    protected final void init() {
        this.getContext().logMessage(Diagnostic.Kind.OTHER, "Initializing type '" + this.getQualifiedName() + "'");
        TypeUtils.determineAccessTypeForHierarchy(this.element, this.context);
        this.entityAccessTypeInfo = NullnessUtil.castNonNull(this.context.getAccessTypeInfo(this.getQualifiedName()));
        List<VariableElement> fieldsOfClass = ElementFilter.fieldsIn(this.element.getEnclosedElements());
        List<ExecutableElement> methodsOfClass = ElementFilter.methodsIn(this.element.getEnclosedElements());
        ArrayList<ExecutableElement> gettersAndSettersOfClass = new ArrayList<ExecutableElement>();
        ArrayList<ExecutableElement> queryMethods = new ArrayList<ExecutableElement>();
        ArrayList<ExecutableElement> lifecycleMethods = new ArrayList<ExecutableElement>();
        for (ExecutableElement method : methodsOfClass) {
            if (this.isGetterOrSetter(method)) {
                gettersAndSettersOfClass.add(method);
                continue;
            }
            if (TypeUtils.containsAnnotation(method, "org.hibernate.annotations.processing.HQL", "org.hibernate.annotations.processing.SQL", "jakarta.data.repository.Query", "org.hibernate.annotations.processing.Find", "jakarta.data.repository.Find")) {
                queryMethods.add(method);
                continue;
            }
            if (!TypeUtils.containsAnnotation(method, "jakarta.data.repository.Insert", "jakarta.data.repository.Update", "jakarta.data.repository.Delete", "jakarta.data.repository.Save")) continue;
            lifecycleMethods.add(method);
        }
        this.setupSession();
        if (this.managed && !this.jakartaDataStaticModel) {
            this.putMember("class", new AnnotationMetaType(this));
        }
        this.addPersistentMembers(fieldsOfClass, AccessType.FIELD);
        this.addPersistentMembers(gettersAndSettersOfClass, AccessType.PROPERTY);
        this.addAuxiliaryMembers();
        this.checkNamedQueries();
        this.addLifecycleMethods(lifecycleMethods);
        this.addQueryMethods(queryMethods);
        this.initialized = true;
    }

    private void addDefaultConstructor() {
        String sessionVariableName = this.getSessionVariableName(this.sessionType);
        String typeName = this.element.getSimpleName().toString() + "_";
        this.putMember("_", new DefaultConstructor(this, typeName, sessionVariableName, this.sessionType, sessionVariableName, this.dataStore(), this.context.addInjectAnnotation()));
    }

    private @Nullable @UnknownKeyFor @Initialized String dataStore() {
        String dataStore;
        AnnotationMirror repo = TypeUtils.getAnnotationMirror(this.element, "jakarta.data.repository.Repository");
        if (repo != null && (dataStore = (String)TypeUtils.getAnnotationValue(repo, "dataStore")) != null && !dataStore.isEmpty()) {
            return dataStore;
        }
        return null;
    }

    private void setupSession() {
        this.jakartaDataRepository = TypeUtils.hasAnnotation((Element)this.element, "jakarta.data.repository.Repository");
        ExecutableElement getter = this.findSessionGetter(this.element);
        if (getter != null) {
            if (!this.isPanacheType(this.element)) {
                this.repository = true;
                this.sessionType = this.addDaoConstructor(getter);
            } else {
                this.sessionType = getter.getReturnType().toString();
            }
        } else if (this.element.getKind() == ElementKind.INTERFACE && (this.context.usesQuarkusOrm() || this.context.usesQuarkusReactive())) {
            this.repository = true;
            this.sessionType = this.setupQuarkusDaoConstructor();
        }
        if (!this.repository && this.jakartaDataRepository) {
            this.repository = true;
            this.sessionType = "org.hibernate.StatelessSession";
            this.addDaoConstructor(null);
        }
        if (this.jakartaDataRepository && !this.quarkusInjection) {
            this.addDefaultConstructor();
        }
    }

    private @Nullable @UnknownKeyFor @Initialized ExecutableElement findSessionGetter(@UnknownKeyFor @NonNull @Initialized TypeElement type) {
        if (!TypeUtils.hasAnnotation((Element)type, "jakarta.persistence.Entity", "jakarta.persistence.MappedSuperclass", "jakarta.persistence.Embeddable") || this.isPanacheType(type)) {
            DeclaredType declaredType;
            ExecutableElement executableElement;
            for (ExecutableElement method : ElementFilter.methodsIn(type.getEnclosedElements())) {
                if (!AnnotationMetaEntity.isSessionGetter(method)) continue;
                return method;
            }
            TypeMirror superclass = type.getSuperclass();
            if (superclass.getKind() == TypeKind.DECLARED && (executableElement = this.findSessionGetter((TypeElement)(declaredType = (DeclaredType)superclass).asElement())) != null) {
                return executableElement;
            }
            for (TypeMirror typeMirror : type.getInterfaces()) {
                DeclaredType declaredType2;
                ExecutableElement ret2;
                if (typeMirror.getKind() != TypeKind.DECLARED || (ret2 = this.findSessionGetter((TypeElement)(declaredType2 = (DeclaredType)typeMirror).asElement())) == null) continue;
                return ret2;
            }
        }
        return null;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isPanacheType(@UnknownKeyFor @NonNull @Initialized TypeElement type) {
        return this.isOrmPanacheType(type) || this.isReactivePanacheType(type);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isOrmPanacheType(@UnknownKeyFor @NonNull @Initialized TypeElement type) {
        ProcessingEnvironment processingEnvironment = this.context.getProcessingEnvironment();
        Elements elements = processingEnvironment.getElementUtils();
        TypeElement panacheRepositorySuperType = elements.getTypeElement("io.quarkus.hibernate.orm.panache.PanacheRepositoryBase");
        TypeElement panacheEntitySuperType = elements.getTypeElement("io.quarkus.hibernate.orm.panache.PanacheEntityBase");
        if (panacheRepositorySuperType == null || panacheEntitySuperType == null) {
            return false;
        }
        Types types = processingEnvironment.getTypeUtils();
        return types.isSubtype(type.asType(), types.getDeclaredType(panacheRepositorySuperType, new TypeMirror[0])) || types.isSubtype(type.asType(), panacheEntitySuperType.asType());
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isReactivePanacheType(@UnknownKeyFor @NonNull @Initialized TypeElement type) {
        ProcessingEnvironment processingEnvironment = this.context.getProcessingEnvironment();
        Elements elements = processingEnvironment.getElementUtils();
        TypeElement panacheRepositorySuperType = elements.getTypeElement("io.quarkus.hibernate.reactive.panache.PanacheRepositoryBase");
        TypeElement panacheEntitySuperType = elements.getTypeElement("io.quarkus.hibernate.reactive.panache.PanacheEntityBase");
        if (panacheRepositorySuperType == null || panacheEntitySuperType == null) {
            return false;
        }
        Types types = processingEnvironment.getTypeUtils();
        return types.isSubtype(type.asType(), types.getDeclaredType(panacheRepositorySuperType, new TypeMirror[0])) || types.isSubtype(type.asType(), panacheEntitySuperType.asType());
    }

    private @UnknownKeyFor @NonNull @Initialized String addDaoConstructor(@Nullable @UnknownKeyFor @Initialized ExecutableElement method) {
        String sessionType = method == null ? this.sessionType : method.getReturnType().toString();
        String sessionVariableName = this.getSessionVariableName(sessionType);
        String name = method == null ? sessionVariableName : method.getSimpleName().toString();
        String typeName = this.element.getSimpleName().toString() + "_";
        if (method == null || !method.isDefault()) {
            this.putMember(name, new RepositoryConstructor(this, typeName, name, sessionType, sessionVariableName, this.dataStore(), this.context.addInjectAnnotation(), this.context.addNonnullAnnotation(), method != null, this.jakartaDataRepository, this.quarkusInjection));
        } else {
            this.sessionGetter = method.getSimpleName() + "()";
        }
        return sessionType;
    }

    private @UnknownKeyFor @NonNull @Initialized String setupQuarkusDaoConstructor() {
        String typeName = this.element.getSimpleName().toString() + "_";
        String sessionVariableName = this.getSessionVariableName(this.sessionType);
        if (this.context.usesQuarkusOrm()) {
            String name = "getEntityManager";
            this.putMember(name, new RepositoryConstructor(this, typeName, name, this.sessionType, sessionVariableName, this.dataStore(), this.context.addInjectAnnotation(), this.context.addNonnullAnnotation(), false, false, true));
            return "jakarta.persistence.EntityManager";
        }
        this.importType("io.quarkus.hibernate.reactive.panache.common.runtime.SessionOperations");
        this.sessionGetter = "SessionOperations.getSession()";
        return "io.smallrye.mutiny.Uni<org.hibernate.reactive.mutiny.Mutiny.Session>";
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isSessionGetter(@UnknownKeyFor @NonNull @Initialized ExecutableElement method) {
        DeclaredType declaredType;
        Element element;
        TypeMirror returnType;
        if (method.getParameters().isEmpty() && (returnType = method.getReturnType()).getKind() == TypeKind.DECLARED && (element = (declaredType = (DeclaredType)AnnotationMetaEntity.ununi(returnType)).asElement()).getKind() == ElementKind.INTERFACE) {
            TypeElement typeElement = (TypeElement)element;
            Name name = typeElement.getQualifiedName();
            return name.contentEquals("org.hibernate.Session") || name.contentEquals("org.hibernate.StatelessSession") || name.contentEquals("org.hibernate.reactive.mutiny.Mutiny.Session") || name.contentEquals("jakarta.persistence.EntityManager");
        }
        return false;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isGetterOrSetter(@UnknownKeyFor @NonNull @Initialized Element methodOfClass) {
        TypeMirror returnType;
        List<? extends TypeMirror> methodParameterTypes;
        ExecutableType methodType = (ExecutableType)methodOfClass.asType();
        Name methodSimpleName = methodOfClass.getSimpleName();
        return AnnotationMetaEntity.isSetter(methodSimpleName, methodParameterTypes = methodType.getParameterTypes(), returnType = methodType.getReturnType()) || AnnotationMetaEntity.isGetter(methodSimpleName, methodParameterTypes, returnType);
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean hasPrefix(@UnknownKeyFor @NonNull @Initialized Name methodSimpleName, @UnknownKeyFor @NonNull @Initialized String prefix) {
        int prefixLength = prefix.length();
        if (methodSimpleName.length() > prefixLength) {
            for (int i = 0; i < prefixLength; ++i) {
                if (methodSimpleName.charAt(i) == prefix.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isGetter(@UnknownKeyFor @NonNull @Initialized Name methodSimpleName, @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized TypeMirror> methodParameterTypes, @UnknownKeyFor @NonNull @Initialized TypeMirror returnType) {
        return (AnnotationMetaEntity.hasPrefix(methodSimpleName, "get") || AnnotationMetaEntity.hasPrefix(methodSimpleName, "is")) && methodParameterTypes.isEmpty() && returnType.getKind() != TypeKind.VOID;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isSetter(@UnknownKeyFor @NonNull @Initialized Name methodSimpleName, @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized TypeMirror> methodParameterTypes, @UnknownKeyFor @NonNull @Initialized TypeMirror returnType) {
        return AnnotationMetaEntity.hasPrefix(methodSimpleName, "set") && methodParameterTypes.size() == 1 && returnType.getKind() != TypeKind.VOID;
    }

    private void addPersistentMembers(@UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Element> membersOfClass, @UnknownKeyFor @NonNull @Initialized AccessType membersKind) {
        for (Element element : membersOfClass) {
            if (!this.isPersistent(element, membersKind)) continue;
            if (this.jakartaDataStaticModel) {
                DataAnnotationMetaAttribute dataMetaAttribute = element.asType().accept(new DataMetaAttributeGenerationVisitor(this, this.context), element);
                if (dataMetaAttribute == null) continue;
                this.members.put("_" + dataMetaAttribute.getPropertyName(), dataMetaAttribute);
                continue;
            }
            AnnotationMetaAttribute jpaMetaAttribute = element.asType().accept(new MetaAttributeGenerationVisitor(this, this.context), element);
            if (jpaMetaAttribute == null) continue;
            this.members.put(jpaMetaAttribute.getPropertyName(), jpaMetaAttribute);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isPersistent(@UnknownKeyFor @NonNull @Initialized Element memberOfClass, @UnknownKeyFor @NonNull @Initialized AccessType membersKind) {
        return !(this.entityAccessTypeInfo.getAccessType() != membersKind && TypeUtils.determineAnnotationSpecifiedAccessType(memberOfClass) == null || TypeUtils.containsAnnotation(memberOfClass, "jakarta.persistence.Transient") || memberOfClass.getModifiers().contains((Object)Modifier.TRANSIENT) || memberOfClass.getModifiers().contains((Object)Modifier.STATIC) || memberOfClass.getKind() == ElementKind.METHOD && AnnotationMetaEntity.isSessionGetter((ExecutableElement)memberOfClass));
    }

    private void addLifecycleMethods(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ExecutableElement> queryMethods) {
        for (ExecutableElement method : queryMethods) {
            if (!method.getModifiers().contains((Object)Modifier.ABSTRACT) || !TypeUtils.hasAnnotation((Element)method, "jakarta.data.repository.Insert", "jakarta.data.repository.Update", "jakarta.data.repository.Delete", "jakarta.data.repository.Save")) continue;
            this.addLifecycleMethod(method);
        }
    }

    private void addQueryMethods(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ExecutableElement> queryMethods) {
        for (ExecutableElement method : queryMethods) {
            Set<Modifier> modifiers = method.getModifiers();
            if (!modifiers.contains((Object)Modifier.ABSTRACT) && !modifiers.contains((Object)Modifier.NATIVE)) continue;
            this.addQueryMethod(method);
        }
    }

    private void addQueryMethod(@UnknownKeyFor @NonNull @Initialized ExecutableElement method) {
        TypeMirror returnType = method.getReturnType();
        TypeKind kind = returnType.getKind();
        if (kind == TypeKind.VOID || kind == TypeKind.ARRAY || kind.isPrimitive()) {
            this.addQueryMethod(method, returnType, null);
        } else if (kind == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)AnnotationMetaEntity.ununi(returnType);
            TypeElement typeElement = (TypeElement)declaredType.asElement();
            List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
            switch (typeArguments.size()) {
                case 0: {
                    if (TypeUtils.containsAnnotation(declaredType.asElement(), "jakarta.persistence.Entity")) {
                        this.addQueryMethod(method, declaredType, null);
                        break;
                    }
                    if (AnnotationMetaEntity.isLegalRawResultType(typeElement.getQualifiedName().toString())) {
                        this.addQueryMethod(method, null, typeElement);
                        break;
                    }
                    this.addQueryMethod(method, declaredType, null);
                    break;
                }
                case 1: {
                    if (!this.validatedQueryReturnType(method, typeElement)) break;
                    this.addQueryMethod(method, typeArguments.get(0), typeElement);
                    break;
                }
                default: {
                    this.context.message(method, "incorrect return type '" + declaredType + "'", Diagnostic.Kind.ERROR);
                }
            }
        }
    }

    private @UnknownKeyFor @NonNull @Initialized boolean validatedQueryReturnType(@UnknownKeyFor @NonNull @Initialized ExecutableElement method, @UnknownKeyFor @NonNull @Initialized TypeElement typeElement) {
        String typeName;
        switch (typeName = typeElement.getQualifiedName().toString()) {
            case "jakarta.data.page.Page": 
            case "jakarta.data.page.CursoredPage": {
                if (method.getParameters().stream().noneMatch(param -> param.asType().toString().startsWith("jakarta.data.page.PageRequest"))) {
                    this.context.message(method, "method with return type '" + typeName + "' has no parameter of type 'PageRequest'", Diagnostic.Kind.ERROR);
                    return false;
                }
                return true;
            }
            case "org.hibernate.query.KeyedResultList": {
                if (method.getParameters().stream().noneMatch(param -> param.asType().toString().startsWith("org.hibernate.query.KeyedPage"))) {
                    this.context.message(method, "method with return type '" + typeName + "' has no parameter of type 'KeyedPage'", Diagnostic.Kind.ERROR);
                    return false;
                }
                return true;
            }
        }
        if (AnnotationMetaEntity.isLegalGenericResultType(typeName)) {
            return true;
        }
        this.context.message(method, "incorrect return type '" + typeName + "'", Diagnostic.Kind.ERROR);
        return false;
    }

    private static @UnknownKeyFor @NonNull @Initialized TypeMirror ununi(@UnknownKeyFor @NonNull @Initialized TypeMirror returnType) {
        DeclaredType declaredType;
        TypeElement typeElement;
        if (returnType.getKind() == TypeKind.DECLARED && (typeElement = (TypeElement)(declaredType = (DeclaredType)returnType).asElement()).getQualifiedName().contentEquals("io.smallrye.mutiny.Uni")) {
            return declaredType.getTypeArguments().get(0);
        }
        return returnType;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isLegalRawResultType(@UnknownKeyFor @NonNull @Initialized String containerTypeName) {
        return LEGAL_RAW_RESULT_TYPES.contains(containerTypeName);
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isLegalGenericResultType(@UnknownKeyFor @NonNull @Initialized String containerTypeName) {
        return LEGAL_GENERIC_RESULT_TYPES.contains(containerTypeName);
    }

    private void addQueryMethod(@UnknownKeyFor @NonNull @Initialized ExecutableElement method, @Nullable @UnknownKeyFor @Initialized TypeMirror returnType, @Nullable @UnknownKeyFor @Initialized TypeElement containerType) {
        AnnotationMirror jdql;
        AnnotationMirror sql;
        AnnotationMirror hql = TypeUtils.getAnnotationMirror(method, "org.hibernate.annotations.processing.HQL");
        if (hql != null) {
            this.addQueryMethod(method, returnType, containerType, hql, false);
        }
        if ((sql = TypeUtils.getAnnotationMirror(method, "org.hibernate.annotations.processing.SQL")) != null) {
            this.addQueryMethod(method, returnType, containerType, sql, true);
        }
        if ((jdql = TypeUtils.getAnnotationMirror(method, "jakarta.data.repository.Query")) != null) {
            this.addQueryMethod(method, returnType, containerType, jdql, false);
        }
        if (TypeUtils.hasAnnotation((Element)method, "org.hibernate.annotations.processing.Find", "jakarta.data.repository.Find")) {
            this.addFinderMethod(method, returnType, containerType);
        }
    }

    private void addLifecycleMethod(@UnknownKeyFor @NonNull @Initialized ExecutableElement method) {
        TypeMirror returnType = method.getReturnType();
        if (!"org.hibernate.StatelessSession".equals(this.sessionType)) {
            this.context.message(method, "repository must be backed by a 'StatelessSession'", Diagnostic.Kind.ERROR);
        } else if (method.getParameters().size() != 1) {
            this.context.message(method, "must have exactly one parameter", Diagnostic.Kind.ERROR);
        } else if (returnType == null) {
            this.context.message(method, "must be declared 'void'", Diagnostic.Kind.ERROR);
        } else {
            boolean returnArgument = returnType.getKind() != TypeKind.VOID;
            String operation = AnnotationMetaEntity.lifecycleOperation(method);
            VariableElement parameter = method.getParameters().get(0);
            TypeMirror parameterType = parameter.asType();
            DeclaredType declaredType = this.entityType(parameterType);
            if (declaredType == null) {
                this.context.message(parameter, "incorrect parameter type '" + parameterType + "' is not an entity type", Diagnostic.Kind.ERROR);
            } else if (!TypeUtils.containsAnnotation(declaredType.asElement(), "jakarta.persistence.Entity")) {
                this.context.message(parameter, "incorrect parameter type '" + parameterType + "' is not annotated '@Entity'", Diagnostic.Kind.ERROR);
            } else if (returnArgument && !this.context.getTypeUtils().isSameType(returnType, parameterType)) {
                this.context.message(parameter, "return type '" + returnType + "' disagrees with parameter type '" + parameterType + "'", Diagnostic.Kind.ERROR);
            } else {
                String entity = parameterType.toString();
                String methodName = method.getSimpleName().toString();
                this.putMember(methodName + "." + entity, new LifecycleMethod(this, entity, methodName, parameter.getSimpleName().toString(), this.getSessionVariableName(), operation, this.context.addNonnullAnnotation(), declaredType != parameterType, returnArgument));
            }
        }
    }

    private @Nullable @UnknownKeyFor @Initialized DeclaredType entityType(@UnknownKeyFor @NonNull @Initialized TypeMirror parameterType) {
        switch (parameterType.getKind()) {
            case DECLARED: {
                DeclaredType declaredType = (DeclaredType)parameterType;
                Types types = this.context.getTypeUtils();
                Elements elements = this.context.getElementUtils();
                if (types.isAssignable(declaredType, types.erasure(elements.getTypeElement("java.lang.Iterable").asType())) && !declaredType.getTypeArguments().isEmpty()) {
                    TypeMirror elementType = declaredType.getTypeArguments().get(0);
                    return elementType.getKind() == TypeKind.DECLARED ? (DeclaredType)elementType : null;
                }
                return declaredType;
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)parameterType;
                TypeMirror componentType = arrayType.getComponentType();
                return componentType.getKind() == TypeKind.DECLARED ? (DeclaredType)componentType : null;
            }
        }
        return null;
    }

    private static @UnknownKeyFor @NonNull @Initialized String lifecycleOperation(@UnknownKeyFor @NonNull @Initialized ExecutableElement method) {
        if (TypeUtils.hasAnnotation((Element)method, "jakarta.data.repository.Insert")) {
            return "insert";
        }
        if (TypeUtils.hasAnnotation((Element)method, "jakarta.data.repository.Update")) {
            return "update";
        }
        if (TypeUtils.hasAnnotation((Element)method, "jakarta.data.repository.Delete")) {
            return "delete";
        }
        if (TypeUtils.hasAnnotation((Element)method, "jakarta.data.repository.Save")) {
            return "upsert";
        }
        throw new AssertionFailure("Unrecognized lifecycle operation");
    }

    private void addFinderMethod(@UnknownKeyFor @NonNull @Initialized ExecutableElement method, @Nullable @UnknownKeyFor @Initialized TypeMirror returnType, @Nullable @UnknownKeyFor @Initialized TypeElement containerType) {
        if (returnType == null) {
            this.context.message(method, "missing return type", Diagnostic.Kind.ERROR);
        } else if (returnType.getKind() == TypeKind.ARRAY) {
            ArrayType arrayType = (ArrayType)returnType;
            TypeMirror componentType = arrayType.getComponentType();
            if (componentType.getKind() != TypeKind.DECLARED) {
                this.context.message(method, "incorrect return type '" + returnType + "' is not an array with entity elements", Diagnostic.Kind.ERROR);
            } else {
                DeclaredType declaredType = (DeclaredType)componentType;
                TypeElement typeElement = (TypeElement)declaredType.asElement();
                if (!TypeUtils.containsAnnotation(typeElement, "jakarta.persistence.Entity")) {
                    this.context.message(method, "incorrect return type '" + returnType + "' is not annotated '@Entity'", Diagnostic.Kind.ERROR);
                } else {
                    this.createCriteriaFinder(method, arrayType.getComponentType(), "[]", typeElement);
                }
            }
        } else if (returnType.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)AnnotationMetaEntity.ununi(returnType);
            TypeElement entity = (TypeElement)declaredType.asElement();
            if (!TypeUtils.containsAnnotation(entity, "jakarta.persistence.Entity")) {
                this.context.message(method, "incorrect return type '" + declaredType + "' is not annotated '@Entity'", Diagnostic.Kind.ERROR);
            } else if (containerType != null) {
                this.createCriteriaFinder(method, declaredType, containerType.toString(), entity);
            } else {
                for (VariableElement variableElement : method.getParameters()) {
                    String type = variableElement.asType().toString();
                    if (QueryMethod.isPageParam(type)) {
                        this.context.message(variableElement, "pagination would have no effect", Diagnostic.Kind.ERROR);
                        continue;
                    }
                    if (!QueryMethod.isOrderParam(type)) continue;
                    this.context.message(variableElement, "ordering would have no effect", Diagnostic.Kind.ERROR);
                }
                long parameterCount = method.getParameters().stream().filter(AnnotationMetaEntity::isFinderParameterMappingToAttribute).count();
                switch ((int)parameterCount) {
                    case 0: {
                        this.context.message(method, "missing parameter", Diagnostic.Kind.ERROR);
                        break;
                    }
                    case 1: {
                        this.createSingleParameterFinder(method, declaredType, entity);
                        break;
                    }
                    default: {
                        this.createMultipleParameterFinder(method, declaredType, entity);
                    }
                }
            }
        } else {
            this.context.message(method, "incorrect return type '" + returnType + "' is not an entity type", Diagnostic.Kind.ERROR);
        }
    }

    private void createCriteriaFinder(@UnknownKeyFor @NonNull @Initialized ExecutableElement method, @UnknownKeyFor @NonNull @Initialized TypeMirror returnType, @Nullable @UnknownKeyFor @Initialized String containerType, @UnknownKeyFor @NonNull @Initialized TypeElement entity) {
        String methodName = method.getSimpleName().toString();
        List<String> paramNames = this.parameterNames(method, entity);
        List<String> paramTypes = AnnotationMetaEntity.parameterTypes(method);
        List<Boolean> paramPatterns = AnnotationMetaEntity.parameterPatterns(method);
        String[] sessionType = this.sessionTypeFromParameters(paramNames, paramTypes);
        String methodKey = methodName + paramTypes;
        ArrayList<Boolean> multivalued = new ArrayList<Boolean>();
        for (VariableElement variableElement : method.getParameters()) {
            if (AnnotationMetaEntity.isFinderParameterMappingToAttribute(variableElement)) {
                multivalued.add(this.validateFinderParameter(entity, variableElement) == FieldType.MULTIVALUED);
                continue;
            }
            multivalued.add(false);
            Types types = this.context.getTypeUtils();
            TypeMirror parameterType = variableElement.asType();
            String type = parameterType.toString();
            boolean pageRequest = type.startsWith("jakarta.data.page.PageRequest");
            if (!QueryMethod.isOrderParam(type) && !pageRequest) continue;
            TypeMirror typeArgument = AnnotationMetaEntity.getTypeArgument(parameterType);
            if (typeArgument == null) {
                this.missingTypeArgError(entity.getSimpleName().toString(), variableElement, pageRequest);
                continue;
            }
            if (types.isSameType(typeArgument, entity.asType())) continue;
            this.wrongTypeArgError(entity.getSimpleName().toString(), variableElement, pageRequest);
        }
        this.putMember(methodKey, new CriteriaFinderMethod(this, methodName, returnType.toString(), containerType, paramNames, paramTypes, this.parameterNullability(method, entity), multivalued, paramPatterns, this.repository, sessionType[0], sessionType[1], AnnotationMetaEntity.enabledFetchProfiles(method), this.orderByList(method, entity), this.context.addNonnullAnnotation(), this.jakartaDataRepository));
    }

    private void wrongTypeArgError(@UnknownKeyFor @NonNull @Initialized String entity, @UnknownKeyFor @NonNull @Initialized VariableElement parameter, @UnknownKeyFor @NonNull @Initialized boolean pageRequest) {
        this.context.message(parameter, (pageRequest ? "mismatched type of page request (should be 'PageRequest<? super " : "mismatched type of order (should be 'Order<? super ") + entity + ">')", Diagnostic.Kind.ERROR);
    }

    private void missingTypeArgError(@UnknownKeyFor @NonNull @Initialized String entity, @UnknownKeyFor @NonNull @Initialized VariableElement parameter, @UnknownKeyFor @NonNull @Initialized boolean pageRequest) {
        this.context.message(parameter, (pageRequest ? "missing type of page request (should be 'PageRequest<? super " : "missing type of order (should be 'Order<? super ") + entity + ">')", Diagnostic.Kind.ERROR);
    }

    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized OrderBy> orderByList(@UnknownKeyFor @NonNull @Initialized ExecutableElement method, @UnknownKeyFor @NonNull @Initialized TypeElement entityType) {
        AnnotationMirror orderByList = TypeUtils.getAnnotationMirror(method, "jakarta.data.repository.OrderBy.List");
        if (orderByList != null) {
            ArrayList<OrderBy> result = new ArrayList<OrderBy>();
            List list = (List)NullnessUtil.castNonNull(TypeUtils.getAnnotationValue(orderByList, "value"));
            for (AnnotationValue element : list) {
                result.add(this.orderByExpression(NullnessUtil.castNonNull((AnnotationMirror)element.getValue()), entityType, method));
            }
            return result;
        }
        AnnotationMirror orderBy = TypeUtils.getAnnotationMirror(method, "jakarta.data.repository.OrderBy");
        if (orderBy != null) {
            return List.of(this.orderByExpression(orderBy, entityType, method));
        }
        return Collections.emptyList();
    }

    private @UnknownKeyFor @NonNull @Initialized OrderBy orderByExpression(@UnknownKeyFor @NonNull @Initialized AnnotationMirror orderBy, @UnknownKeyFor @NonNull @Initialized TypeElement entityType, @UnknownKeyFor @NonNull @Initialized ExecutableElement method) {
        String fieldName = (String)NullnessUtil.castNonNull(TypeUtils.getAnnotationValue(orderBy, "value"));
        if (fieldName.equals("<error>")) {
            throw new ProcessLaterException();
        }
        Boolean descendingOrNull = (Boolean)TypeUtils.getAnnotationValue(orderBy, "descending");
        Boolean ignoreCaseOrNull = (Boolean)TypeUtils.getAnnotationValue(orderBy, "ignoreCase");
        boolean descending = descendingOrNull != null && descendingOrNull != false;
        boolean ignoreCase = ignoreCaseOrNull != null && ignoreCaseOrNull != false;
        String path = fieldName.replace('$', '.').replace('_', '.');
        if (this.memberMatchingPath(entityType, path) == null) {
            this.context.message(method, orderBy, "no matching field named '" + fieldName + "' in entity class '" + entityType.getQualifiedName() + "'", Diagnostic.Kind.ERROR);
        }
        return new OrderBy(path, descending, ignoreCase);
    }

    private static @Nullable @UnknownKeyFor @Initialized TypeMirror getTypeArgument(@UnknownKeyFor @NonNull @Initialized TypeMirror parameterType) {
        switch (parameterType.getKind()) {
            case ARRAY: {
                ArrayType arrayType = (ArrayType)parameterType;
                return AnnotationMetaEntity.getTypeArgument(arrayType.getComponentType());
            }
            case DECLARED: {
                Iterator<? extends TypeMirror> iterator;
                DeclaredType type = (DeclaredType)parameterType;
                String parameterTypeName = parameterType.toString();
                if (parameterTypeName.startsWith("java.util.List")) {
                    Iterator<? extends TypeMirror> iterator2 = type.getTypeArguments().iterator();
                    if (iterator2.hasNext()) {
                        TypeMirror arg = iterator2.next();
                        return AnnotationMetaEntity.getTypeArgument(arg);
                    }
                } else if ((parameterTypeName.startsWith("org.hibernate.query.Order") || parameterTypeName.startsWith("jakarta.data.Sort") || parameterTypeName.startsWith("jakarta.data.Order") || parameterTypeName.startsWith("jakarta.data.page.PageRequest")) && (iterator = type.getTypeArguments().iterator()).hasNext()) {
                    TypeMirror arg = iterator.next();
                    switch (arg.getKind()) {
                        case WILDCARD: {
                            return ((WildcardType)arg).getSuperBound();
                        }
                        case DECLARED: 
                        case ARRAY: 
                        case TYPEVAR: {
                            return arg;
                        }
                    }
                    return null;
                }
                return null;
            }
        }
        return null;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isFinderParameterMappingToAttribute(@UnknownKeyFor @NonNull @Initialized VariableElement param) {
        return !AbstractQueryMethod.isSpecialParam(param.asType().toString());
    }

    private @UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] sessionTypeFromParameters(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramNames, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes) {
        for (int i = 0; i < paramNames.size(); ++i) {
            String type = paramTypes.get(i);
            String name = paramNames.get(i);
            if (!AbstractQueryMethod.isSessionParameter(type)) continue;
            return new String[]{type, name};
        }
        return new String[]{this.getSessionType(), this.getSessionVariableName()};
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized String getSessionVariableName() {
        return this.getSessionVariableName(this.sessionType);
    }

    private @UnknownKeyFor @NonNull @Initialized String getSessionVariableName(@UnknownKeyFor @NonNull @Initialized String sessionType) {
        switch (sessionType) {
            case "org.hibernate.Session": 
            case "org.hibernate.StatelessSession": 
            case "org.hibernate.reactive.mutiny.Mutiny.Session": {
                return "session";
            }
        }
        return this.sessionGetter;
    }

    private static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> enabledFetchProfiles(@UnknownKeyFor @NonNull @Initialized ExecutableElement method) {
        AnnotationMirror findAnnotation = TypeUtils.getAnnotationMirror(method, "org.hibernate.annotations.processing.Find");
        if (findAnnotation == null) {
            return Collections.emptyList();
        }
        Object enabledFetchProfiles = TypeUtils.getAnnotationValue(findAnnotation, "enabledFetchProfiles");
        if (enabledFetchProfiles == null) {
            return Collections.emptyList();
        }
        List annotationValues = (List)enabledFetchProfiles;
        List<String> result = annotationValues.stream().map(AnnotationValue::toString).collect(Collectors.toList());
        if (result.stream().anyMatch("<error>"::equals)) {
            throw new ProcessLaterException();
        }
        return result;
    }

    private void createMultipleParameterFinder(@UnknownKeyFor @NonNull @Initialized ExecutableElement method, @UnknownKeyFor @NonNull @Initialized TypeMirror returnType, @UnknownKeyFor @NonNull @Initialized TypeElement entity) {
        String methodName = method.getSimpleName().toString();
        List<String> paramNames = this.parameterNames(method, entity);
        List<String> paramTypes = AnnotationMetaEntity.parameterTypes(method);
        String[] sessionType = this.sessionTypeFromParameters(paramNames, paramTypes);
        String methodKey = methodName + paramTypes;
        ArrayList<Boolean> multivalued = new ArrayList<Boolean>();
        ArrayList<@Nullable FieldType> fieldTypes = new ArrayList<FieldType>();
        for (VariableElement variableElement : method.getParameters()) {
            if (AnnotationMetaEntity.isFinderParameterMappingToAttribute(variableElement)) {
                FieldType fieldType = this.validateFinderParameter(entity, variableElement);
                fieldTypes.add(fieldType);
                multivalued.add(fieldType == FieldType.MULTIVALUED);
                continue;
            }
            multivalued.add(false);
        }
        if (!this.usingStatelessSession(sessionType[0]) && this.matchesNaturalKey(entity, fieldTypes)) {
            this.putMember(methodKey, new NaturalIdFinderMethod(this, methodName, returnType.toString(), paramNames, paramTypes, this.parameterNullability(method, entity), this.repository, sessionType[0], sessionType[1], AnnotationMetaEntity.enabledFetchProfiles(method), this.context.addNonnullAnnotation(), this.jakartaDataRepository));
        } else {
            List<Boolean> paramPatterns = AnnotationMetaEntity.parameterPatterns(method);
            this.putMember(methodKey, new CriteriaFinderMethod(this, methodName, returnType.toString(), null, paramNames, paramTypes, this.parameterNullability(method, entity), multivalued, paramPatterns, this.repository, sessionType[0], sessionType[1], AnnotationMetaEntity.enabledFetchProfiles(method), this.orderByList(method, entity), this.context.addNonnullAnnotation(), this.jakartaDataRepository));
        }
    }

    private void createSingleParameterFinder(@UnknownKeyFor @NonNull @Initialized ExecutableElement method, @UnknownKeyFor @NonNull @Initialized TypeMirror returnType, @UnknownKeyFor @NonNull @Initialized TypeElement entity) {
        String methodName = method.getSimpleName().toString();
        VariableElement parameter = method.getParameters().stream().filter(AnnotationMetaEntity::isFinderParameterMappingToAttribute).findFirst().orElseThrow();
        List<String> paramNames = this.parameterNames(method, entity);
        List<String> paramTypes = AnnotationMetaEntity.parameterTypes(method);
        String[] sessionType = this.sessionTypeFromParameters(paramNames, paramTypes);
        FieldType fieldType = this.validateFinderParameter(entity, parameter);
        if (fieldType != null) {
            String methodKey = methodName + "!";
            List<String> profiles = AnnotationMetaEntity.enabledFetchProfiles(method);
            switch (this.pickStrategy(fieldType, sessionType[0], profiles)) {
                case ID: {
                    this.putMember(methodKey, new IdFinderMethod(this, methodName, returnType.toString(), paramNames, paramTypes, this.repository, sessionType[0], sessionType[1], profiles, this.context.addNonnullAnnotation(), this.jakartaDataRepository));
                    break;
                }
                case NATURAL_ID: {
                    this.putMember(methodKey, new NaturalIdFinderMethod(this, methodName, returnType.toString(), paramNames, paramTypes, this.parameterNullability(method, entity), this.repository, sessionType[0], sessionType[1], profiles, this.context.addNonnullAnnotation(), this.jakartaDataRepository));
                    break;
                }
                case BASIC: 
                case MULTIVALUED: {
                    List<Boolean> paramPatterns = AnnotationMetaEntity.parameterPatterns(method);
                    this.putMember(methodKey, new CriteriaFinderMethod(this, methodName, returnType.toString(), null, paramNames, paramTypes, this.parameterNullability(method, entity), method.getParameters().stream().map(param -> AnnotationMetaEntity.isFinderParameterMappingToAttribute(param) && fieldType == FieldType.MULTIVALUED).collect(Collectors.toList()), paramPatterns, this.repository, sessionType[0], sessionType[1], profiles, this.orderByList(method, entity), this.context.addNonnullAnnotation(), this.jakartaDataRepository));
                }
            }
        }
    }

    private @UnknownKeyFor @NonNull @Initialized FieldType pickStrategy(@UnknownKeyFor @NonNull @Initialized FieldType fieldType, @UnknownKeyFor @NonNull @Initialized String sessionType, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> profiles) {
        if ((this.usingStatelessSession(sessionType) || this.usingReactiveSession(sessionType)) && !profiles.isEmpty()) {
            return FieldType.BASIC;
        }
        switch (fieldType) {
            case ID: {
                return FieldType.ID;
            }
            case NATURAL_ID: {
                return FieldType.NATURAL_ID;
            }
        }
        return FieldType.BASIC;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean matchesNaturalKey(@UnknownKeyFor @NonNull @Initialized TypeElement entity, @UnknownKeyFor @NonNull @Initialized List<@Nullable @UnknownKeyFor @Initialized FieldType> fieldTypes) {
        return fieldTypes.stream().allMatch(type -> type == FieldType.NATURAL_ID) && entity.getEnclosedElements().stream().filter(member -> TypeUtils.hasAnnotation(member, "org.hibernate.annotations.NaturalId")).count() == (long)fieldTypes.size();
    }

    private @Nullable @UnknownKeyFor @Initialized FieldType validateFinderParameter(@UnknownKeyFor @NonNull @Initialized TypeElement entityType, @UnknownKeyFor @NonNull @Initialized VariableElement param) {
        Object value;
        Element member = this.memberMatchingPath(entityType, AnnotationMetaEntity.parameterName(param));
        if (member != null) {
            if (TypeUtils.containsAnnotation(member, "jakarta.persistence.ManyToMany", "jakarta.persistence.OneToMany", "jakarta.persistence.ElementCollection")) {
                this.context.message(param, "matching field is a collection", Diagnostic.Kind.ERROR);
                return null;
            }
            if (this.checkParameterType(entityType, param, AnnotationMetaEntity.memberType(member))) {
                return FieldType.MULTIVALUED;
            }
            if (TypeUtils.containsAnnotation(param, "org.hibernate.annotations.processing.Pattern")) {
                AnnotationMirror mirror = TypeUtils.getAnnotationMirror(param, "org.hibernate.annotations.processing.Pattern");
                if (mirror != null && !param.asType().toString().equals(String.class.getName())) {
                    this.context.message(param, mirror, "parameter annotated '@Pattern' is not of type 'String'", Diagnostic.Kind.ERROR);
                }
                return FieldType.BASIC;
            }
            if (TypeUtils.containsAnnotation(member, "jakarta.persistence.Id", "jakarta.persistence.EmbeddedId")) {
                return FieldType.ID;
            }
            if (TypeUtils.containsAnnotation(member, "org.hibernate.annotations.NaturalId")) {
                return FieldType.NATURAL_ID;
            }
            return FieldType.BASIC;
        }
        AnnotationMirror idClass = TypeUtils.getAnnotationMirror(entityType, "jakarta.persistence.IdClass");
        if (idClass != null && (value = TypeUtils.getAnnotationValue(idClass, "value")) instanceof TypeMirror && this.context.getTypeUtils().isSameType(param.asType(), (TypeMirror)value)) {
            return FieldType.ID;
        }
        this.context.message(param, "no matching field named '" + AnnotationMetaEntity.parameterName(param) + "' in entity class '" + entityType + "'", Diagnostic.Kind.ERROR);
        return null;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean checkParameterType(@UnknownKeyFor @NonNull @Initialized TypeElement entityType, @UnknownKeyFor @NonNull @Initialized VariableElement param, @UnknownKeyFor @NonNull @Initialized TypeMirror attributeType) {
        Types types = this.context.getTypeUtils();
        if (entityType.getKind() == ElementKind.CLASS) {
            TypeMirror parameterType = param.asType();
            if (types.isSameType(parameterType, attributeType)) {
                return false;
            }
            if (attributeType.getKind().isPrimitive()) {
                PrimitiveType primitiveType = (PrimitiveType)attributeType;
                attributeType = types.boxedClass(primitiveType).asType();
            }
            TypeKind kind = parameterType.getKind();
            switch (kind) {
                case TYPEVAR: {
                    TypeVariable typeVariable = (TypeVariable)parameterType;
                    parameterType = typeVariable.getUpperBound();
                }
                case DECLARED: {
                    TypeElement iterable = this.context.getTypeElementForFullyQualifiedName("java.lang.Iterable");
                    if (types.isAssignable(parameterType, types.getDeclaredType(iterable, attributeType))) {
                        return true;
                    }
                    this.parameterTypeError(entityType, param, attributeType);
                    return false;
                }
                case ARRAY: {
                    if (!types.isSameType(parameterType, types.getArrayType(attributeType))) {
                        this.parameterTypeError(entityType, param, attributeType);
                    }
                    return true;
                }
            }
            if (kind.isPrimitive()) {
                PrimitiveType primitiveType = (PrimitiveType)parameterType;
                if (!types.isSameType(types.boxedClass(primitiveType).asType(), attributeType)) {
                    this.parameterTypeError(entityType, param, attributeType);
                }
                return false;
            }
            return false;
        }
        return false;
    }

    private void parameterTypeError(@UnknownKeyFor @NonNull @Initialized TypeElement entityType, @UnknownKeyFor @NonNull @Initialized VariableElement param, @UnknownKeyFor @NonNull @Initialized TypeMirror attributeType) {
        this.context.message(param, "matching field has type '" + attributeType + "' in entity class '" + entityType + "'", Diagnostic.Kind.ERROR);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean finderParameterNullable(@UnknownKeyFor @NonNull @Initialized TypeElement entity, @UnknownKeyFor @NonNull @Initialized VariableElement param) {
        Element member = this.memberMatchingPath(entity, AnnotationMetaEntity.parameterName(param));
        return member == null || AnnotationMetaEntity.isNullable(member);
    }

    private @UnknownKeyFor @NonNull @Initialized AccessType getAccessType(@UnknownKeyFor @NonNull @Initialized TypeElement entity) {
        String entityClassName = entity.getQualifiedName().toString();
        TypeUtils.determineAccessTypeForHierarchy(entity, this.context);
        return NullnessUtil.castNonNull(this.context.getAccessTypeInfo(entityClassName)).getAccessType();
    }

    private static @UnknownKeyFor @NonNull @Initialized TypeMirror memberType(@UnknownKeyFor @NonNull @Initialized Element member) {
        if (member.getKind() == ElementKind.METHOD) {
            ExecutableElement method = (ExecutableElement)member;
            return method.getReturnType();
        }
        return member.asType();
    }

    private @Nullable @UnknownKeyFor @Initialized Element memberMatchingPath(@UnknownKeyFor @NonNull @Initialized TypeElement entityType, @UnknownKeyFor @NonNull @Initialized String path) {
        StringTokenizer tokens = new StringTokenizer(path, ".");
        return this.memberMatchingPath(entityType, tokens);
    }

    private @Nullable @UnknownKeyFor @Initialized Element memberMatchingPath(@UnknownKeyFor @NonNull @Initialized TypeElement entityType, @UnknownKeyFor @NonNull @Initialized StringTokenizer tokens) {
        AccessType accessType = this.getAccessType(entityType);
        String nextToken = tokens.nextToken();
        for (Element element : entityType.getEnclosedElements()) {
            if ("#id".equals(nextToken) && TypeUtils.hasAnnotation(element, "jakarta.persistence.Id")) {
                return element;
            }
            Element match = this.memberMatchingPath(entityType, element, accessType, tokens, nextToken);
            if (match == null) continue;
            return match;
        }
        return null;
    }

    private @Nullable @UnknownKeyFor @Initialized Element memberMatchingPath(@UnknownKeyFor @NonNull @Initialized TypeElement entityType, @UnknownKeyFor @NonNull @Initialized Element candidate, @UnknownKeyFor @NonNull @Initialized AccessType accessType, @UnknownKeyFor @NonNull @Initialized StringTokenizer tokens, @UnknownKeyFor @NonNull @Initialized String token) {
        Name memberName = candidate.getSimpleName();
        TypeMirror type = AnnotationMetaEntity.memberType(candidate, accessType, token, memberName);
        if (type == null) {
            return null;
        }
        if (tokens.hasMoreTokens()) {
            return type.getKind() == TypeKind.DECLARED ? this.memberForPath(entityType, tokens, (DeclaredType)type, memberName) : null;
        }
        return candidate;
    }

    private @Nullable @UnknownKeyFor @Initialized Element memberForPath(@UnknownKeyFor @NonNull @Initialized TypeElement entityType, @UnknownKeyFor @NonNull @Initialized StringTokenizer tokens, @UnknownKeyFor @NonNull @Initialized DeclaredType type, @UnknownKeyFor @NonNull @Initialized Name memberName) {
        TypeElement memberType = (TypeElement)type.asElement();
        this.memberTypes.put(StringHelper.qualify((String)entityType.getQualifiedName().toString(), (String)memberName.toString()), memberType.getQualifiedName().toString());
        return this.memberMatchingPath(memberType, tokens);
    }

    private static @Nullable @UnknownKeyFor @Initialized TypeMirror memberType(@UnknownKeyFor @NonNull @Initialized Element candidate, @UnknownKeyFor @NonNull @Initialized AccessType accessType, @UnknownKeyFor @NonNull @Initialized String token, @UnknownKeyFor @NonNull @Initialized Name memberName) {
        ElementKind kind = candidate.getKind();
        if (accessType == AccessType.FIELD && kind == ElementKind.FIELD) {
            return AnnotationMetaEntity.fieldMatches(token, memberName) ? candidate.asType() : null;
        }
        if (accessType == AccessType.PROPERTY && kind == ElementKind.METHOD) {
            ExecutableElement executable = (ExecutableElement)candidate;
            return AnnotationMetaEntity.getterMatches(token, memberName) ? executable.getReturnType() : null;
        }
        return null;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean fieldMatches(@UnknownKeyFor @NonNull @Initialized String token, @UnknownKeyFor @NonNull @Initialized Name fieldName) {
        return fieldName.contentEquals(token);
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean getterMatches(@UnknownKeyFor @NonNull @Initialized String token, @UnknownKeyFor @NonNull @Initialized Name methodName) {
        if (AnnotationMetaEntity.hasPrefix(methodName, "get")) {
            return token.equals(Introspector.decapitalize(methodName.subSequence(3, methodName.length()).toString()));
        }
        if (AnnotationMetaEntity.hasPrefix(methodName, "is")) {
            return token.equals(Introspector.decapitalize(methodName.subSequence(2, methodName.length()).toString()));
        }
        return false;
    }

    private void addQueryMethod(@UnknownKeyFor @NonNull @Initialized ExecutableElement method, @Nullable @UnknownKeyFor @Initialized TypeMirror returnType, @Nullable @UnknownKeyFor @Initialized TypeElement containerType, @UnknownKeyFor @NonNull @Initialized AnnotationMirror mirror, @UnknownKeyFor @NonNull @Initialized boolean isNative) {
        Object query;
        AnnotationValue value = TypeUtils.getAnnotationValueRef(mirror, "value");
        if (value != null && (query = value.getValue()) instanceof String) {
            String containerTypeName;
            String queryString = (String)query;
            if (containerType == null) {
                if (returnType != null && returnType.getKind() == TypeKind.ARRAY) {
                    ArrayType arrayType = (ArrayType)returnType;
                    TypeMirror componentType = arrayType.getComponentType();
                    TypeElement object = this.context.getElementUtils().getTypeElement("java.lang.Object");
                    if (!this.context.getTypeUtils().isSameType(object.asType(), componentType)) {
                        returnType = componentType;
                        containerTypeName = "[]";
                    } else {
                        containerTypeName = null;
                    }
                } else {
                    containerTypeName = null;
                }
            } else {
                containerTypeName = containerType.getQualifiedName().toString();
            }
            List<String> paramNames = AnnotationMetaEntity.parameterNames(method);
            List<String> paramTypes = AnnotationMetaEntity.parameterTypes(method);
            if (isNative) {
                this.validateSql(method, mirror, queryString, paramNames, value);
            } else {
                this.validateHql(method, returnType, mirror, value, queryString, paramNames, paramTypes);
            }
            this.checkParameters(method, returnType, paramNames, paramTypes, mirror, value, queryString);
            String[] sessionType = this.sessionTypeFromParameters(paramNames, paramTypes);
            DeclaredType resultType = this.resultType(method, returnType, mirror, value);
            List<OrderBy> orderBys = resultType == null ? Collections.emptyList() : this.orderByList(method, (TypeElement)resultType.asElement());
            QueryMethod attribute = new QueryMethod(this, method.getSimpleName().toString(), queryString, returnType == null ? null : returnType.toString(), containerTypeName, paramNames, paramTypes, AnnotationMetaEntity.isInsertUpdateDelete(queryString), isNative, this.repository, sessionType[0], sessionType[1], orderBys, this.context.addNonnullAnnotation(), this.jakartaDataRepository);
            this.putMember(attribute.getPropertyName() + paramTypes, attribute);
        }
    }

    private @Nullable @UnknownKeyFor @Initialized DeclaredType resultType(@UnknownKeyFor @NonNull @Initialized ExecutableElement method, @Nullable @UnknownKeyFor @Initialized TypeMirror returnType, @UnknownKeyFor @NonNull @Initialized AnnotationMirror mirror, @UnknownKeyFor @NonNull @Initialized AnnotationValue value) {
        if (returnType != null && returnType.getKind() == TypeKind.DECLARED) {
            DeclaredType resultType = (DeclaredType)returnType;
            if (!resultType.getTypeArguments().isEmpty()) {
                this.context.message(method, mirror, value, "query result type may not be a generic type (change '" + returnType + "' to '" + this.context.getTypeUtils().erasure(returnType) + "')", Diagnostic.Kind.ERROR);
            }
            return resultType;
        }
        return null;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isInsertUpdateDelete(@UnknownKeyFor @NonNull @Initialized String hql) {
        String trimmed = hql.trim();
        String keyword = trimmed.length() > 6 ? trimmed.substring(0, 6) : "";
        return keyword.equalsIgnoreCase("update") || keyword.equalsIgnoreCase("delete") || keyword.equalsIgnoreCase("insert");
    }

    private void validateHql(@UnknownKeyFor @NonNull @Initialized ExecutableElement method, @Nullable @UnknownKeyFor @Initialized TypeMirror returnType, @UnknownKeyFor @NonNull @Initialized AnnotationMirror mirror, @UnknownKeyFor @NonNull @Initialized AnnotationValue value, @UnknownKeyFor @NonNull @Initialized String hql, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramNames, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes) {
        SqmStatement<?> statement = Validation.validate(hql, returnType, true, new ErrorHandler(this.context, method, mirror, value, hql), ProcessorSessionFactory.create(this.context.getProcessingEnvironment()));
        if (statement != null) {
            if (statement instanceof SqmSelectStatement) {
                this.validateSelectHql(method, returnType, mirror, value, (SqmSelectStatement)statement);
            } else {
                this.validateUpdateHql(method, returnType, mirror, value);
            }
            for (SqmParameter param : statement.getSqmParameters()) {
                this.checkParameter(param, paramNames, paramTypes, method, mirror, value);
            }
        }
    }

    private void validateUpdateHql(@UnknownKeyFor @NonNull @Initialized ExecutableElement method, @Nullable @UnknownKeyFor @Initialized TypeMirror returnType, @UnknownKeyFor @NonNull @Initialized AnnotationMirror mirror, @UnknownKeyFor @NonNull @Initialized AnnotationValue value) {
        boolean reactive = this.usingReactiveSession(this.sessionType);
        if (!this.isValidUpdateReturnType(returnType, method, reactive)) {
            this.context.message(method, mirror, value, "return type of mutation query method must be " + (!reactive ? "'int', 'boolean' or 'void'" : "'Uni<Integer>', 'Uni<Boolean>' or 'Uni<Void>'"), Diagnostic.Kind.ERROR);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isValidUpdateReturnType(@Nullable @UnknownKeyFor @Initialized TypeMirror returnType, @UnknownKeyFor @NonNull @Initialized ExecutableElement method, @UnknownKeyFor @NonNull @Initialized boolean reactive) {
        if (returnType == null) {
            return false;
        }
        if (reactive) {
            String returnTypeName = method.getReturnType().toString();
            return returnTypeName.equals("io.smallrye.mutiny.Uni<java.lang.Void>") || returnTypeName.equals("io.smallrye.mutiny.Uni<java.lang.Boolean>") || returnTypeName.equals("io.smallrye.mutiny.Uni<java.lang.Integer>");
        }
        return returnType.getKind() == TypeKind.VOID || returnType.getKind() == TypeKind.BOOLEAN || returnType.getKind() == TypeKind.INT;
    }

    private void validateSelectHql(@UnknownKeyFor @NonNull @Initialized ExecutableElement method, @Nullable @UnknownKeyFor @Initialized TypeMirror returnType, @UnknownKeyFor @NonNull @Initialized AnnotationMirror mirror, @UnknownKeyFor @NonNull @Initialized AnnotationValue value, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized SqmSelectStatement<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> statement) {
        if (returnType != null) {
            boolean returnTypeCorrect;
            JpaSelection selection = statement.getSelection();
            if (selection.isCompoundSelection()) {
                switch (returnType.getKind()) {
                    case ARRAY: {
                        returnTypeCorrect = AnnotationMetaEntity.checkReturnedArrayType((ArrayType)returnType);
                        break;
                    }
                    case DECLARED: {
                        if (!AnnotationMetaEntity.checkConstructorReturn((DeclaredType)returnType, selection)) {
                            this.context.message(method, mirror, value, "return type '" + returnType + "' of method has no constructor matching query selection list", Diagnostic.Kind.ERROR);
                        }
                        returnTypeCorrect = true;
                        break;
                    }
                    default: {
                        returnTypeCorrect = false;
                        break;
                    }
                }
            } else if (selection instanceof JpaEntityJoin) {
                JpaEntityJoin from = (JpaEntityJoin)selection;
                returnTypeCorrect = this.checkReturnedEntity(from.getModel(), returnType);
            } else if (selection instanceof JpaRoot) {
                JpaRoot from = (JpaRoot)selection;
                returnTypeCorrect = this.checkReturnedEntity(from.getModel(), returnType);
            } else {
                try {
                    Class javaResultType = selection.getJavaType();
                    TypeElement typeElement = this.context.getTypeElementForFullyQualifiedName(javaResultType.getName());
                    Types types = this.context.getTypeUtils();
                    returnTypeCorrect = types.isAssignable(returnType, types.erasure(typeElement.asType()));
                }
                catch (Exception e) {
                    returnTypeCorrect = true;
                }
            }
            if (!returnTypeCorrect) {
                this.context.message(method, mirror, value, "return type of query did not match return type '" + returnType + "' of method", Diagnostic.Kind.ERROR);
            }
        }
    }

    private void validateSql(final @UnknownKeyFor @NonNull @Initialized ExecutableElement method, final @UnknownKeyFor @NonNull @Initialized AnnotationMirror mirror, @UnknownKeyFor @NonNull @Initialized String sql, final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramNames, final @UnknownKeyFor @NonNull @Initialized AnnotationValue value) {
        ParameterParser.parse((String)sql, (ParameterRecognizer)new ParameterRecognizer(){
            int ordinalCount = 0;

            public void ordinalParameter(int sourcePosition) {
                ++this.ordinalCount;
                if (this.ordinalCount > paramNames.size()) {
                    AnnotationMetaEntity.this.context.message(method, mirror, value, "missing method parameter for query parameter " + this.ordinalCount + " (add a parameter to '" + method.getSimpleName() + "')", Diagnostic.Kind.ERROR);
                }
            }

            public void namedParameter(String name, int sourcePosition) {
                if (!paramNames.contains(name)) {
                    AnnotationMetaEntity.this.context.message(method, mirror, value, "missing method parameter for query parameter :" + name + " (add a parameter '" + name + "' to '" + method.getSimpleName() + "')", Diagnostic.Kind.ERROR);
                }
            }

            public void jpaPositionalParameter(int label, int sourcePosition) {
                if (label > paramNames.size()) {
                    AnnotationMetaEntity.this.context.message(method, mirror, value, "missing method parameter for query parameter ?" + label + " (add a parameter to '" + method.getSimpleName() + "')", Diagnostic.Kind.ERROR);
                }
            }

            public void other(char character) {
            }
        });
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean checkConstructorReturn(@UnknownKeyFor @NonNull @Initialized DeclaredType returnType, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized JpaSelection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> selection) {
        List selectionItems = selection.getSelectionItems();
        if (selectionItems == null) {
            return true;
        }
        TypeElement typeElement = (TypeElement)returnType.asElement();
        Name qualifiedName = typeElement.getQualifiedName();
        if (qualifiedName.contentEquals("jakarta.persistence.Tuple") || qualifiedName.contentEquals("java.util.List") || qualifiedName.contentEquals("java.util.Map")) {
            return true;
        }
        for (Element element : typeElement.getEnclosedElements()) {
            ExecutableElement constructor;
            if (element.getKind() != ElementKind.CONSTRUCTOR || !AnnotationMetaEntity.constructorMatches(selectionItems, (constructor = (ExecutableElement)element).getParameters())) continue;
            return true;
        }
        return false;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean constructorMatches(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized JpaSelection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> selectionItems, @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized VariableElement> parameters) {
        int itemCount = selectionItems.size();
        if (parameters.size() == itemCount) {
            for (int i = 0; i < itemCount; ++i) {
                JpaSelection<?> item = selectionItems.get(i);
                if (item == null || item.getJavaType() == null || AnnotationMetaEntity.parameterMatches(parameters.get(i), item)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean parameterMatches(@UnknownKeyFor @NonNull @Initialized VariableElement parameter, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized JpaSelection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> item) {
        return AnnotationMetaEntity.parameterMatches(parameter.asType(), item.getJavaType());
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean parameterMatches(@UnknownKeyFor @NonNull @Initialized TypeMirror parameterType, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> itemType) {
        TypeKind kind = parameterType.getKind();
        String itemTypeName = itemType.getName();
        if (kind == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)parameterType;
            TypeElement paramTypeElement = (TypeElement)declaredType.asElement();
            return paramTypeElement.getQualifiedName().contentEquals(itemTypeName);
        }
        if (kind.isPrimitive()) {
            return TypeUtils.primitiveClassMatchesKind(itemType, kind);
        }
        if (kind == TypeKind.ARRAY) {
            ArrayType arrayType = (ArrayType)parameterType;
            return itemType.isArray() && AnnotationMetaEntity.parameterMatches(arrayType.getComponentType(), itemType.getComponentType());
        }
        return false;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean checkReturnedArrayType(@UnknownKeyFor @NonNull @Initialized ArrayType returnType) {
        TypeMirror componentType = returnType.getComponentType();
        if (componentType.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)componentType;
            TypeElement typeElement = (TypeElement)declaredType.asElement();
            return typeElement.getQualifiedName().contentEquals("java.lang.Object");
        }
        return false;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean checkReturnedEntity(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized EntityDomainType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> model, @UnknownKeyFor @NonNull @Initialized TypeMirror returnType) {
        DeclaredType declaredType;
        TypeElement typeElement;
        AnnotationMirror mirror;
        if (returnType.getKind() == TypeKind.DECLARED && (mirror = TypeUtils.getAnnotationMirror(typeElement = (TypeElement)(declaredType = (DeclaredType)returnType).asElement(), "jakarta.persistence.Entity")) != null) {
            Object value = TypeUtils.getAnnotationValue(mirror, "name");
            String entityName = value instanceof String ? (String)value : typeElement.getSimpleName().toString();
            return model.getHibernateEntityName().equals(entityName);
        }
        return false;
    }

    private void checkParameter(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized SqmParameter<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> param, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramNames, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes, @UnknownKeyFor @NonNull @Initialized ExecutableElement method, @UnknownKeyFor @NonNull @Initialized AnnotationMirror mirror, @UnknownKeyFor @NonNull @Initialized AnnotationValue value) {
        String queryParamType;
        SqmExpressible expressible = param.getExpressible();
        String string = queryParamType = expressible == null ? "unknown" : expressible.getTypeName();
        if (param.getName() != null) {
            String name = param.getName();
            int index = paramNames.indexOf(name);
            if (index < 0) {
                this.context.message(method, mirror, value, "missing method parameter for query parameter :" + name + " (add a parameter '" + queryParamType + " " + name + "' to '" + method.getSimpleName() + "')", Diagnostic.Kind.ERROR);
            } else if (!AnnotationMetaEntity.isLegalAssignment(paramTypes.get(index), queryParamType)) {
                this.context.message(method, mirror, value, "parameter matching query parameter :" + name + " has the wrong type (change the method parameter type to '" + queryParamType + "')", Diagnostic.Kind.ERROR);
            }
        } else if (param.getPosition() != null) {
            int position = param.getPosition();
            if (position > paramNames.size()) {
                this.context.message(method, mirror, value, "missing method parameter for query parameter ?" + position + " (add a parameter of type '" + queryParamType + "' to '" + method.getSimpleName() + "')", Diagnostic.Kind.ERROR);
            } else if (!AnnotationMetaEntity.isLegalAssignment(paramTypes.get(position - 1), queryParamType)) {
                this.context.message(method, mirror, value, "parameter matching query parameter ?" + position + " has the wrong type (change the method parameter type to '" + queryParamType + "')", Diagnostic.Kind.ERROR);
            }
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isLegalAssignment(@UnknownKeyFor @NonNull @Initialized String argType, @UnknownKeyFor @NonNull @Initialized String paramType) {
        return paramType.equals("unknown") || paramType.equals(argType) || paramType.equals(AnnotationMetaEntity.fromPrimitive(argType));
    }

    private static @Nullable @UnknownKeyFor @Initialized String fromPrimitive(@UnknownKeyFor @NonNull @Initialized String argType) {
        switch (argType) {
            case "boolean": {
                return Boolean.class.getName();
            }
            case "char": {
                return Character.class.getName();
            }
            case "int": {
                return Integer.class.getName();
            }
            case "long": {
                return Long.class.getName();
            }
            case "short": {
                return Short.class.getName();
            }
            case "byte": {
                return Byte.class.getName();
            }
            case "float": {
                return Float.class.getName();
            }
            case "double": {
                return Double.class.getName();
            }
        }
        return null;
    }

    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Boolean> parameterNullability(@UnknownKeyFor @NonNull @Initialized ExecutableElement method, @UnknownKeyFor @NonNull @Initialized TypeElement entity) {
        return method.getParameters().stream().map(param -> this.finderParameterNullable(entity, (VariableElement)param)).collect(Collectors.toList());
    }

    private static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> parameterTypes(@UnknownKeyFor @NonNull @Initialized ExecutableElement method) {
        return method.getParameters().stream().map(param -> param.asType().toString()).collect(Collectors.toList());
    }

    private static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Boolean> parameterPatterns(@UnknownKeyFor @NonNull @Initialized ExecutableElement method) {
        return method.getParameters().stream().map(param -> TypeUtils.hasAnnotation((Element)param, "org.hibernate.annotations.processing.Pattern")).collect(Collectors.toList());
    }

    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> parameterNames(@UnknownKeyFor @NonNull @Initialized ExecutableElement method, @UnknownKeyFor @NonNull @Initialized TypeElement entity) {
        String idName = entity.getEnclosedElements().stream().filter(member -> TypeUtils.hasAnnotation(member, "jakarta.persistence.Id")).map(member -> TypeUtils.propertyName(this, member)).findFirst().orElse("id");
        return method.getParameters().stream().map(AnnotationMetaEntity::parameterName).map(name -> "#id".equals(name) ? idName : name).collect(Collectors.toList());
    }

    private static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> parameterNames(@UnknownKeyFor @NonNull @Initialized ExecutableElement method) {
        return method.getParameters().stream().map(AnnotationMetaEntity::parameterName).collect(Collectors.toList());
    }

    private static @UnknownKeyFor @NonNull @Initialized String parameterName(@UnknownKeyFor @NonNull @Initialized VariableElement parameter) {
        AnnotationMirror by = TypeUtils.getAnnotationMirror(parameter, "jakarta.data.repository.By");
        AnnotationMirror param = TypeUtils.getAnnotationMirror(parameter, "jakarta.data.repository.Param");
        if (by != null) {
            String name = (String)NullnessUtil.castNonNull(TypeUtils.getAnnotationValue(by, "value"));
            if (name.contains("<error>")) {
                throw new ProcessLaterException();
            }
            return name.replace('$', '.').replace('_', '.');
        }
        if (param != null) {
            String name = (String)NullnessUtil.castNonNull(TypeUtils.getAnnotationValue(param, "value"));
            if (name.contains("<error>")) {
                throw new ProcessLaterException();
            }
            return name;
        }
        return parameter.getSimpleName().toString().replace('$', '.').replace('_', '.');
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isNullable(@UnknownKeyFor @NonNull @Initialized Element member) {
        switch (member.getKind()) {
            case METHOD: {
                ExecutableElement method = (ExecutableElement)member;
                if (method.getReturnType().getKind().isPrimitive()) {
                    return false;
                }
            }
            case FIELD: {
                if (!member.asType().getKind().isPrimitive()) break;
                return false;
            }
        }
        boolean nullable = true;
        for (AnnotationMirror annotationMirror : member.getAnnotationMirrors()) {
            TypeElement annotationType = (TypeElement)annotationMirror.getAnnotationType().asElement();
            Name name = annotationType.getQualifiedName();
            if (name.contentEquals("jakarta.persistence.Id")) {
                nullable = false;
            }
            if (name.contentEquals("jakarta.validation.constraints.NotNull")) {
                nullable = false;
            }
            if (!name.contentEquals("jakarta.persistence.Basic") && !name.contentEquals("jakarta.persistence.ManyToOne") && !name.contentEquals("jakarta.persistence.OneToOne") || !Boolean.FALSE.equals(TypeUtils.getAnnotationValue(annotationMirror, "optional"))) continue;
            nullable = false;
        }
        return nullable;
    }

    private void checkParameters(@UnknownKeyFor @NonNull @Initialized ExecutableElement method, @Nullable @UnknownKeyFor @Initialized TypeMirror returnType, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramNames, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes, @UnknownKeyFor @NonNull @Initialized AnnotationMirror mirror, @UnknownKeyFor @NonNull @Initialized AnnotationValue value, @UnknownKeyFor @NonNull @Initialized String hql) {
        for (int i = 1; i <= paramNames.size(); ++i) {
            String string;
            String param = paramNames.get(i - 1);
            if (!AnnotationMetaEntity.parameterIsMissing(hql, i, param, string = paramTypes.get(i - 1))) continue;
            this.context.message(method, mirror, value, "missing query parameter for '" + param + "' (no parameter named :" + param + " or ?" + i + ")", Diagnostic.Kind.ERROR);
        }
        if (returnType != null) {
            Types types = this.context.getTypeUtils();
            for (VariableElement variableElement : method.getParameters()) {
                TypeMirror parameterType = variableElement.asType();
                TypeMirror typeArgument = AnnotationMetaEntity.getTypeArgument(parameterType);
                String type = parameterType.toString();
                boolean pageRequest = type.startsWith("jakarta.data.page.PageRequest");
                if (!QueryMethod.isOrderParam(type) && !pageRequest) continue;
                if (typeArgument == null) {
                    this.missingTypeArgError(returnType.toString(), variableElement, pageRequest);
                    continue;
                }
                if (types.isSameType(typeArgument, returnType)) continue;
                this.wrongTypeArgError(returnType.toString(), variableElement, pageRequest);
            }
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean parameterIsMissing(@UnknownKeyFor @NonNull @Initialized String hql, @UnknownKeyFor @NonNull @Initialized int i, @UnknownKeyFor @NonNull @Initialized String param, @UnknownKeyFor @NonNull @Initialized String type) {
        return !AnnotationMetaEntity.hasParameter(hql, i, param) && !AbstractQueryMethod.isSpecialParam(type);
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean hasParameter(@UnknownKeyFor @NonNull @Initialized String hql, @UnknownKeyFor @NonNull @Initialized int i, @UnknownKeyFor @NonNull @Initialized String param) {
        return Pattern.compile(".*(:" + param + "|\\?" + i + ")\\b.*", 32).matcher(hql).matches();
    }

    private @UnknownKeyFor @NonNull @Initialized boolean usingReactiveSession(@UnknownKeyFor @NonNull @Initialized String sessionType) {
        return "org.hibernate.reactive.mutiny.Mutiny.Session".equals(sessionType) || "io.smallrye.mutiny.Uni<org.hibernate.reactive.mutiny.Mutiny.Session>".equals(sessionType);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean usingStatelessSession(@UnknownKeyFor @NonNull @Initialized String sessionType) {
        return "org.hibernate.StatelessSession".equals(sessionType);
    }

    static enum FieldType {
        ID,
        NATURAL_ID,
        BASIC,
        MULTIVALUED;

    }
}

