/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.annotation;

import java.util.List;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.AssertionFailure;
import org.hibernate.processor.annotation.AbstractFinderMethod;
import org.hibernate.processor.annotation.AnnotationMetaEntity;
import org.hibernate.processor.annotation.OrderBy;
import org.hibernate.processor.util.TypeUtils;

public class CriteriaFinderMethod
extends AbstractFinderMethod {
    private final @Nullable @UnknownKeyFor @Initialized String containerType;
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Boolean> paramNullability;
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Boolean> multivalued;
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Boolean> paramPatterns;

    CriteriaFinderMethod(@UnknownKeyFor @NonNull @Initialized AnnotationMetaEntity annotationMetaEntity, @UnknownKeyFor @NonNull @Initialized String methodName, @UnknownKeyFor @NonNull @Initialized String entity, @Nullable @UnknownKeyFor @Initialized String containerType, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramNames, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Boolean> paramNullability, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Boolean> multivalued, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Boolean> paramPatterns, @UnknownKeyFor @NonNull @Initialized boolean belongsToDao, @UnknownKeyFor @NonNull @Initialized String sessionType, @UnknownKeyFor @NonNull @Initialized String sessionName, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> fetchProfiles, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized OrderBy> orderBys, @UnknownKeyFor @NonNull @Initialized boolean addNonnullAnnotation, @UnknownKeyFor @NonNull @Initialized boolean dataRepository) {
        super(annotationMetaEntity, methodName, entity, belongsToDao, sessionType, sessionName, fetchProfiles, paramNames, paramTypes, orderBys, addNonnullAnnotation, dataRepository);
        this.containerType = containerType;
        this.paramNullability = paramNullability;
        this.multivalued = multivalued;
        this.paramPatterns = paramPatterns;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isNullable(@UnknownKeyFor @NonNull @Initialized int index) {
        return this.paramNullability.get(index);
    }

    @Override
    @UnknownKeyFor @NonNull @Initialized boolean singleResult() {
        return this.containerType == null;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getAttributeDeclarationString() {
        List<String> paramTypes = this.parameterTypes();
        StringBuilder declaration = new StringBuilder();
        this.comment(declaration);
        this.modifiers(declaration);
        this.preamble(declaration, this.returnType(), paramTypes);
        this.chainSession(declaration);
        this.nullChecks(paramTypes, declaration);
        this.createCriteriaQuery(declaration);
        this.where(declaration, paramTypes);
        this.executeQuery(declaration, paramTypes);
        this.convertExceptions(declaration);
        this.chainSessionEnd(false, declaration);
        CriteriaFinderMethod.closingBrace(declaration);
        return declaration.toString();
    }

    private void executeQuery(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes) {
        declaration.append('\n');
        this.collectOrdering(declaration, paramTypes);
        this.tryReturn(declaration, paramTypes, this.containerType);
        this.castResult(declaration);
        this.createQuery(declaration);
        this.handlePageParameters(declaration, paramTypes, this.containerType);
        boolean unwrapped = this.specialNeeds(declaration);
        unwrapped = this.applyOrder(declaration, paramTypes, this.containerType, unwrapped);
        this.execute(declaration, paramTypes, unwrapped);
    }

    private void castResult(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        if (this.containerType == null && !this.fetchProfiles.isEmpty() && this.isUsingEntityManager()) {
            declaration.append("(").append(this.annotationMetaEntity.importType(this.entity)).append(") ");
        }
    }

    private @UnknownKeyFor @NonNull @Initialized boolean specialNeeds(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        boolean unwrapped = !this.isUsingEntityManager();
        unwrapped = this.enableFetchProfile(declaration, unwrapped);
        unwrapped = this.unwrapIfNecessary(declaration, this.containerType, unwrapped);
        return unwrapped;
    }

    @Override
    void createQuery(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        declaration.append(this.localSessionName()).append(".createQuery(_query)\n");
    }

    private void execute(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes, @UnknownKeyFor @NonNull @Initialized boolean unwrapped) {
        boolean mustUnwrap = this.containerType != null && this.containerType.startsWith("org.hibernate");
        this.executeSelect(declaration, paramTypes, this.containerType, unwrapped, mustUnwrap);
    }

    private void createCriteriaQuery(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        declaration.append("\tvar _builder = ").append(this.localSessionName()).append(this.isUsingEntityManager() ? ".getEntityManagerFactory()" : ".getFactory()").append(".getCriteriaBuilder();\n").append("\tvar _query = _builder.createQuery(").append(this.annotationMetaEntity.importType(this.entity)).append(".class);\n").append("\tvar _entity = _query.from(").append(this.annotationMetaEntity.importType(this.entity)).append(".class);\n");
    }

    private void nullChecks(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes, @UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        for (int i = 0; i < this.paramNames.size(); ++i) {
            String paramName = (String)this.paramNames.get(i);
            String paramType = paramTypes.get(i);
            if (this.isNullable(i) || TypeUtils.isPrimitive(paramType)) continue;
            CriteriaFinderMethod.nullCheck(declaration, paramName);
        }
    }

    private static void nullCheck(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration, @UnknownKeyFor @NonNull @Initialized String paramName) {
        declaration.append("\tif (").append(paramName.replace('.', '$')).append(" == null) throw new IllegalArgumentException(\"Null ").append(paramName).append("\");\n");
    }

    private void where(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes) {
        declaration.append("\t_query.where(");
        boolean first = true;
        for (int i = 0; i < this.paramNames.size(); ++i) {
            String paramName = (String)this.paramNames.get(i);
            String paramType = paramTypes.get(i);
            if (CriteriaFinderMethod.isSpecialParam(paramType)) continue;
            if (first) {
                first = false;
            } else {
                declaration.append(", ");
            }
            this.condition(declaration, i, paramName, paramType);
        }
        declaration.append("\n\t);");
    }

    private void condition(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration, @UnknownKeyFor @NonNull @Initialized int i, @UnknownKeyFor @NonNull @Initialized String paramName, @UnknownKeyFor @NonNull @Initialized String paramType) {
        declaration.append("\n\t\t\t");
        String parameterName = paramName.replace('.', '$');
        if (this.isNullable(i) && !TypeUtils.isPrimitive(paramType)) {
            declaration.append(parameterName).append("==null").append("\n\t\t\t\t? ").append("_entity");
            this.path(declaration, paramName);
            declaration.append(".isNull()").append("\n\t\t\t\t: ");
        }
        if (this.multivalued.get(i).booleanValue()) {
            declaration.append("_entity");
            this.path(declaration, paramName);
            declaration.append(".in(");
            if (paramType.endsWith("[]")) {
                declaration.append("(Object[]) ").append(parameterName);
            } else {
                declaration.append(this.annotationMetaEntity.staticImport(StreamSupport.class.getName(), "stream")).append('(').append(parameterName).append(".spliterator(), false).collect(").append(this.annotationMetaEntity.staticImport(Collectors.class.getName(), "toList")).append("())");
            }
            declaration.append(")");
        } else {
            declaration.append("_builder.").append(this.paramPatterns.get(i) != false ? "like" : "equal").append("(_entity");
            this.path(declaration, paramName);
            declaration.append(", ").append(parameterName).append(')');
        }
    }

    private void path(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration, @UnknownKeyFor @NonNull @Initialized String paramName) {
        StringTokenizer tokens = new StringTokenizer(paramName, ".");
        String typeName = this.entity;
        while (typeName != null && tokens.hasMoreTokens()) {
            String memberName = tokens.nextToken();
            declaration.append(".get(").append(this.annotationMetaEntity.importType(typeName + "_")).append('.').append(memberName).append(')');
            typeName = this.annotationMetaEntity.getMemberType(typeName, memberName);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized StringBuilder returnType() {
        StringBuilder type = new StringBuilder();
        if ("[]".equals(this.containerType)) {
            if (this.returnTypeName == null) {
                throw new AssertionFailure("array return type, but no type name");
            }
            type.append(this.annotationMetaEntity.importType(this.returnTypeName)).append("[]");
        } else {
            boolean returnsUni;
            boolean bl = returnsUni = this.isReactive() && (this.containerType == null || "java.util.List".equals(this.containerType));
            if (returnsUni) {
                type.append(this.annotationMetaEntity.importType("io.smallrye.mutiny.Uni")).append('<');
            }
            if (this.containerType != null) {
                type.append(this.annotationMetaEntity.importType(this.containerType)).append('<');
            }
            type.append(this.annotationMetaEntity.importType(this.entity));
            if (this.containerType != null) {
                type.append('>');
            }
            if (returnsUni) {
                type.append('>');
            }
        }
        return type;
    }
}

