/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.annotation;

import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.SimpleTypeVisitor8;
import javax.lang.model.util.Types;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.processor.Context;
import org.hibernate.processor.annotation.AnnotationMetaEntity;
import org.hibernate.processor.annotation.DataAnnotationMetaAttribute;
import org.hibernate.processor.util.Constants;
import org.hibernate.processor.util.TypeUtils;

public class DataMetaAttributeGenerationVisitor
extends SimpleTypeVisitor8<DataAnnotationMetaAttribute, Element> {
    private final @UnknownKeyFor @NonNull @Initialized AnnotationMetaEntity entity;
    private final @UnknownKeyFor @NonNull @Initialized Context context;

    DataMetaAttributeGenerationVisitor(@UnknownKeyFor @NonNull @Initialized AnnotationMetaEntity entity, @UnknownKeyFor @NonNull @Initialized Context context) {
        this.entity = entity;
        this.context = context;
    }

    private @UnknownKeyFor @NonNull @Initialized Types typeUtils() {
        return this.context.getTypeUtils();
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized DataAnnotationMetaAttribute visitPrimitive(@UnknownKeyFor @NonNull @Initialized PrimitiveType primitiveType, @UnknownKeyFor @NonNull @Initialized Element element) {
        return new DataAnnotationMetaAttribute(this.entity, element, TypeUtils.toTypeString(primitiveType));
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized DataAnnotationMetaAttribute visitArray(@UnknownKeyFor @NonNull @Initialized ArrayType arrayType, @UnknownKeyFor @NonNull @Initialized Element element) {
        return new DataAnnotationMetaAttribute(this.entity, element, TypeUtils.toArrayTypeString(arrayType, this.context));
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized DataAnnotationMetaAttribute visitTypeVariable(@UnknownKeyFor @NonNull @Initialized TypeVariable typeVariable, @UnknownKeyFor @NonNull @Initialized Element element) {
        return new DataAnnotationMetaAttribute(this.entity, element, this.typeUtils().erasure(typeVariable.getUpperBound()).toString());
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized DataAnnotationMetaAttribute visitDeclared(@UnknownKeyFor @NonNull @Initialized DeclaredType declaredType, @UnknownKeyFor @NonNull @Initialized Element element) {
        TypeElement returnedElement = (TypeElement)this.typeUtils().asElement(declaredType);
        String returnTypeName = returnedElement.getQualifiedName().toString();
        String collection = Constants.COLLECTIONS.get(returnTypeName);
        String targetEntity = TypeUtils.getTargetEntity(element.getAnnotationMirrors());
        if (collection != null) {
            return null;
        }
        if (TypeUtils.isBasicAttribute(element, returnedElement, this.context)) {
            String type = targetEntity != null ? targetEntity : returnedElement.getQualifiedName().toString();
            return new DataAnnotationMetaAttribute(this.entity, element, type);
        }
        return null;
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized DataAnnotationMetaAttribute visitExecutable(@UnknownKeyFor @NonNull @Initialized ExecutableType executable, @UnknownKeyFor @NonNull @Initialized Element element) {
        return TypeUtils.isPropertyGetter(executable, element) ? executable.getReturnType().accept(this, element) : null;
    }
}

