/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.annotation;

import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.processor.model.MetaAttribute;
import org.hibernate.processor.model.Metamodel;

public class DefaultConstructor
implements MetaAttribute {
    private final @UnknownKeyFor @NonNull @Initialized Metamodel annotationMetaEntity;
    private final @UnknownKeyFor @NonNull @Initialized String constructorName;
    private final @UnknownKeyFor @NonNull @Initialized String methodName;
    private final @UnknownKeyFor @NonNull @Initialized String sessionTypeName;
    private final @UnknownKeyFor @NonNull @Initialized String sessionVariableName;
    private final @Nullable @UnknownKeyFor @Initialized String dataStore;
    private final @UnknownKeyFor @NonNull @Initialized boolean addInjectAnnotation;

    public DefaultConstructor(@UnknownKeyFor @NonNull @Initialized Metamodel annotationMetaEntity, @UnknownKeyFor @NonNull @Initialized String constructorName, @UnknownKeyFor @NonNull @Initialized String methodName, @UnknownKeyFor @NonNull @Initialized String sessionTypeName, @UnknownKeyFor @NonNull @Initialized String sessionVariableName, @Nullable @UnknownKeyFor @Initialized String dataStore, @UnknownKeyFor @NonNull @Initialized boolean addInjectAnnotation) {
        this.annotationMetaEntity = annotationMetaEntity;
        this.constructorName = constructorName;
        this.methodName = methodName;
        this.sessionTypeName = sessionTypeName;
        this.sessionVariableName = sessionVariableName;
        this.dataStore = dataStore;
        this.addInjectAnnotation = addInjectAnnotation;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean hasTypedAttribute() {
        return true;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean hasStringAttribute() {
        return false;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getAttributeDeclarationString() {
        StringBuilder declaration = new StringBuilder();
        declaration.append('\n');
        declaration.append("@").append(this.annotationMetaEntity.importType("jakarta.persistence.PersistenceUnit"));
        if (this.dataStore != null) {
            declaration.append("(unitName=\"").append(this.dataStore).append("\")");
        }
        declaration.append("\nprivate ").append(this.annotationMetaEntity.importType("jakarta.persistence.EntityManagerFactory")).append(" ").append(this.sessionVariableName).append("Factory;\n\n");
        this.inject(declaration);
        declaration.append(this.constructorName).append("(").append(") {").append("\n}\n\n");
        declaration.append('@').append(this.annotationMetaEntity.importType("jakarta.annotation.PostConstruct")).append("\nprivate void openSession() {").append("\n\t").append(this.sessionVariableName).append(" = ").append(this.sessionVariableName).append("Factory.unwrap(").append(this.annotationMetaEntity.importType("org.hibernate.SessionFactory")).append(".class).openStatelessSession();").append("\n}\n\n");
        declaration.append('@').append(this.annotationMetaEntity.importType("jakarta.annotation.PreDestroy")).append("\nprivate void closeSession() {").append("\n\t").append(this.sessionVariableName).append(".close();").append("\n}");
        return declaration.toString();
    }

    private void inject(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        if (this.addInjectAnnotation) {
            declaration.append('@').append(this.annotationMetaEntity.importType("jakarta.inject.Inject")).append('\n');
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getAttributeNameDeclarationString() {
        throw new UnsupportedOperationException("operation not supported");
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getMetaType() {
        throw new UnsupportedOperationException("operation not supported");
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getPropertyName() {
        return this.methodName;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getTypeDeclaration() {
        return "jakarta.persistence.EntityManager";
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Metamodel getHostingEntity() {
        return this.annotationMetaEntity;
    }
}

