/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.annotation;

import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.processor.annotation.AbstractFinderMethod;
import org.hibernate.processor.annotation.AnnotationMetaEntity;
import org.hibernate.processor.util.TypeUtils;

public class IdFinderMethod
extends AbstractFinderMethod {
    private final @UnknownKeyFor @NonNull @Initialized String paramName;
    private final @UnknownKeyFor @NonNull @Initialized String paramType;

    public IdFinderMethod(@UnknownKeyFor @NonNull @Initialized AnnotationMetaEntity annotationMetaEntity, @UnknownKeyFor @NonNull @Initialized String methodName, @UnknownKeyFor @NonNull @Initialized String entity, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramNames, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes, @UnknownKeyFor @NonNull @Initialized boolean belongsToDao, @UnknownKeyFor @NonNull @Initialized String sessionType, @UnknownKeyFor @NonNull @Initialized String sessionName, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> fetchProfiles, @UnknownKeyFor @NonNull @Initialized boolean addNonnullAnnotation, @UnknownKeyFor @NonNull @Initialized boolean dataRepository) {
        super(annotationMetaEntity, methodName, entity, belongsToDao, sessionType, sessionName, fetchProfiles, paramNames, paramTypes, Collections.emptyList(), addNonnullAnnotation, dataRepository);
        int idParameter = IdFinderMethod.idParameter(paramNames, paramTypes);
        this.paramName = paramNames.get(idParameter);
        this.paramType = paramTypes.get(idParameter);
    }

    private static @UnknownKeyFor @NonNull @Initialized int idParameter(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramNames, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes) {
        for (int i = 0; i < paramNames.size(); ++i) {
            if (IdFinderMethod.isSessionParameter(paramTypes.get(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    @UnknownKeyFor @NonNull @Initialized boolean isNullable(@UnknownKeyFor @NonNull @Initialized int index) {
        return false;
    }

    @Override
    @UnknownKeyFor @NonNull @Initialized boolean singleResult() {
        return true;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getAttributeDeclarationString() {
        StringBuilder declaration = new StringBuilder();
        this.comment(declaration);
        this.preamble(declaration);
        if (this.paramName != null && !TypeUtils.isPrimitive(this.paramType)) {
            IdFinderMethod.nullCheck(declaration, this.paramName);
        }
        this.tryReturn(declaration);
        if (this.fetchProfiles.isEmpty()) {
            this.findWithNoFetchProfiles(declaration);
        } else {
            this.findWithFetchProfiles(declaration);
        }
        this.convertExceptions(declaration);
        IdFinderMethod.closingBrace(declaration);
        return declaration.toString();
    }

    private void findWithFetchProfiles(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        this.unwrapSession(declaration);
        declaration.append(".byId(").append(this.annotationMetaEntity.importType(this.entity)).append(".class)\n");
        this.enableFetchProfile(declaration, true);
        declaration.append("\t\t\t.load(").append(this.paramName).append(");\n");
    }

    private void findWithNoFetchProfiles(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        declaration.append(this.isUsingStatelessSession() ? ".get(" : ".find(").append(this.annotationMetaEntity.importType(this.entity)).append(".class, ").append(this.paramName).append(");\n");
    }

    private static void nullCheck(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration, @UnknownKeyFor @NonNull @Initialized String parameterName) {
        declaration.append("\tif (").append(parameterName).append(" == null) throw new IllegalArgumentException(\"Null ").append(parameterName).append("\");\n");
    }
}

