/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.annotation;

import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.processor.annotation.AnnotationMetaEntity;
import org.hibernate.processor.model.MetaAttribute;
import org.hibernate.processor.model.Metamodel;

public class LifecycleMethod
implements MetaAttribute {
    private final @UnknownKeyFor @NonNull @Initialized AnnotationMetaEntity annotationMetaEntity;
    private final @UnknownKeyFor @NonNull @Initialized String entity;
    private final @UnknownKeyFor @NonNull @Initialized String methodName;
    private final @UnknownKeyFor @NonNull @Initialized String parameterName;
    private final @UnknownKeyFor @NonNull @Initialized String sessionName;
    private final @UnknownKeyFor @NonNull @Initialized String operationName;
    private final @UnknownKeyFor @NonNull @Initialized boolean addNonnullAnnotation;
    private final @UnknownKeyFor @NonNull @Initialized boolean iterateParameter;
    private final @UnknownKeyFor @NonNull @Initialized boolean returnArgument;

    public LifecycleMethod(@UnknownKeyFor @NonNull @Initialized AnnotationMetaEntity annotationMetaEntity, @UnknownKeyFor @NonNull @Initialized String entity, @UnknownKeyFor @NonNull @Initialized String methodName, @UnknownKeyFor @NonNull @Initialized String parameterName, @UnknownKeyFor @NonNull @Initialized String sessionName, @UnknownKeyFor @NonNull @Initialized String operationName, @UnknownKeyFor @NonNull @Initialized boolean addNonnullAnnotation, @UnknownKeyFor @NonNull @Initialized boolean iterateParameter, @UnknownKeyFor @NonNull @Initialized boolean returnArgument) {
        this.annotationMetaEntity = annotationMetaEntity;
        this.entity = entity;
        this.methodName = methodName;
        this.parameterName = parameterName;
        this.sessionName = sessionName;
        this.operationName = operationName;
        this.addNonnullAnnotation = addNonnullAnnotation;
        this.iterateParameter = iterateParameter;
        this.returnArgument = returnArgument;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean hasTypedAttribute() {
        return true;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean hasStringAttribute() {
        return false;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getAttributeDeclarationString() {
        StringBuilder declaration = new StringBuilder();
        this.preamble(declaration);
        this.nullCheck(declaration);
        declaration.append("\ttry {\n");
        this.delegateCall(declaration);
        this.returnArgument(declaration);
        declaration.append("\t}\n");
        if (this.operationName.equals("insert")) {
            this.convertException(declaration, "jakarta.persistence.EntityExistsException", "jakarta.data.exceptions.EntityExistsException");
        } else {
            this.convertException(declaration, "jakarta.persistence.OptimisticLockException", "jakarta.data.exceptions.OptimisticLockingFailureException");
        }
        this.convertException(declaration, "jakarta.persistence.PersistenceException", "jakarta.data.exceptions.DataException");
        declaration.append("}");
        return declaration.toString();
    }

    private void returnArgument(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        if (this.returnArgument) {
            declaration.append("\t\treturn ").append(this.parameterName).append(";\n");
        }
    }

    private void delegateCall(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        if (this.iterateParameter) {
            declaration.append("\t\tfor (var entity : ").append(this.parameterName).append(") {\n\t");
        }
        declaration.append("\t\t").append(this.sessionName).append('.').append(this.operationName).append('(').append(this.iterateParameter ? "entity" : this.parameterName).append(')').append(";\n");
        if (this.iterateParameter) {
            declaration.append("\t\t}\n");
        }
    }

    private void preamble(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        declaration.append("\n@Override\npublic ").append(this.returnArgument ? this.annotationMetaEntity.importType(this.entity) : "void").append(' ').append(this.methodName).append('(');
        this.notNull(declaration);
        declaration.append(this.annotationMetaEntity.importType(this.entity)).append(' ').append(this.parameterName).append(')').append(" {\n");
    }

    private void nullCheck(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        declaration.append("\tif (").append(this.parameterName).append(" == null) throw new IllegalArgumentException(\"Null ").append(this.parameterName).append("\");\n");
    }

    private void convertException(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration, @UnknownKeyFor @NonNull @Initialized String exception, @UnknownKeyFor @NonNull @Initialized String convertedException) {
        declaration.append("\tcatch (").append(this.annotationMetaEntity.importType(exception)).append(" exception) {\n").append("\t\tthrow new ").append(this.annotationMetaEntity.importType(convertedException)).append("(exception);\n").append("\t}\n");
    }

    private void notNull(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        if (this.addNonnullAnnotation) {
            declaration.append('@').append(this.annotationMetaEntity.importType("jakarta.annotation.Nonnull")).append(' ');
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getAttributeNameDeclarationString() {
        throw new UnsupportedOperationException("operation not supported");
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getMetaType() {
        throw new UnsupportedOperationException("operation not supported");
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getPropertyName() {
        return this.methodName;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getTypeDeclaration() {
        return this.entity;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Metamodel getHostingEntity() {
        return this.annotationMetaEntity;
    }
}

