/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.hibernate.processor.Context;
import org.hibernate.processor.ImportContextImpl;
import org.hibernate.processor.MetaModelGenerationException;
import org.hibernate.processor.model.ImportContext;
import org.hibernate.processor.model.MetaAttribute;
import org.hibernate.processor.model.Metamodel;
import org.hibernate.processor.util.AccessTypeInformation;
import org.hibernate.processor.util.Constants;
import org.hibernate.processor.util.NullnessUtil;
import org.hibernate.processor.util.StringUtil;
import org.hibernate.processor.util.TypeUtils;
import org.hibernate.processor.xml.XmlMetaCollection;
import org.hibernate.processor.xml.XmlMetaMap;
import org.hibernate.processor.xml.XmlMetaSingleAttribute;
import org.hibernate.processor.xml.jaxb.AccessType;
import org.hibernate.processor.xml.jaxb.Attributes;
import org.hibernate.processor.xml.jaxb.Basic;
import org.hibernate.processor.xml.jaxb.ElementCollection;
import org.hibernate.processor.xml.jaxb.Embeddable;
import org.hibernate.processor.xml.jaxb.EmbeddableAttributes;
import org.hibernate.processor.xml.jaxb.Embedded;
import org.hibernate.processor.xml.jaxb.EmbeddedId;
import org.hibernate.processor.xml.jaxb.Entity;
import org.hibernate.processor.xml.jaxb.Id;
import org.hibernate.processor.xml.jaxb.ManyToMany;
import org.hibernate.processor.xml.jaxb.ManyToOne;
import org.hibernate.processor.xml.jaxb.MapKeyClass;
import org.hibernate.processor.xml.jaxb.MappedSuperclass;
import org.hibernate.processor.xml.jaxb.OneToMany;
import org.hibernate.processor.xml.jaxb.OneToOne;

public class XmlMetaEntity
implements Metamodel {
    private final @UnknownKeyFor @NonNull @Initialized String clazzName;
    private final @UnknownKeyFor @NonNull @Initialized String packageName;
    private final @UnknownKeyFor @NonNull @Initialized String defaultPackageName;
    private final @UnknownKeyFor @NonNull @Initialized ImportContext importContext;
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized MetaAttribute> members = new ArrayList<MetaAttribute>();
    private final @UnknownKeyFor @NonNull @Initialized TypeElement element;
    private final @UnknownKeyFor @NonNull @Initialized Context context;
    private final @UnknownKeyFor @NonNull @Initialized boolean isMetaComplete;
    private @Nullable @UnknownKeyFor @Initialized Attributes attributes;
    private @Nullable @UnknownKeyFor @Initialized EmbeddableAttributes embeddableAttributes;
    private @UnknownKeyFor @NonNull @Initialized AccessTypeInformation accessTypeInfo;
    private @UnknownKeyFor @NonNull @Initialized boolean initialized;

    XmlMetaEntity(@UnknownKeyFor @NonNull @Initialized Entity ormEntity, @UnknownKeyFor @NonNull @Initialized String defaultPackageName, @UnknownKeyFor @NonNull @Initialized TypeElement element, @UnknownKeyFor @NonNull @Initialized Context context) {
        this(ormEntity.getClazz(), defaultPackageName, element, context, ormEntity.isMetadataComplete());
        this.attributes = ormEntity.getAttributes();
        this.embeddableAttributes = null;
    }

    static @UnknownKeyFor @NonNull @Initialized XmlMetaEntity create(@UnknownKeyFor @NonNull @Initialized Entity ormEntity, @UnknownKeyFor @NonNull @Initialized String defaultPackageName, @UnknownKeyFor @NonNull @Initialized TypeElement element, @UnknownKeyFor @NonNull @Initialized Context context) {
        XmlMetaEntity entity = new XmlMetaEntity(ormEntity, defaultPackageName, element, context);
        entity.init();
        return entity;
    }

    XmlMetaEntity(@UnknownKeyFor @NonNull @Initialized MappedSuperclass mappedSuperclass, @UnknownKeyFor @NonNull @Initialized String defaultPackageName, @UnknownKeyFor @NonNull @Initialized TypeElement element, @UnknownKeyFor @NonNull @Initialized Context context) {
        this(mappedSuperclass.getClazz(), defaultPackageName, element, context, mappedSuperclass.isMetadataComplete());
        this.attributes = mappedSuperclass.getAttributes();
        this.embeddableAttributes = null;
    }

    XmlMetaEntity(@UnknownKeyFor @NonNull @Initialized Embeddable embeddable, @UnknownKeyFor @NonNull @Initialized String defaultPackageName, @UnknownKeyFor @NonNull @Initialized TypeElement element, @UnknownKeyFor @NonNull @Initialized Context context) {
        this(embeddable.getClazz(), defaultPackageName, element, context, embeddable.isMetadataComplete());
        this.attributes = null;
        this.embeddableAttributes = embeddable.getAttributes();
    }

    private XmlMetaEntity(@UnknownKeyFor @NonNull @Initialized String clazz, @UnknownKeyFor @NonNull @Initialized String defaultPackageName, @UnknownKeyFor @NonNull @Initialized TypeElement element, @UnknownKeyFor @NonNull @Initialized Context context, @UnknownKeyFor @NonNull @Initialized Boolean metaComplete) {
        this.defaultPackageName = defaultPackageName;
        String className = clazz;
        String pkg = defaultPackageName;
        if (StringUtil.isFullyQualified(className)) {
            pkg = StringUtil.packageNameFromFqcn(className);
            className = StringUtil.classNameFromFqcn(clazz);
        }
        this.clazzName = className;
        this.packageName = pkg;
        this.context = context;
        this.importContext = new ImportContextImpl(pkg);
        this.element = element;
        this.isMetaComplete = XmlMetaEntity.initIsMetaComplete(context, metaComplete);
    }

    private void init() {
        this.context.logMessage(Diagnostic.Kind.OTHER, "Initializing type " + this.getQualifiedName() + ".");
        this.accessTypeInfo = NullnessUtil.castNonNull(this.context.getAccessTypeInfo(this.getQualifiedName()));
        if (this.attributes != null) {
            this.parseAttributes(this.attributes);
        } else {
            this.parseEmbeddableAttributes(this.embeddableAttributes);
        }
        this.initialized = true;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getSimpleName() {
        return this.clazzName;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getQualifiedName() {
        return this.packageName + "." + this.getSimpleName();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getPackageName() {
        return this.packageName;
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized String getSupertypeName() {
        return TypeUtils.findMappedSuperClass(this, this.context);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized MetaAttribute> getMembers() {
        if (!this.initialized) {
            this.init();
        }
        return this.members;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String generateImports() {
        return this.importContext.generateImports();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String importType(@UnknownKeyFor @NonNull @Initialized String fqcn) {
        return this.importContext.importType(fqcn);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String staticImport(@UnknownKeyFor @NonNull @Initialized String fqcn, @UnknownKeyFor @NonNull @Initialized String member) {
        return this.importContext.staticImport(fqcn, member);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized TypeElement getElement() {
        return this.element;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isMetaComplete() {
        return this.isMetaComplete;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("XmlMetaEntity");
        sb.append("{accessTypeInfo=").append(this.accessTypeInfo);
        sb.append(", clazzName='").append(this.clazzName).append('\'');
        sb.append(", members=").append(this.members);
        sb.append(", isMetaComplete=").append(this.isMetaComplete);
        sb.append('}');
        return sb.toString();
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean initIsMetaComplete(@UnknownKeyFor @NonNull @Initialized Context context, @UnknownKeyFor @NonNull @Initialized Boolean metadataComplete) {
        return context.isFullyXmlConfigured() || Boolean.TRUE.equals(metadataComplete);
    }

    private @Nullable @UnknownKeyFor @Initialized String @Nullable @UnknownKeyFor @Initialized [] getCollectionTypes(@UnknownKeyFor @NonNull @Initialized String propertyName, @UnknownKeyFor @NonNull @Initialized String explicitTargetEntity, @Nullable @UnknownKeyFor @Initialized String explicitMapKeyClass, @UnknownKeyFor @NonNull @Initialized ElementKind expectedElementKind) {
        for (Element element : this.element.getEnclosedElements()) {
            DeclaredType type;
            if (!expectedElementKind.equals((Object)element.getKind())) continue;
            String elementPropertyName = element.getSimpleName().toString();
            if (element.getKind().equals((Object)ElementKind.METHOD)) {
                elementPropertyName = StringUtil.getPropertyName(elementPropertyName);
            }
            if (!propertyName.equals(elementPropertyName) || (type = this.determineDeclaredType(element)) == null) continue;
            return this.determineTypes(propertyName, explicitTargetEntity, explicitMapKeyClass, type);
        }
        return null;
    }

    private @Nullable @UnknownKeyFor @Initialized DeclaredType determineDeclaredType(@UnknownKeyFor @NonNull @Initialized Element elem) {
        ExecutableType executableType;
        DeclaredType type = null;
        if (elem.asType() instanceof DeclaredType) {
            type = (DeclaredType)elem.asType();
        } else if (elem.asType() instanceof ExecutableType && (executableType = (ExecutableType)elem.asType()).getReturnType() instanceof DeclaredType) {
            type = (DeclaredType)executableType.getReturnType();
        }
        return type;
    }

    private @Nullable @UnknownKeyFor @Initialized String @UnknownKeyFor @NonNull @Initialized [] determineTypes(@UnknownKeyFor @NonNull @Initialized String propertyName, @UnknownKeyFor @NonNull @Initialized String explicitTargetEntity, @Nullable @UnknownKeyFor @Initialized String explicitMapKeyClass, @UnknownKeyFor @NonNull @Initialized DeclaredType type) {
        @Nullable String[] types = new String[3];
        this.determineTargetType(type, propertyName, explicitTargetEntity, types);
        if (this.determineCollectionType(type, types).equals("jakarta.persistence.metamodel.MapAttribute")) {
            this.determineMapType(type, explicitMapKeyClass, types);
        }
        return types;
    }

    private void determineMapType(@UnknownKeyFor @NonNull @Initialized DeclaredType type, @Nullable @UnknownKeyFor @Initialized String explicitMapKeyClass, @Nullable @UnknownKeyFor @Initialized String @UnknownKeyFor @NonNull @Initialized [] types) {
        types[2] = explicitMapKeyClass != null ? explicitMapKeyClass : TypeUtils.getKeyType(type, this.context);
    }

    private @UnknownKeyFor @NonNull @Initialized String determineCollectionType(@UnknownKeyFor @NonNull @Initialized DeclaredType type, @Nullable @UnknownKeyFor @Initialized String @UnknownKeyFor @NonNull @Initialized [] types) {
        types[1] = Constants.COLLECTIONS.get(type.asElement().toString());
        return NullnessUtil.castNonNull(types[1]);
    }

    private void determineTargetType(@UnknownKeyFor @NonNull @Initialized DeclaredType type, @UnknownKeyFor @NonNull @Initialized String propertyName, @UnknownKeyFor @NonNull @Initialized String explicitTargetEntity, @Nullable @UnknownKeyFor @Initialized String @UnknownKeyFor @NonNull @Initialized [] types) {
        List<? extends TypeMirror> typeArguments = type.getTypeArguments();
        if (typeArguments.isEmpty() && explicitTargetEntity == null) {
            throw new MetaModelGenerationException("Unable to determine target entity type for " + this.clazzName + "." + propertyName + ".");
        }
        types[0] = explicitTargetEntity == null ? TypeUtils.extractClosestRealTypeAsString(typeArguments.get(0), this.context) : explicitTargetEntity;
    }

    private @Nullable @UnknownKeyFor @Initialized String getType(@UnknownKeyFor @NonNull @Initialized String propertyName, @Nullable @UnknownKeyFor @Initialized String explicitTargetEntity, @UnknownKeyFor @NonNull @Initialized ElementKind expectedElementKind) {
        for (Element element : this.element.getEnclosedElements()) {
            TypeMirror mirror;
            if (!expectedElementKind.equals((Object)element.getKind())) continue;
            String name = element.getSimpleName().toString();
            if (ElementKind.METHOD.equals((Object)element.getKind())) {
                name = StringUtil.getPropertyName(name);
                mirror = ((ExecutableElement)element).getReturnType();
            } else {
                mirror = element.asType();
            }
            if (name == null || !name.equals(propertyName)) continue;
            if (explicitTargetEntity != null) {
                return explicitTargetEntity;
            }
            switch (mirror.getKind()) {
                case INT: {
                    return "java.lang.Integer";
                }
                case LONG: {
                    return "java.lang.Long";
                }
                case BOOLEAN: {
                    return "java.lang.Boolean";
                }
                case BYTE: {
                    return "java.lang.Byte";
                }
                case SHORT: {
                    return "java.lang.Short";
                }
                case CHAR: {
                    return "java.lang.Char";
                }
                case FLOAT: {
                    return "java.lang.Float";
                }
                case DOUBLE: {
                    return "java.lang.Double";
                }
                case DECLARED: {
                    return ((DeclaredType)mirror).asElement().asType().toString();
                }
                case TYPEVAR: {
                    return mirror.toString();
                }
            }
        }
        this.context.logMessage(Diagnostic.Kind.WARNING, "Unable to determine type for property " + propertyName + " of class " + this.getQualifiedName() + " using access type " + this.accessTypeInfo.getDefaultAccessType());
        return null;
    }

    private void parseAttributes(@UnknownKeyFor @NonNull @Initialized Attributes attributes) {
        ElementCollection collection;
        OneToMany oneToMany;
        ManyToMany manyToMany;
        XmlMetaSingleAttribute attribute;
        for (Id id : attributes.getId()) {
            ElementKind elementKind = this.getElementKind(id.getAccess());
            String type = this.getType(id.getName(), null, elementKind);
            if (type == null) continue;
            attribute = new XmlMetaSingleAttribute(this, id.getName(), type);
            this.members.add(attribute);
        }
        if (attributes.getEmbeddedId() != null) {
            EmbeddedId embeddedId = attributes.getEmbeddedId();
            ElementKind elementKind = this.getElementKind(embeddedId.getAccess());
            String type = this.getType(embeddedId.getName(), null, elementKind);
            if (type != null) {
                attribute = new XmlMetaSingleAttribute(this, embeddedId.getName(), type);
                this.members.add(attribute);
            }
        }
        for (Basic basic : attributes.getBasic()) {
            this.parseBasic(basic);
        }
        for (ManyToOne manyToOne : attributes.getManyToOne()) {
            this.parseManyToOne(manyToOne);
        }
        for (OneToOne oneToOne : attributes.getOneToOne()) {
            this.parseOneToOne(oneToOne);
        }
        Iterator<Object> iterator = attributes.getManyToMany().iterator();
        while (iterator.hasNext() && !this.parseManyToMany(manyToMany = (ManyToMany)iterator.next())) {
        }
        iterator = attributes.getOneToMany().iterator();
        while (iterator.hasNext() && !this.parseOneToMany(oneToMany = (OneToMany)iterator.next())) {
        }
        iterator = attributes.getElementCollection().iterator();
        while (iterator.hasNext() && !this.parseElementCollection(collection = (ElementCollection)iterator.next())) {
        }
        for (Embedded embedded : attributes.getEmbedded()) {
            this.parseEmbedded(embedded);
        }
    }

    private void parseEmbeddableAttributes(@Nullable @UnknownKeyFor @Initialized EmbeddableAttributes attributes) {
        ElementCollection collection;
        OneToMany oneToMany;
        ManyToMany manyToMany;
        if (attributes == null) {
            return;
        }
        for (Basic basic : attributes.getBasic()) {
            this.parseBasic(basic);
        }
        for (ManyToOne manyToOne : attributes.getManyToOne()) {
            this.parseManyToOne(manyToOne);
        }
        for (OneToOne oneToOne : attributes.getOneToOne()) {
            this.parseOneToOne(oneToOne);
        }
        Iterator<Object> iterator = attributes.getManyToMany().iterator();
        while (iterator.hasNext() && !this.parseManyToMany(manyToMany = (ManyToMany)iterator.next())) {
        }
        iterator = attributes.getOneToMany().iterator();
        while (iterator.hasNext() && !this.parseOneToMany(oneToMany = (OneToMany)iterator.next())) {
        }
        iterator = attributes.getElementCollection().iterator();
        while (iterator.hasNext() && !this.parseElementCollection(collection = (ElementCollection)iterator.next())) {
        }
    }

    private @UnknownKeyFor @NonNull @Initialized boolean parseElementCollection(@UnknownKeyFor @NonNull @Initialized ElementCollection collection) {
        String[] types;
        ElementKind elementKind = this.getElementKind(collection.getAccess());
        String explicitTargetClass = this.determineExplicitTargetEntity(collection.getTargetClass());
        String explicitMapKey = this.determineExplicitMapKeyClass(collection.getMapKeyClass());
        try {
            types = this.getCollectionTypes(collection.getName(), explicitTargetClass, explicitMapKey, elementKind);
        }
        catch (MetaModelGenerationException e) {
            this.logMetaModelException(collection.getName(), e);
            return true;
        }
        if (types != null) {
            String type = NullnessUtil.castNonNull(types[0]);
            String collectionType = NullnessUtil.castNonNull(types[1]);
            String keyType = types[2];
            XmlMetaCollection metaCollection = keyType == null ? new XmlMetaCollection(this, collection.getName(), type, collectionType) : new XmlMetaMap(this, collection.getName(), type, collectionType, keyType);
            this.members.add(metaCollection);
        }
        return false;
    }

    private void parseEmbedded(@UnknownKeyFor @NonNull @Initialized Embedded embedded) {
        ElementKind elementKind = this.getElementKind(embedded.getAccess());
        String type = this.getType(embedded.getName(), null, elementKind);
        if (type != null) {
            XmlMetaSingleAttribute attribute = new XmlMetaSingleAttribute(this, embedded.getName(), type);
            this.members.add(attribute);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized String determineExplicitTargetEntity(@UnknownKeyFor @NonNull @Initialized String targetClass) {
        String explicitTargetClass = targetClass;
        if (explicitTargetClass != null) {
            explicitTargetClass = StringUtil.determineFullyQualifiedClassName(this.defaultPackageName, targetClass);
        }
        return explicitTargetClass;
    }

    private @Nullable @UnknownKeyFor @Initialized String determineExplicitMapKeyClass(@UnknownKeyFor @NonNull @Initialized MapKeyClass mapKeyClass) {
        String explicitMapKey = null;
        if (mapKeyClass != null) {
            explicitMapKey = StringUtil.determineFullyQualifiedClassName(this.defaultPackageName, mapKeyClass.getClazz());
        }
        return explicitMapKey;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean parseOneToMany(@UnknownKeyFor @NonNull @Initialized OneToMany oneToMany) {
        String[] types;
        ElementKind elementKind = this.getElementKind(oneToMany.getAccess());
        String explicitTargetClass = this.determineExplicitTargetEntity(oneToMany.getTargetEntity());
        String explicitMapKey = this.determineExplicitMapKeyClass(oneToMany.getMapKeyClass());
        try {
            types = this.getCollectionTypes(oneToMany.getName(), explicitTargetClass, explicitMapKey, elementKind);
        }
        catch (MetaModelGenerationException e) {
            this.logMetaModelException(oneToMany.getName(), e);
            return true;
        }
        if (types != null) {
            String type = NullnessUtil.castNonNull(types[0]);
            String collectionType = NullnessUtil.castNonNull(types[1]);
            String keyType = types[2];
            XmlMetaCollection metaCollection = keyType == null ? new XmlMetaCollection(this, oneToMany.getName(), type, collectionType) : new XmlMetaMap(this, oneToMany.getName(), type, collectionType, keyType);
            this.members.add(metaCollection);
        }
        return false;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean parseManyToMany(@UnknownKeyFor @NonNull @Initialized ManyToMany manyToMany) {
        String[] types;
        ElementKind elementKind = this.getElementKind(manyToMany.getAccess());
        String explicitTargetClass = this.determineExplicitTargetEntity(manyToMany.getTargetEntity());
        String explicitMapKey = this.determineExplicitMapKeyClass(manyToMany.getMapKeyClass());
        try {
            types = this.getCollectionTypes(manyToMany.getName(), explicitTargetClass, explicitMapKey, elementKind);
        }
        catch (MetaModelGenerationException e) {
            this.logMetaModelException(manyToMany.getName(), e);
            return true;
        }
        if (types != null) {
            String type = NullnessUtil.castNonNull(types[0]);
            String collectionType = NullnessUtil.castNonNull(types[1]);
            String keyType = types[2];
            XmlMetaCollection metaCollection = keyType == null ? new XmlMetaCollection(this, manyToMany.getName(), type, collectionType) : new XmlMetaMap(this, manyToMany.getName(), type, collectionType, keyType);
            this.members.add(metaCollection);
        }
        return false;
    }

    private void parseOneToOne(@UnknownKeyFor @NonNull @Initialized OneToOne oneToOne) {
        ElementKind elementKind = this.getElementKind(oneToOne.getAccess());
        String type = this.getType(oneToOne.getName(), oneToOne.getTargetEntity(), elementKind);
        if (type != null) {
            XmlMetaSingleAttribute attribute = new XmlMetaSingleAttribute(this, oneToOne.getName(), type);
            this.members.add(attribute);
        }
    }

    private void parseManyToOne(@UnknownKeyFor @NonNull @Initialized ManyToOne manyToOne) {
        ElementKind elementKind = this.getElementKind(manyToOne.getAccess());
        String type = this.getType(manyToOne.getName(), manyToOne.getTargetEntity(), elementKind);
        if (type != null) {
            XmlMetaSingleAttribute attribute = new XmlMetaSingleAttribute(this, manyToOne.getName(), type);
            this.members.add(attribute);
        }
    }

    private void parseBasic(@UnknownKeyFor @NonNull @Initialized Basic basic) {
        ElementKind elementKind = this.getElementKind(basic.getAccess());
        String type = this.getType(basic.getName(), null, elementKind);
        if (type != null) {
            XmlMetaSingleAttribute attribute = new XmlMetaSingleAttribute(this, basic.getName(), type);
            this.members.add(attribute);
        }
    }

    private void logMetaModelException(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized MetaModelGenerationException e) {
        StringBuilder builder = new StringBuilder();
        builder.append("Error processing xml for ");
        builder.append(this.clazzName);
        builder.append(".");
        builder.append(name);
        builder.append(". Error message: ");
        builder.append(e.getMessage());
        this.context.logMessage(Diagnostic.Kind.WARNING, builder.toString());
    }

    private @UnknownKeyFor @NonNull @Initialized ElementKind getElementKind(@UnknownKeyFor @NonNull @Initialized AccessType accessType) {
        if (accessType == null) {
            return TypeUtils.getElementKindForAccessType(this.accessTypeInfo.getAccessType());
        }
        return AccessType.FIELD.equals((Object)accessType) ? ElementKind.FIELD : ElementKind.METHOD;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Context getContext() {
        return this.context;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isImplementation() {
        return false;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isInjectable() {
        return false;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String scope() {
        throw new UnsupportedOperationException("operation not supported");
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isJakartaDataStyle() {
        return false;
    }
}

