/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor;

import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleTypeVisitor8;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.processor.Context;
import org.hibernate.processor.util.Constants;
import org.hibernate.processor.util.StringUtil;
import org.hibernate.processor.util.TypeUtils;

class ContainsAttributeTypeVisitor
extends SimpleTypeVisitor8<Boolean, Element> {
    private final @UnknownKeyFor @NonNull @Initialized Context context;
    private final @UnknownKeyFor @NonNull @Initialized TypeElement type;

    ContainsAttributeTypeVisitor(@UnknownKeyFor @NonNull @Initialized TypeElement elem, @UnknownKeyFor @NonNull @Initialized Context context) {
        this.context = context;
        this.type = elem;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Boolean visitDeclared(@UnknownKeyFor @NonNull @Initialized DeclaredType declaredType, @UnknownKeyFor @NonNull @Initialized Element element) {
        TypeElement returnedElement = (TypeElement)this.context.getTypeUtils().asElement(declaredType);
        String returnTypeName = returnedElement.getQualifiedName().toString();
        String collection = Constants.COLLECTIONS.get(returnTypeName);
        if (collection != null) {
            TypeMirror collectionElementType = TypeUtils.getCollectionElementType(declaredType, returnTypeName, null, this.context);
            Element collectionElement = this.context.getTypeUtils().asElement(collectionElementType);
            if (ElementKind.TYPE_PARAMETER == collectionElement.getKind()) {
                return false;
            }
            returnedElement = (TypeElement)collectionElement;
        }
        return this.type.getQualifiedName().contentEquals(returnedElement.getQualifiedName());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Boolean visitExecutable(@UnknownKeyFor @NonNull @Initialized ExecutableType executable, @UnknownKeyFor @NonNull @Initialized Element element) {
        return element.getKind() == ElementKind.METHOD && StringUtil.isProperty(element.getSimpleName().toString(), TypeUtils.toTypeString(executable.getReturnType())) && executable.getReturnType().accept(this, element) != false;
    }
}

