/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.annotation;

import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.SimpleTypeVisitor8;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.processor.Context;
import org.hibernate.processor.annotation.AnnotationMetaAttribute;
import org.hibernate.processor.annotation.AnnotationMetaCollection;
import org.hibernate.processor.annotation.AnnotationMetaEntity;
import org.hibernate.processor.annotation.AnnotationMetaMap;
import org.hibernate.processor.annotation.AnnotationMetaSingleAttribute;
import org.hibernate.processor.util.AccessType;
import org.hibernate.processor.util.AccessTypeInformation;
import org.hibernate.processor.util.Constants;
import org.hibernate.processor.util.NullnessUtil;
import org.hibernate.processor.util.TypeUtils;

public class MetaAttributeGenerationVisitor
extends SimpleTypeVisitor8<AnnotationMetaAttribute, Element> {
    private final @UnknownKeyFor @NonNull @Initialized AnnotationMetaEntity entity;
    private final @UnknownKeyFor @NonNull @Initialized Context context;

    MetaAttributeGenerationVisitor(@UnknownKeyFor @NonNull @Initialized AnnotationMetaEntity entity, @UnknownKeyFor @NonNull @Initialized Context context) {
        this.entity = entity;
        this.context = context;
    }

    private @UnknownKeyFor @NonNull @Initialized Types typeUtils() {
        return this.context.getTypeUtils();
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized AnnotationMetaAttribute visitPrimitive(@UnknownKeyFor @NonNull @Initialized PrimitiveType primitiveType, @UnknownKeyFor @NonNull @Initialized Element element) {
        return new AnnotationMetaSingleAttribute(this.entity, element, TypeUtils.toTypeString(primitiveType));
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized AnnotationMetaAttribute visitArray(@UnknownKeyFor @NonNull @Initialized ArrayType arrayType, @UnknownKeyFor @NonNull @Initialized Element element) {
        return new AnnotationMetaSingleAttribute(this.entity, element, TypeUtils.toArrayTypeString(arrayType, this.context));
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized AnnotationMetaAttribute visitTypeVariable(@UnknownKeyFor @NonNull @Initialized TypeVariable typeVariable, @UnknownKeyFor @NonNull @Initialized Element element) {
        return new AnnotationMetaSingleAttribute(this.entity, element, this.typeUtils().erasure(typeVariable.getUpperBound()).toString());
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized AnnotationMetaAttribute visitDeclared(@UnknownKeyFor @NonNull @Initialized DeclaredType declaredType, @UnknownKeyFor @NonNull @Initialized Element element) {
        TypeElement returnedElement = (TypeElement)this.typeUtils().asElement(declaredType);
        String returnTypeName = returnedElement.getQualifiedName().toString();
        String collection = Constants.COLLECTIONS.get(returnTypeName);
        String targetEntity = TypeUtils.getTargetEntity(element.getAnnotationMirrors());
        if (collection != null) {
            return this.createMetaCollectionAttribute(declaredType, element, returnTypeName, collection, targetEntity);
        }
        if (TypeUtils.isBasicAttribute(element, returnedElement, this.context)) {
            String type = targetEntity != null ? targetEntity : returnedElement.getQualifiedName().toString();
            return new AnnotationMetaSingleAttribute(this.entity, element, type);
        }
        return null;
    }

    private @UnknownKeyFor @NonNull @Initialized AnnotationMetaAttribute createMetaCollectionAttribute(@UnknownKeyFor @NonNull @Initialized DeclaredType declaredType, @UnknownKeyFor @NonNull @Initialized Element element, @UnknownKeyFor @NonNull @Initialized String returnTypeName, @UnknownKeyFor @NonNull @Initialized String collection, @Nullable @UnknownKeyFor @Initialized String targetEntity) {
        String explicitTargetEntity;
        TypeMirror collectionElementType;
        if (TypeUtils.hasAnnotation(element, "jakarta.persistence.ElementCollection") && (collectionElementType = TypeUtils.getCollectionElementType(declaredType, returnTypeName, explicitTargetEntity = TypeUtils.getTargetEntity(element.getAnnotationMirrors()), this.context)).getKind() == TypeKind.DECLARED) {
            TypeElement collectionElement = (TypeElement)this.typeUtils().asElement(collectionElementType);
            this.setAccessType(collectionElementType, collectionElement);
        }
        return this.createMetaAttribute(declaredType, element, collection, targetEntity);
    }

    private @UnknownKeyFor @NonNull @Initialized AnnotationMetaAttribute createMetaAttribute(@UnknownKeyFor @NonNull @Initialized DeclaredType declaredType, @UnknownKeyFor @NonNull @Initialized Element element, @UnknownKeyFor @NonNull @Initialized String collection, @Nullable @UnknownKeyFor @Initialized String targetEntity) {
        if (TypeUtils.hasAnnotation(element, "jakarta.persistence.OneToMany", "jakarta.persistence.ManyToMany", "org.hibernate.annotations.ManyToAny", "jakarta.persistence.ElementCollection")) {
            String elementType = this.getElementType(declaredType, targetEntity);
            if (collection.equals("jakarta.persistence.metamodel.MapAttribute")) {
                String keyType = this.getMapKeyType(declaredType, element);
                return new AnnotationMetaMap(this.entity, element, collection, keyType, elementType);
            }
            return new AnnotationMetaCollection(this.entity, element, collection, elementType);
        }
        return new AnnotationMetaSingleAttribute(this.entity, element, TypeUtils.extractClosestRealTypeAsString(declaredType, this.context));
    }

    private void setAccessType(@UnknownKeyFor @NonNull @Initialized TypeMirror collectionElementType, @UnknownKeyFor @NonNull @Initialized TypeElement collectionElement) {
        String elementTypeName = collectionElementType.toString();
        AccessTypeInformation accessTypeInfo = this.context.getAccessTypeInfo(elementTypeName);
        AccessType entityAccessType = this.entity.getEntityAccessTypeInfo().getAccessType();
        if (accessTypeInfo == null) {
            this.context.addAccessTypeInformation(elementTypeName, new AccessTypeInformation(elementTypeName, collectionElement == null ? null : TypeUtils.determineAnnotationSpecifiedAccessType(collectionElement), entityAccessType));
        } else {
            accessTypeInfo.setDefaultAccessType(entityAccessType);
        }
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized AnnotationMetaAttribute visitExecutable(@UnknownKeyFor @NonNull @Initialized ExecutableType executable, @UnknownKeyFor @NonNull @Initialized Element element) {
        return TypeUtils.isPropertyGetter(executable, element) ? executable.getReturnType().accept(this, element) : null;
    }

    private @UnknownKeyFor @NonNull @Initialized String getMapKeyType(@UnknownKeyFor @NonNull @Initialized DeclaredType declaredType, @UnknownKeyFor @NonNull @Initialized Element element) {
        AnnotationMirror annotationMirror = TypeUtils.getAnnotationMirror(element, "jakarta.persistence.MapKeyClass");
        return annotationMirror == null ? TypeUtils.getKeyType(declaredType, this.context) : NullnessUtil.castNonNull(TypeUtils.getAnnotationValue(annotationMirror, "value")).getValue().toString();
    }

    private @UnknownKeyFor @NonNull @Initialized String getElementType(@UnknownKeyFor @NonNull @Initialized DeclaredType declaredType, @Nullable @UnknownKeyFor @Initialized String targetEntity) {
        if (targetEntity != null) {
            return targetEntity;
        }
        List<? extends TypeMirror> mirrors = declaredType.getTypeArguments();
        switch (mirrors.size()) {
            case 0: {
                return "?";
            }
            case 1: {
                return TypeUtils.extractClosestRealTypeAsString(mirrors.get(0), this.context);
            }
            case 2: {
                return TypeUtils.extractClosestRealTypeAsString(mirrors.get(1), this.context);
            }
        }
        this.context.logMessage(Diagnostic.Kind.WARNING, "Unable to find the closest solid type" + declaredType);
        return "?";
    }
}

