
package org.hibernate.processor.xml.jaxb;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;


/**
 * 
 * 
 *         Defines an entity listener to be invoked at lifecycle events
 *         for the entities that list this listener.
 * 
 *       
 * 
 * <p>Java class for entity-listener complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="entity-listener">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="description" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         <element name="pre-persist" type="{https://jakarta.ee/xml/ns/persistence/orm}pre-persist" minOccurs="0"/>
 *         <element name="post-persist" type="{https://jakarta.ee/xml/ns/persistence/orm}post-persist" minOccurs="0"/>
 *         <element name="pre-remove" type="{https://jakarta.ee/xml/ns/persistence/orm}pre-remove" minOccurs="0"/>
 *         <element name="post-remove" type="{https://jakarta.ee/xml/ns/persistence/orm}post-remove" minOccurs="0"/>
 *         <element name="pre-update" type="{https://jakarta.ee/xml/ns/persistence/orm}pre-update" minOccurs="0"/>
 *         <element name="post-update" type="{https://jakarta.ee/xml/ns/persistence/orm}post-update" minOccurs="0"/>
 *         <element name="post-load" type="{https://jakarta.ee/xml/ns/persistence/orm}post-load" minOccurs="0"/>
 *       </sequence>
 *       <attribute name="class" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "entity-listener", namespace = "https://jakarta.ee/xml/ns/persistence/orm", propOrder = {
    "description",
    "prePersist",
    "postPersist",
    "preRemove",
    "postRemove",
    "preUpdate",
    "postUpdate",
    "postLoad"
})
public class EntityListener {

    @XmlElement(namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected String description;
    @XmlElement(name = "pre-persist", namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected PrePersist prePersist;
    @XmlElement(name = "post-persist", namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected PostPersist postPersist;
    @XmlElement(name = "pre-remove", namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected PreRemove preRemove;
    @XmlElement(name = "post-remove", namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected PostRemove postRemove;
    @XmlElement(name = "pre-update", namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected PreUpdate preUpdate;
    @XmlElement(name = "post-update", namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected PostUpdate postUpdate;
    @XmlElement(name = "post-load", namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected PostLoad postLoad;
    @XmlAttribute(name = "class", required = true)
    protected String clazz;

    /**
     * Gets the value of the description property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDescription() {
        return description;
    }

    /**
     * Sets the value of the description property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDescription(String value) {
        this.description = value;
    }

    /**
     * Gets the value of the prePersist property.
     * 
     * @return
     *     possible object is
     *     {@link PrePersist }
     *     
     */
    public PrePersist getPrePersist() {
        return prePersist;
    }

    /**
     * Sets the value of the prePersist property.
     * 
     * @param value
     *     allowed object is
     *     {@link PrePersist }
     *     
     */
    public void setPrePersist(PrePersist value) {
        this.prePersist = value;
    }

    /**
     * Gets the value of the postPersist property.
     * 
     * @return
     *     possible object is
     *     {@link PostPersist }
     *     
     */
    public PostPersist getPostPersist() {
        return postPersist;
    }

    /**
     * Sets the value of the postPersist property.
     * 
     * @param value
     *     allowed object is
     *     {@link PostPersist }
     *     
     */
    public void setPostPersist(PostPersist value) {
        this.postPersist = value;
    }

    /**
     * Gets the value of the preRemove property.
     * 
     * @return
     *     possible object is
     *     {@link PreRemove }
     *     
     */
    public PreRemove getPreRemove() {
        return preRemove;
    }

    /**
     * Sets the value of the preRemove property.
     * 
     * @param value
     *     allowed object is
     *     {@link PreRemove }
     *     
     */
    public void setPreRemove(PreRemove value) {
        this.preRemove = value;
    }

    /**
     * Gets the value of the postRemove property.
     * 
     * @return
     *     possible object is
     *     {@link PostRemove }
     *     
     */
    public PostRemove getPostRemove() {
        return postRemove;
    }

    /**
     * Sets the value of the postRemove property.
     * 
     * @param value
     *     allowed object is
     *     {@link PostRemove }
     *     
     */
    public void setPostRemove(PostRemove value) {
        this.postRemove = value;
    }

    /**
     * Gets the value of the preUpdate property.
     * 
     * @return
     *     possible object is
     *     {@link PreUpdate }
     *     
     */
    public PreUpdate getPreUpdate() {
        return preUpdate;
    }

    /**
     * Sets the value of the preUpdate property.
     * 
     * @param value
     *     allowed object is
     *     {@link PreUpdate }
     *     
     */
    public void setPreUpdate(PreUpdate value) {
        this.preUpdate = value;
    }

    /**
     * Gets the value of the postUpdate property.
     * 
     * @return
     *     possible object is
     *     {@link PostUpdate }
     *     
     */
    public PostUpdate getPostUpdate() {
        return postUpdate;
    }

    /**
     * Sets the value of the postUpdate property.
     * 
     * @param value
     *     allowed object is
     *     {@link PostUpdate }
     *     
     */
    public void setPostUpdate(PostUpdate value) {
        this.postUpdate = value;
    }

    /**
     * Gets the value of the postLoad property.
     * 
     * @return
     *     possible object is
     *     {@link PostLoad }
     *     
     */
    public PostLoad getPostLoad() {
        return postLoad;
    }

    /**
     * Sets the value of the postLoad property.
     * 
     * @param value
     *     allowed object is
     *     {@link PostLoad }
     *     
     */
    public void setPostLoad(PostLoad value) {
        this.postLoad = value;
    }

    /**
     * Gets the value of the clazz property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getClazz() {
        return clazz;
    }

    /**
     * Sets the value of the clazz property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setClazz(String value) {
        this.clazz = value;
    }

}
