
package org.hibernate.processor.xml.jaxb;

import java.util.ArrayList;
import java.util.List;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;


/**
 * 
 * 
 *         @Target({TYPE}) @Retention(RUNTIME)
 *         public @interface EntityListeners {
 *           Class[] value();
 *         }
 * 
 *       
 * 
 * <p>Java class for entity-listeners complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="entity-listeners">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="entity-listener" type="{https://jakarta.ee/xml/ns/persistence/orm}entity-listener" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "entity-listeners", namespace = "https://jakarta.ee/xml/ns/persistence/orm", propOrder = {
    "entityListener"
})
public class EntityListeners {

    @XmlElement(name = "entity-listener", namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected List<EntityListener> entityListener;

    /**
     * Gets the value of the entityListener property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the entityListener property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getEntityListener().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link EntityListener }
     * 
     * 
     * @return
     *     The value of the entityListener property.
     */
    public List<EntityListener> getEntityListener() {
        if (entityListener == null) {
            entityListener = new ArrayList<>();
        }
        return this.entityListener;
    }

}
