
package org.hibernate.processor.xml.jaxb;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for generation-type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="generation-type">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}token">
 *     <enumeration value="TABLE"/>
 *     <enumeration value="SEQUENCE"/>
 *     <enumeration value="IDENTITY"/>
 *     <enumeration value="UUID"/>
 *     <enumeration value="AUTO"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "generation-type", namespace = "https://jakarta.ee/xml/ns/persistence/orm")
@XmlEnum
public enum GenerationType {

    TABLE,
    SEQUENCE,
    IDENTITY,
    UUID,
    AUTO;

    public String value() {
        return name();
    }

    public static GenerationType fromValue(String v) {
        return valueOf(v);
    }

}
