
package org.hibernate.processor.xml.jaxb;

import java.util.ArrayList;
import java.util.List;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;


/**
 * 
 * 
 *         @Target({TYPE}) @Retention(RUNTIME)
 *         public @interface NamedStoredProcedureQuery {
 *           String name();
 *           String procedureName();
 *           StoredProcedureParameter[] parameters() default {};
 *           Class[] resultClasses() default {};
 *           String[] resultSetMappings() default{};
 *           QueryHint[] hints() default {};
 *         }
 * 
 *       
 * 
 * <p>Java class for named-stored-procedure-query complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="named-stored-procedure-query">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="description" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         <element name="parameter" type="{https://jakarta.ee/xml/ns/persistence/orm}stored-procedure-parameter" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="result-class" type="{http://www.w3.org/2001/XMLSchema}string" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="result-set-mapping" type="{http://www.w3.org/2001/XMLSchema}string" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="hint" type="{https://jakarta.ee/xml/ns/persistence/orm}query-hint" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *       <attribute name="name" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       <attribute name="procedure-name" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "named-stored-procedure-query", namespace = "https://jakarta.ee/xml/ns/persistence/orm", propOrder = {
    "description",
    "parameter",
    "resultClass",
    "resultSetMapping",
    "hint"
})
public class NamedStoredProcedureQuery {

    @XmlElement(namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected String description;
    @XmlElement(namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected List<StoredProcedureParameter> parameter;
    @XmlElement(name = "result-class", namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected List<String> resultClass;
    @XmlElement(name = "result-set-mapping", namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected List<String> resultSetMapping;
    @XmlElement(namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected List<QueryHint> hint;
    @XmlAttribute(name = "name", required = true)
    protected String name;
    @XmlAttribute(name = "procedure-name", required = true)
    protected String procedureName;

    /**
     * Gets the value of the description property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDescription() {
        return description;
    }

    /**
     * Sets the value of the description property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDescription(String value) {
        this.description = value;
    }

    /**
     * Gets the value of the parameter property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the parameter property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getParameter().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link StoredProcedureParameter }
     * 
     * 
     * @return
     *     The value of the parameter property.
     */
    public List<StoredProcedureParameter> getParameter() {
        if (parameter == null) {
            parameter = new ArrayList<>();
        }
        return this.parameter;
    }

    /**
     * Gets the value of the resultClass property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the resultClass property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getResultClass().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     * 
     * 
     * @return
     *     The value of the resultClass property.
     */
    public List<String> getResultClass() {
        if (resultClass == null) {
            resultClass = new ArrayList<>();
        }
        return this.resultClass;
    }

    /**
     * Gets the value of the resultSetMapping property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the resultSetMapping property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getResultSetMapping().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     * 
     * 
     * @return
     *     The value of the resultSetMapping property.
     */
    public List<String> getResultSetMapping() {
        if (resultSetMapping == null) {
            resultSetMapping = new ArrayList<>();
        }
        return this.resultSetMapping;
    }

    /**
     * Gets the value of the hint property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the hint property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getHint().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link QueryHint }
     * 
     * 
     * @return
     *     The value of the hint property.
     */
    public List<QueryHint> getHint() {
        if (hint == null) {
            hint = new ArrayList<>();
        }
        return this.hint;
    }

    /**
     * Gets the value of the name property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setName(String value) {
        this.name = value;
    }

    /**
     * Gets the value of the procedureName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getProcedureName() {
        return procedureName;
    }

    /**
     * Sets the value of the procedureName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setProcedureName(String value) {
        this.procedureName = value;
    }

}
