/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.postgis;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.geolatte.geom.ByteBuffer;
import org.geolatte.geom.ByteOrder;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.codec.Wkb;
import org.geolatte.geom.codec.WkbDecoder;
import org.geolatte.geom.codec.WkbEncoder;
import org.geolatte.geom.codec.Wkt;
import org.geolatte.geom.codec.WktDecoder;
import org.hibernate.dialect.Dialect;
import org.hibernate.spatial.GeometryLiteralFormatter;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.postgresql.util.PGobject;

public class PGGeometryJdbcType
implements JdbcType {
    private final Wkb.Dialect wkbDialect;
    public static final PGGeometryJdbcType INSTANCE_WKB_2 = new PGGeometryJdbcType(Wkb.Dialect.POSTGIS_EWKB_2);

    public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaType<T> javaType) {
        return new PGGeometryLiteralFormatter<T>(javaType);
    }

    private PGGeometryJdbcType(Wkb.Dialect dialect) {
        this.wkbDialect = dialect;
    }

    public Geometry<?> toGeometry(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof PGobject) {
            String pgValue = ((PGobject)object).getValue();
            if (pgValue == null) {
                return null;
            }
            if (pgValue.startsWith("00") || pgValue.startsWith("01")) {
                ByteBuffer buffer = ByteBuffer.from((String)pgValue);
                WkbDecoder decoder = Wkb.newDecoder((Wkb.Dialect)this.wkbDialect);
                return decoder.decode(buffer);
            }
            return PGGeometryJdbcType.parseWkt(pgValue);
        }
        throw new IllegalStateException("Received object of type " + object.getClass().getCanonicalName());
    }

    private static Geometry<?> parseWkt(String pgValue) {
        WktDecoder decoder = Wkt.newDecoder((Wkt.Dialect)Wkt.Dialect.POSTGIS_EWKT_1);
        return decoder.decode(pgValue);
    }

    public int getJdbcTypeCode() {
        return 1111;
    }

    public int getDefaultSqlTypeCode() {
        return 3200;
    }

    public <X> ValueBinder<X> getBinder(JavaType<X> javaType) {
        return new BasicBinder<X>(javaType, this){

            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                PGobject obj = this.toPGobject(value, options);
                st.setObject(index, obj);
            }

            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                PGobject obj = this.toPGobject(value, options);
                st.setObject(name, (Object)obj);
            }

            private PGobject toPGobject(X value, WrapperOptions options) throws SQLException {
                WkbEncoder encoder = Wkb.newEncoder((Wkb.Dialect)PGGeometryJdbcType.this.wkbDialect);
                Geometry geometry = (Geometry)this.getJavaType().unwrap(value, Geometry.class, options);
                String hexString = encoder.encode(geometry, ByteOrder.NDR).toString();
                PGobject obj = new PGobject();
                obj.setType("geometry");
                obj.setValue(hexString);
                return obj;
            }
        };
    }

    public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
        return new BasicExtractor<X>(javaType, this){

            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return this.getJavaType().wrap(PGGeometryJdbcType.this.toGeometry(rs.getObject(paramIndex)), options);
            }

            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return this.getJavaType().wrap(PGGeometryJdbcType.this.toGeometry(statement.getObject(index)), options);
            }

            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return this.getJavaType().wrap(PGGeometryJdbcType.this.toGeometry(statement.getObject(name)), options);
            }
        };
    }

    static class PGGeometryLiteralFormatter<T>
    extends GeometryLiteralFormatter<T> {
        public PGGeometryLiteralFormatter(JavaType<T> javaType) {
            super(javaType, Wkt.Dialect.POSTGIS_EWKT_1, "");
        }

        @Override
        public void appendJdbcLiteral(SqlAppender appender, T value, Dialect dialect, WrapperOptions wrapperOptions) {
            Geometry geom = (Geometry)this.javaType.unwrap(value, Geometry.class, wrapperOptions);
            appender.appendSql("st_geomfromewkt('");
            appender.appendSql(Wkt.toWkt((Geometry)geom, (Wkt.Dialect)this.wktDialect));
            appender.appendSql("')");
        }
    }
}

