/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.predicate;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import org.hibernate.query.criteria.HibernateCriteriaBuilder;
import org.hibernate.spatial.CommonSpatialFunction;
import org.hibernate.spatial.SpatialFunction;
import org.locationtech.jts.geom.Geometry;

public class JTSSpatialPredicates {
    protected JTSSpatialPredicates() {
    }

    public static Predicate eq(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry1, Expression<? extends Geometry> geometry2) {
        return JTSSpatialPredicates.booleanExpressionToPredicate(criteriaBuilder, (Expression<Boolean>)criteriaBuilder.function(CommonSpatialFunction.ST_EQUALS.name(), Boolean.TYPE, new Expression[]{geometry1, geometry2}));
    }

    public static Predicate eq(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry1, Geometry geometry2) {
        HibernateCriteriaBuilder cb = (HibernateCriteriaBuilder)criteriaBuilder;
        return JTSSpatialPredicates.eq((CriteriaBuilder)cb, geometry1, (Expression<? extends Geometry>)cb.value((Object)geometry2));
    }

    public static Predicate within(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry1, Expression<? extends Geometry> geometry2) {
        return JTSSpatialPredicates.booleanExpressionToPredicate(criteriaBuilder, (Expression<Boolean>)criteriaBuilder.function(CommonSpatialFunction.ST_WITHIN.name(), Boolean.TYPE, new Expression[]{geometry1, geometry2}));
    }

    public static Predicate within(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry1, Geometry geometry2) {
        HibernateCriteriaBuilder cb = (HibernateCriteriaBuilder)criteriaBuilder;
        return JTSSpatialPredicates.within((CriteriaBuilder)cb, geometry1, (Expression<? extends Geometry>)cb.value((Object)geometry2));
    }

    public static Predicate contains(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry1, Expression<? extends Geometry> geometry2) {
        return JTSSpatialPredicates.booleanExpressionToPredicate(criteriaBuilder, (Expression<Boolean>)criteriaBuilder.function(CommonSpatialFunction.ST_CONTAINS.name(), Boolean.TYPE, new Expression[]{geometry1, geometry2}));
    }

    public static Predicate contains(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry1, Geometry geometry2) {
        HibernateCriteriaBuilder cb = (HibernateCriteriaBuilder)criteriaBuilder;
        return JTSSpatialPredicates.contains((CriteriaBuilder)cb, geometry1, (Expression<? extends Geometry>)cb.value((Object)geometry2));
    }

    public static Predicate crosses(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry1, Expression<? extends Geometry> geometry2) {
        return JTSSpatialPredicates.booleanExpressionToPredicate(criteriaBuilder, (Expression<Boolean>)criteriaBuilder.function(CommonSpatialFunction.ST_CROSSES.name(), Boolean.TYPE, new Expression[]{geometry1, geometry2}));
    }

    public static Predicate crosses(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry1, Geometry geometry2) {
        HibernateCriteriaBuilder cb = (HibernateCriteriaBuilder)criteriaBuilder;
        return JTSSpatialPredicates.crosses((CriteriaBuilder)cb, geometry1, (Expression<? extends Geometry>)cb.value((Object)geometry2));
    }

    public static Predicate disjoint(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry1, Expression<? extends Geometry> geometry2) {
        return JTSSpatialPredicates.booleanExpressionToPredicate(criteriaBuilder, (Expression<Boolean>)criteriaBuilder.function(CommonSpatialFunction.ST_DISJOINT.name(), Boolean.TYPE, new Expression[]{geometry1, geometry2}));
    }

    public static Predicate disjoint(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry1, Geometry geometry2) {
        HibernateCriteriaBuilder cb = (HibernateCriteriaBuilder)criteriaBuilder;
        return JTSSpatialPredicates.disjoint((CriteriaBuilder)cb, geometry1, (Expression<? extends Geometry>)cb.value((Object)geometry2));
    }

    public static Predicate intersects(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry1, Expression<? extends Geometry> geometry2) {
        return JTSSpatialPredicates.booleanExpressionToPredicate(criteriaBuilder, (Expression<Boolean>)criteriaBuilder.function(CommonSpatialFunction.ST_INTERSECTS.name(), Boolean.TYPE, new Expression[]{geometry1, geometry2}));
    }

    public static Predicate intersects(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry1, Geometry geometry2) {
        HibernateCriteriaBuilder cb = (HibernateCriteriaBuilder)criteriaBuilder;
        return JTSSpatialPredicates.intersects((CriteriaBuilder)cb, geometry1, (Expression<? extends Geometry>)cb.value((Object)geometry2));
    }

    public static Predicate overlaps(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry1, Expression<? extends Geometry> geometry2) {
        return JTSSpatialPredicates.booleanExpressionToPredicate(criteriaBuilder, (Expression<Boolean>)criteriaBuilder.function(CommonSpatialFunction.ST_OVERLAPS.name(), Boolean.TYPE, new Expression[]{geometry1, geometry2}));
    }

    public static Predicate overlaps(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry1, Geometry geometry2) {
        HibernateCriteriaBuilder cb = (HibernateCriteriaBuilder)criteriaBuilder;
        return JTSSpatialPredicates.overlaps((CriteriaBuilder)cb, geometry1, (Expression<? extends Geometry>)cb.value((Object)geometry2));
    }

    public static Predicate touches(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry1, Expression<? extends Geometry> geometry2) {
        return JTSSpatialPredicates.booleanExpressionToPredicate(criteriaBuilder, (Expression<Boolean>)criteriaBuilder.function(CommonSpatialFunction.ST_TOUCHES.name(), Boolean.TYPE, new Expression[]{geometry1, geometry2}));
    }

    public static Predicate touches(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry1, Geometry geometry2) {
        HibernateCriteriaBuilder cb = (HibernateCriteriaBuilder)criteriaBuilder;
        return JTSSpatialPredicates.touches((CriteriaBuilder)cb, geometry1, (Expression<? extends Geometry>)cb.value((Object)geometry2));
    }

    public static Predicate distanceWithin(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry1, Expression<? extends Geometry> geometry2, Expression<Double> distance) {
        return JTSSpatialPredicates.booleanExpressionToPredicate(criteriaBuilder, (Expression<Boolean>)criteriaBuilder.function(SpatialFunction.dwithin.toString(), Boolean.TYPE, new Expression[]{geometry1, geometry2, distance}));
    }

    public static Predicate distanceWithin(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry1, Geometry geometry2, Expression<Double> distance) {
        HibernateCriteriaBuilder cb = (HibernateCriteriaBuilder)criteriaBuilder;
        return JTSSpatialPredicates.distanceWithin((CriteriaBuilder)cb, geometry1, (Expression<? extends Geometry>)cb.value((Object)geometry2), distance);
    }

    public static Predicate distanceWithin(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry1, Geometry geometry2, double distance) {
        HibernateCriteriaBuilder cb = (HibernateCriteriaBuilder)criteriaBuilder;
        return JTSSpatialPredicates.distanceWithin(criteriaBuilder, geometry1, (Expression<? extends Geometry>)cb.value((Object)geometry2), (Expression<Double>)cb.value((Object)distance));
    }

    public static Predicate distanceWithin(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry1, Expression<? extends Geometry> geometry2, double distance) {
        HibernateCriteriaBuilder cb = (HibernateCriteriaBuilder)criteriaBuilder;
        return JTSSpatialPredicates.distanceWithin((CriteriaBuilder)cb, geometry1, geometry2, (Expression<Double>)cb.value((Object)distance));
    }

    public static Predicate havingSRID(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry, Expression<Integer> srid) {
        return criteriaBuilder.equal(criteriaBuilder.function(SpatialFunction.srid.toString(), Integer.TYPE, new Expression[]{geometry}), srid);
    }

    public static Predicate havingSRID(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry, int srid) {
        HibernateCriteriaBuilder cb = (HibernateCriteriaBuilder)criteriaBuilder;
        return JTSSpatialPredicates.havingSRID(criteriaBuilder, geometry, (Expression<Integer>)cb.value((Object)srid));
    }

    public static Predicate isEmpty(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry) {
        return JTSSpatialPredicates.booleanExpressionToPredicate(criteriaBuilder, (Expression<Boolean>)criteriaBuilder.function(SpatialFunction.isempty.toString(), Boolean.TYPE, new Expression[]{geometry}));
    }

    public static Predicate isNotEmpty(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry) {
        return JTSSpatialPredicates.isEmpty(criteriaBuilder, geometry).not();
    }

    private static Predicate booleanExpressionToPredicate(CriteriaBuilder criteriaBuilder, Expression<Boolean> expression) {
        return criteriaBuilder.equal(expression, (Object)true);
    }
}

