/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.oracle;

import org.geolatte.geom.codec.db.oracle.ConnectionFinder;
import org.geolatte.geom.codec.db.oracle.OracleJDBCTypeFactory;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.spatial.HSMessageLogger;
import org.hibernate.spatial.KeyedSqmFunctionDescriptors;
import org.hibernate.spatial.contributor.ContributorImplementor;
import org.hibernate.spatial.dialect.oracle.OracleSDOFunctionDescriptors;
import org.hibernate.spatial.dialect.oracle.OracleSQLMMFunctionDescriptors;
import org.hibernate.spatial.dialect.oracle.SDOGeometryType;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class OracleDialectContributor
implements ContributorImplementor {
    private final ServiceRegistry serviceRegistry;
    private final boolean useSTGeometry;

    public OracleDialectContributor(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
        ConfigurationService cfgService = (ConfigurationService)this.getServiceRegistry().getService(ConfigurationService.class);
        this.useSTGeometry = (Boolean)cfgService.getSetting("hibernate.spatial.oracle_ogc_strict", StandardConverters.BOOLEAN, (Object)false);
    }

    @Override
    public void contributeJdbcTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        HSMessageLogger.SPATIAL_MSG_LOGGER.typeContributions(this.getClass().getCanonicalName());
        ConfigurationService cfgService = (ConfigurationService)this.getServiceRegistry().getService(ConfigurationService.class);
        StrategySelector strategySelector = (StrategySelector)this.getServiceRegistry().getService(StrategySelector.class);
        ConnectionFinder connectionFinder = (ConnectionFinder)strategySelector.resolveStrategy(ConnectionFinder.class, cfgService.getSetting("hibernate.spatial.connection_finder", String.class, (Object)"org.geolatte.geom.codec.db.oracle.DefaultConnectionFinder"));
        HSMessageLogger.SPATIAL_MSG_LOGGER.connectionFinder(connectionFinder.getClass().getCanonicalName());
        SDOGeometryType sdoGeometryType = new SDOGeometryType(new OracleJDBCTypeFactory(connectionFinder), this.useSTGeometry);
        typeContributions.contributeJdbcType((JdbcType)sdoGeometryType);
    }

    @Override
    public void contributeFunctions(FunctionContributions functionContributions) {
        HSMessageLogger.SPATIAL_MSG_LOGGER.functionContributions(this.getClass().getCanonicalName());
        KeyedSqmFunctionDescriptors functionDescriptors = this.useSTGeometry ? new OracleSQLMMFunctionDescriptors(functionContributions) : new OracleSDOFunctionDescriptors(functionContributions);
        SqmFunctionRegistry functionRegistry = functionContributions.getFunctionRegistry();
        functionDescriptors.asMap().forEach((key, funcDescr) -> {
            functionRegistry.register(key.getName(), funcDescr);
            key.getAltName().ifPresent(altName -> functionRegistry.register(altName, funcDescr));
        });
    }

    @Override
    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }
}

