/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.orm.domain.gambit;

import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityResult;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Id;
import jakarta.persistence.SqlResultSetMapping;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.net.URL;
import java.sql.Clob;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Date;
import org.hibernate.annotations.JdbcTypeCode;
import org.hibernate.testing.orm.domain.gambit.MutableValue;

@SqlResultSetMapping(name="entity-of-basics-implicit", entities={@EntityResult(entityClass=EntityOfBasics.class)})
@Entity
public class EntityOfBasics {
    private Integer id;
    private Boolean theBoolean = false;
    private Boolean theNumericBoolean = false;
    private Boolean theStringBoolean = false;
    private String theString;
    private Integer theInteger;
    private int theInt;
    private double theDouble;
    private URL theUrl;
    private Clob theClob;
    private Date theDate;
    private Date theTime;
    private Date theTimestamp;
    private Instant theInstant;
    private Gender gender;
    private Gender convertedGender;
    private Gender ordinalGender;
    private Duration theDuration;
    private LocalDateTime theLocalDateTime;
    private LocalDate theLocalDate;
    private LocalTime theLocalTime;
    private ZonedDateTime theZonedDateTime;
    private OffsetDateTime theOffsetDateTime;
    private MutableValue mutableValue;

    public EntityOfBasics() {
    }

    public EntityOfBasics(Integer id) {
        this.id = id;
    }

    @Id
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getTheString() {
        return this.theString;
    }

    public void setTheString(String theString) {
        this.theString = theString;
    }

    public Integer getTheInteger() {
        return this.theInteger;
    }

    public void setTheInteger(Integer theInteger) {
        this.theInteger = theInteger;
    }

    public int getTheInt() {
        return this.theInt;
    }

    public void setTheInt(int theInt) {
        this.theInt = theInt;
    }

    public double getTheDouble() {
        return this.theDouble;
    }

    public void setTheDouble(double theDouble) {
        this.theDouble = theDouble;
    }

    public URL getTheUrl() {
        return this.theUrl;
    }

    public void setTheUrl(URL theUrl) {
        this.theUrl = theUrl;
    }

    public Clob getTheClob() {
        return this.theClob;
    }

    public void setTheClob(Clob theClob) {
        this.theClob = theClob;
    }

    @Enumerated(value=EnumType.STRING)
    public Gender getGender() {
        return this.gender;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
    }

    @Convert(converter=GenderConverter.class)
    @Column(name="converted_gender", length=1)
    @JdbcTypeCode(value=1)
    public Gender getConvertedGender() {
        return this.convertedGender;
    }

    public void setConvertedGender(Gender convertedGender) {
        this.convertedGender = convertedGender;
    }

    @Column(name="ordinal_gender")
    public Gender getOrdinalGender() {
        return this.ordinalGender;
    }

    public void setOrdinalGender(Gender ordinalGender) {
        this.ordinalGender = ordinalGender;
    }

    @Temporal(value=TemporalType.DATE)
    public Date getTheDate() {
        return this.theDate;
    }

    public void setTheDate(Date theDate) {
        this.theDate = theDate;
    }

    @Temporal(value=TemporalType.TIME)
    public Date getTheTime() {
        return this.theTime;
    }

    public void setTheTime(Date theTime) {
        this.theTime = theTime;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getTheTimestamp() {
        return this.theTimestamp;
    }

    public void setTheTimestamp(Date theTimestamp) {
        this.theTimestamp = theTimestamp;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    public Instant getTheInstant() {
        return this.theInstant;
    }

    public void setTheInstant(Instant theInstant) {
        this.theInstant = theInstant;
    }

    public LocalDateTime getTheLocalDateTime() {
        return this.theLocalDateTime;
    }

    public void setTheLocalDateTime(LocalDateTime theLocalDateTime) {
        this.theLocalDateTime = theLocalDateTime;
    }

    public LocalDate getTheLocalDate() {
        return this.theLocalDate;
    }

    public void setTheLocalDate(LocalDate theLocalDate) {
        this.theLocalDate = theLocalDate;
    }

    public LocalTime getTheLocalTime() {
        return this.theLocalTime;
    }

    public void setTheLocalTime(LocalTime theLocalTime) {
        this.theLocalTime = theLocalTime;
    }

    public OffsetDateTime getTheOffsetDateTime() {
        return this.theOffsetDateTime;
    }

    public void setTheOffsetDateTime(OffsetDateTime theOffsetDateTime) {
        this.theOffsetDateTime = theOffsetDateTime;
    }

    public ZonedDateTime getTheZonedDateTime() {
        return this.theZonedDateTime;
    }

    public void setTheZonedDateTime(ZonedDateTime theZonedDateTime) {
        this.theZonedDateTime = theZonedDateTime;
    }

    public Duration getTheDuration() {
        return this.theDuration;
    }

    public void setTheDuration(Duration theDuration) {
        this.theDuration = theDuration;
    }

    public Boolean isTheBoolean() {
        return this.theBoolean;
    }

    public void setTheBoolean(Boolean theBoolean) {
        this.theBoolean = theBoolean;
    }

    @JdbcTypeCode(value=4)
    public Boolean isTheNumericBoolean() {
        return this.theNumericBoolean;
    }

    public void setTheNumericBoolean(Boolean theNumericBoolean) {
        this.theNumericBoolean = theNumericBoolean;
    }

    @JdbcTypeCode(value=1)
    public Boolean isTheStringBoolean() {
        return this.theStringBoolean;
    }

    public void setTheStringBoolean(Boolean theStringBoolean) {
        this.theStringBoolean = theStringBoolean;
    }

    @Convert(converter=MutableValueConverter.class)
    public MutableValue getMutableValue() {
        return this.mutableValue;
    }

    public void setMutableValue(MutableValue mutableValue) {
        this.mutableValue = mutableValue;
    }

    public static class GenderConverter
    implements AttributeConverter<Gender, Character> {
        public Character convertToDatabaseColumn(Gender attribute) {
            if (attribute == null) {
                return null;
            }
            if (attribute == Gender.OTHER) {
                return Character.valueOf('O');
            }
            if (attribute == Gender.MALE) {
                return Character.valueOf('M');
            }
            return Character.valueOf('F');
        }

        public Gender convertToEntityAttribute(Character dbData) {
            if (dbData == null) {
                return null;
            }
            if ('O' == dbData.charValue()) {
                return Gender.OTHER;
            }
            if ('M' == dbData.charValue()) {
                return Gender.MALE;
            }
            return Gender.FEMALE;
        }
    }

    public static class MutableValueConverter
    implements AttributeConverter<MutableValue, String> {
        public String convertToDatabaseColumn(MutableValue attribute) {
            return attribute == null ? null : attribute.getState();
        }

        public MutableValue convertToEntityAttribute(String dbData) {
            return dbData == null ? null : new MutableValue(dbData);
        }
    }

    public static enum Gender {
        MALE,
        FEMALE,
        OTHER;

    }
}

