/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.orm.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.Collectors;
import org.hibernate.testing.jdbc.ConnectionProviderDelegate;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.internal.util.MockUtil;
import org.mockito.stubbing.Answer;

public class PreparedStatementSpyConnectionProvider
extends ConnectionProviderDelegate {
    private static final MockSettings MOCK_SETTINGS = Mockito.withSettings().stubOnly().defaultAnswer((Answer)Answers.CALLS_REAL_METHODS);
    private static final MockSettings VERIFIABLE_MOCK_SETTINGS = Mockito.withSettings().defaultAnswer((Answer)Answers.CALLS_REAL_METHODS);
    private static final Queue<Object> MOCKS = new LinkedBlockingQueue<Object>();
    private final Map<PreparedStatement, String> preparedStatementMap = new LinkedHashMap<PreparedStatement, String>();
    private final List<String> executeStatements = new ArrayList<String>(4);
    private final List<String> executeUpdateStatements = new ArrayList<String>(4);
    private final List<Connection> acquiredConnections = new ArrayList<Connection>(4);
    private final List<Connection> releasedConnections = new ArrayList<Connection>(4);
    private final MockSettings settingsForStatements;
    private final MockSettings settingsForConnections;

    @Deprecated
    public PreparedStatementSpyConnectionProvider() {
        this(false, false, false);
    }

    public PreparedStatementSpyConnectionProvider(boolean allowMockVerificationOnStatements, boolean allowMockVerificationOnConnections) {
        this(allowMockVerificationOnStatements, allowMockVerificationOnConnections, false);
    }

    public PreparedStatementSpyConnectionProvider(boolean allowMockVerificationOnStatements, boolean allowMockVerificationOnConnections, boolean forceSupportsAggressiveRelease) {
        super(forceSupportsAggressiveRelease);
        this.settingsForStatements = allowMockVerificationOnStatements ? VERIFIABLE_MOCK_SETTINGS : MOCK_SETTINGS;
        this.settingsForConnections = allowMockVerificationOnConnections ? VERIFIABLE_MOCK_SETTINGS : MOCK_SETTINGS;
    }

    protected Connection actualConnection() throws SQLException {
        return super.getConnection();
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection connection = this.instrumentConnection(this.actualConnection());
        MOCKS.add(connection);
        this.acquiredConnections.add(connection);
        return connection;
    }

    @Override
    public void closeConnection(Connection conn) throws SQLException {
        this.acquiredConnections.remove(conn);
        this.releasedConnections.add(conn);
        super.closeConnection((Connection)MockUtil.getMockSettings((Object)conn).getSpiedInstance());
    }

    @Override
    public void stop() {
        this.clear();
        super.stop();
    }

    private Connection instrumentConnection(Connection connection) {
        if (MockUtil.isMock((Object)connection)) {
            return connection;
        }
        Connection connectionSpy = PreparedStatementSpyConnectionProvider.spy(connection, this.settingsForConnections);
        try {
            ((Connection)Mockito.doAnswer(invocation -> {
                PreparedStatement statement = (PreparedStatement)invocation.callRealMethod();
                PreparedStatement statementSpy = PreparedStatementSpyConnectionProvider.spy(statement, this.settingsForStatements);
                String sql = (String)invocation.getArguments()[0];
                this.preparedStatementMap.put(statementSpy, sql);
                return statementSpy;
            }).when((Object)connectionSpy)).prepareStatement(ArgumentMatchers.anyString());
            ((Connection)Mockito.doAnswer(invocation -> {
                Statement statement = (Statement)invocation.callRealMethod();
                Statement statementSpy = PreparedStatementSpyConnectionProvider.spy(statement, this.settingsForStatements);
                ((Statement)Mockito.doAnswer(statementInvocation -> {
                    String sql = (String)statementInvocation.getArguments()[0];
                    this.executeStatements.add(sql);
                    return statementInvocation.callRealMethod();
                }).when((Object)statementSpy)).execute(ArgumentMatchers.anyString());
                ((Statement)Mockito.doAnswer(statementInvocation -> {
                    String sql = (String)statementInvocation.getArguments()[0];
                    this.executeUpdateStatements.add(sql);
                    return statementInvocation.callRealMethod();
                }).when((Object)statementSpy)).executeUpdate(ArgumentMatchers.anyString());
                return statementSpy;
            }).when((Object)connectionSpy)).createStatement();
        }
        catch (SQLException e) {
            throw new IllegalArgumentException(e);
        }
        return connectionSpy;
    }

    private static <T> T spy(T subject, MockSettings mockSettings) {
        return (T)Mockito.mock(subject.getClass(), (MockSettings)mockSettings.spiedInstance(subject));
    }

    public void clear() {
        this.acquiredConnections.clear();
        this.releasedConnections.clear();
        this.preparedStatementMap.keySet().forEach(xva$0 -> Mockito.reset((Object[])new PreparedStatement[]{xva$0}));
        this.preparedStatementMap.clear();
        this.executeStatements.clear();
        this.executeUpdateStatements.clear();
    }

    public PreparedStatement getPreparedStatement(String sql) {
        List<PreparedStatement> preparedStatements = this.getPreparedStatements(sql);
        if (preparedStatements.isEmpty()) {
            throw new IllegalArgumentException("There is no PreparedStatement for this SQL statement: " + sql);
        }
        if (preparedStatements.size() > 1) {
            throw new IllegalArgumentException("There are " + preparedStatements.size() + " PreparedStatements for this SQL statement: " + sql);
        }
        return preparedStatements.get(0);
    }

    public List<PreparedStatement> getPreparedStatements(String sql) {
        return this.preparedStatementMap.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(sql)).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public List<PreparedStatement> getPreparedStatements() {
        return new ArrayList<PreparedStatement>(this.preparedStatementMap.keySet());
    }

    public List<String> getPreparedSQLStatements() {
        return new ArrayList<String>(this.preparedStatementMap.values());
    }

    public List<String> getExecuteStatements() {
        return this.executeStatements;
    }

    public List<String> getExecuteUpdateStatements() {
        return this.executeUpdateStatements;
    }

    public List<Connection> getAcquiredConnections() {
        return this.acquiredConnections;
    }

    public List<Connection> getReleasedConnections() {
        return this.releasedConnections;
    }
}

