/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.cleaner;

import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hibernate.testing.cleaner.DatabaseCleaner;

public class PostgreSQLDatabaseCleaner
implements DatabaseCleaner {
    private static final Logger LOG = Logger.getLogger(PostgreSQLDatabaseCleaner.class.getName());
    private final List<String> ignoredTables = new ArrayList<String>();
    private final Map<String, String> truncateSqlPerSchema = new HashMap<String, String>();

    @Override
    public boolean isApplicable(Connection connection) {
        try {
            return connection.getMetaData().getDatabaseProductName().startsWith("PostgreSQL") && this.isPostgresql(connection);
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not resolve the database metadata!", e);
        }
    }

    @Override
    public void addIgnoredTable(String tableName) {
        this.ignoredTables.add(tableName.toLowerCase());
    }

    @Override
    public void clearAllSchemas(Connection connection) {
        this.truncateSqlPerSchema.clear();
        this.clearSchema0(connection, statement -> {
            try {
                return statement.executeQuery("SELECT SCHEMA_NAME FROM INFORMATION_SCHEMA.SCHEMATA WHERE SCHEMA_NAME <> 'information_schema' AND SCHEMA_NAME <> 'sys' AND SCHEMA_NAME <> 'public' AND SCHEMA_NAME NOT LIKE 'pg_%'");
            }
            catch (SQLException sqlException) {
                throw new RuntimeException(sqlException);
            }
        });
    }

    @Override
    public void clearSchema(Connection connection, String schemaName) {
        this.truncateSqlPerSchema.remove(schemaName);
        this.clearSchema0(connection, statement -> {
            try {
                return statement.executeQuery("SELECT SCHEMA_NAME FROM INFORMATION_SCHEMA.SCHEMATA WHERE SCHEMA_NAME = '" + schemaName + "'");
            }
            catch (SQLException sqlException) {
                throw new RuntimeException(sqlException);
            }
        });
    }

    private void clearSchema0(Connection c, Function<Statement, ResultSet> schemasProvider) {
        try (Statement s = c.createStatement();){
            ResultSet rs;
            ArrayList<CallSite> sqls = new ArrayList<CallSite>();
            String user = c.getMetaData().getUserName();
            LOG.log(Level.FINEST, "Collect schema objects: START");
            HashMap<String, List> schemaExtensions = new HashMap<String, List>();
            try (Statement s2 = c.createStatement();){
                rs = s2.executeQuery("SELECT ns.nspname, 'CREATE EXTENSION ' || e.extname || ' SCHEMA \"' || ns.nspname || '\"' FROM pg_extension e JOIN pg_catalog.pg_namespace ns ON e.extnamespace = ns.oid WHERE e.extname <> 'plpgsql'");
                while (rs.next()) {
                    schemaExtensions.computeIfAbsent(rs.getString(1), k -> new ArrayList()).add(rs.getString(2));
                }
            }
            rs = schemasProvider.apply(s);
            while (rs.next()) {
                String schema = rs.getString(1);
                sqls.add((CallSite)((Object)("DROP SCHEMA \"" + schema + "\" CASCADE")));
                sqls.add((CallSite)((Object)("CREATE SCHEMA \"" + schema + "\"")));
                sqls.add((CallSite)((Object)("GRANT ALL ON SCHEMA \"" + schema + "\" TO \"" + user + "\"")));
                List list = (List)schemaExtensions.get(schema);
                if (list == null) continue;
                sqls.addAll(list);
            }
            LOG.log(Level.FINEST, "Collect schema objects: END");
            LOG.log(Level.FINEST, "Dropping schema objects: START");
            for (String string : sqls) {
                s.execute(string);
            }
            LOG.log(Level.FINEST, "Dropping schema objects: END");
            LOG.log(Level.FINEST, "Committing: START");
            c.commit();
            LOG.log(Level.FINEST, "Committing: END");
        }
        catch (SQLException e) {
            try {
                c.rollback();
            }
            catch (SQLException e1) {
                e.addSuppressed(e1);
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public void clearAllData(Connection connection) {
        this.clearData0(connection, null, statement -> {
            try {
                return statement.executeQuery("SELECT TABLE_SCHEMA, TABLE_NAME FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA <> 'information_schema' AND SCHEMA_NAME NOT LIKE 'pg_%'");
            }
            catch (SQLException sqlException) {
                throw new RuntimeException(sqlException);
            }
        });
    }

    @Override
    public void clearData(Connection connection, String schemaName) {
        this.clearData0(connection, schemaName, statement -> {
            try {
                return statement.executeQuery("SELECT TABLE_SCHEMA, TABLE_NAME FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = '" + schemaName + "'");
            }
            catch (SQLException sqlException) {
                throw new RuntimeException(sqlException);
            }
        });
    }

    private void clearData0(Connection connection, String schemaName, Function<Statement, ResultSet> tablesProvider) {
        try (Statement s = connection.createStatement();){
            LOG.log(Level.FINEST, "Deleting data: START");
            String truncateSql = this.truncateSqlPerSchema.get(schemaName);
            if (truncateSql == null) {
                StringBuilder sb = new StringBuilder();
                sb.append("TRUNCATE TABLE ");
                ResultSet rs = tablesProvider.apply(s);
                while (rs.next()) {
                    String tableSchema = rs.getString(1);
                    String tableName = rs.getString(2);
                    if (this.ignoredTables.contains(tableName)) continue;
                    sb.append('\"');
                    sb.append(tableSchema);
                    sb.append('\"');
                    sb.append('.');
                    sb.append('\"');
                    sb.append(tableName);
                    sb.append('\"');
                    sb.append(',');
                }
                sb.setCharAt(sb.length() - 1, ' ');
                sb.append("RESTART IDENTITY CASCADE");
                truncateSql = sb.toString();
                this.truncateSqlPerSchema.put(schemaName, truncateSql);
            }
            s.execute(truncateSql);
            LOG.log(Level.FINEST, "Deleting data: END");
            LOG.log(Level.FINEST, "Committing: START");
            connection.commit();
            LOG.log(Level.FINEST, "Committing: END");
        }
        catch (SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException e1) {
                e.addSuppressed(e1);
            }
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isPostgresql(Connection connection) {
        try (Statement stmt = connection.createStatement();){
            ResultSet rs = stmt.executeQuery("select version() ");
            if (!rs.next()) return false;
            String version = rs.getString(1);
            boolean bl = version.contains("PostgreSQL");
            return bl;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

