/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.orm.junit;

import java.util.Locale;
import java.util.function.Consumer;
import org.hibernate.UnknownEntityTypeException;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.RootClass;

public interface DomainModelScope {
    public MetadataImplementor getDomainModel();

    default public void visitHierarchies(Consumer<RootClass> action) {
        this.getDomainModel().getEntityBindings().forEach(persistentClass -> {
            if (persistentClass instanceof RootClass) {
                action.accept((RootClass)persistentClass);
            }
        });
    }

    default public void withHierarchy(Class rootType, Consumer<RootClass> action) {
        this.withHierarchy(rootType.getName(), action);
    }

    default public void withHierarchy(String rootTypeName, Consumer<RootClass> action) {
        PersistentClass entityBinding = this.getDomainModel().getEntityBinding(rootTypeName);
        if (entityBinding == null) {
            throw new UnknownEntityTypeException(String.format(Locale.ROOT, "Could not resolve `%s` as an entity type", rootTypeName));
        }
        action.accept(entityBinding.getRootClass());
    }

    default public PersistentClass getEntityBinding(Class<?> theEntityClass) {
        if (!1.$assertionsDisabled && theEntityClass == null) {
            throw new AssertionError();
        }
        return this.getDomainModel().getEntityBinding(theEntityClass.getName());
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

