/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.orm.junit;

import org.hibernate.boot.model.TruthValue;
import org.hibernate.community.dialect.FirebirdDialect;
import org.hibernate.dialect.AbstractHANADialect;
import org.hibernate.dialect.CockroachDialect;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.DerbyDialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DialectDelegateWrapper;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.dialect.HSQLDialect;
import org.hibernate.dialect.MariaDBDialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.NationalizationSupport;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.dialect.SpannerDialect;
import org.hibernate.dialect.SybaseDialect;
import org.hibernate.dialect.SybaseDriverKind;
import org.hibernate.dialect.TiDBDialect;
import org.hibernate.dialect.TimeZoneSupport;
import org.hibernate.query.sqm.FetchClauseType;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StringBuilderSqlAppender;
import org.hibernate.testing.orm.junit.DialectFeatureCheck;
import org.hibernate.tool.schema.extract.spi.ColumnTypeInformation;

public abstract class DialectFeatureChecks {

    public static class SupportsCaseInsensitiveLike
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsCaseInsensitiveLike();
        }
    }

    public static class SupportsStructuralArrays
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.getPreferredSqlTypeCodeForArray() != -3;
        }
    }

    public static class SupportsCommentOn
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsCommentOn();
        }
    }

    public static class IsJtds
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect instanceof SybaseDialect && ((SybaseDialect)dialect).getDriverKind() == SybaseDriverKind.JTDS;
        }
    }

    public static class SupportsJsonComponentUpdate
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            try {
                dialect.getAggregateSupport().requiresAggregateCustomWriteExpressionRenderer(3001);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    public static class SupportsJsonAggregate
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            try {
                return dialect.getAggregateSupport() != null && dialect.getAggregateSupport().aggregateComponentCustomReadExpression("", "", "", "", new ColumnTypeInformation(){

                    public TruthValue getNullable() {
                        return TruthValue.UNKNOWN;
                    }

                    public int getTypeCode() {
                        return 3001;
                    }

                    public String getTypeName() {
                        return null;
                    }

                    public int getColumnSize() {
                        return 0;
                    }

                    public int getDecimalDigits() {
                        return 0;
                    }
                }, new ColumnTypeInformation(){

                    public TruthValue getNullable() {
                        return TruthValue.UNKNOWN;
                    }

                    public int getTypeCode() {
                        return 12;
                    }

                    public String getTypeName() {
                        return "varchar";
                    }

                    public int getColumnSize() {
                        return 0;
                    }

                    public int getDecimalDigits() {
                        return 0;
                    }
                }) != null;
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    public static class SupportsStructAggregate
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            try {
                return dialect.getAggregateSupport() != null && dialect.getAggregateSupport().aggregateComponentCustomReadExpression("", "", "", "", new ColumnTypeInformation(){

                    public TruthValue getNullable() {
                        return TruthValue.UNKNOWN;
                    }

                    public int getTypeCode() {
                        return 2002;
                    }

                    public String getTypeName() {
                        return null;
                    }

                    public int getColumnSize() {
                        return 0;
                    }

                    public int getDecimalDigits() {
                        return 0;
                    }
                }, new ColumnTypeInformation(){

                    public TruthValue getNullable() {
                        return TruthValue.UNKNOWN;
                    }

                    public int getTypeCode() {
                        return 12;
                    }

                    public String getTypeName() {
                        return "varchar";
                    }

                    public int getColumnSize() {
                        return 0;
                    }

                    public int getDecimalDigits() {
                        return 0;
                    }
                }) != null;
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    public static class SupportsTruncateTable
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return (dialect = DialectDelegateWrapper.extractRealDialect((Dialect)dialect)) instanceof MySQLDialect || dialect instanceof H2Dialect || dialect instanceof SQLServerDialect || dialect instanceof PostgreSQLDialect || dialect instanceof DB2Dialect || dialect instanceof OracleDialect || dialect instanceof SybaseDialect || dialect instanceof DerbyDialect || dialect instanceof HSQLDialect;
        }
    }

    public static class SupportsRecursiveCtes
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsRecursiveCTE();
        }
    }

    public static class SupportsMedian
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return !((dialect = DialectDelegateWrapper.extractRealDialect((Dialect)dialect)) instanceof MySQLDialect) && !(dialect instanceof SybaseDialect) && !(dialect instanceof DerbyDialect) && !(dialect instanceof FirebirdDialect) && (!(dialect instanceof DB2Dialect) || !((DB2Dialect)dialect).getDB2Version().isBefore(11)) || dialect instanceof MariaDBDialect;
        }
    }

    public static class SupportsFullJoin
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return !((dialect = DialectDelegateWrapper.extractRealDialect((Dialect)dialect)) instanceof H2Dialect) && !(dialect instanceof MySQLDialect) && !(dialect instanceof SybaseDialect) && !(dialect instanceof DerbyDialect);
        }
    }

    public static class SupportsSubqueryInOnClause
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return !((dialect = DialectDelegateWrapper.extractRealDialect((Dialect)dialect)) instanceof TiDBDialect);
        }
    }

    public static class SupportsFilterClause
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            dialect = DialectDelegateWrapper.extractRealDialect((Dialect)dialect);
            return dialect instanceof PostgreSQLDialect;
        }
    }

    public static class SupportsWindowFunctions
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return (dialect = DialectDelegateWrapper.extractRealDialect((Dialect)dialect)).supportsWindowFunctions() && !(dialect instanceof DerbyDialect);
        }
    }

    public static class SupportsHypotheticalSetFunctions
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return (dialect = DialectDelegateWrapper.extractRealDialect((Dialect)dialect)) instanceof H2Dialect || dialect instanceof PostgreSQLDialect || dialect instanceof AbstractHANADialect || dialect instanceof CockroachDialect || dialect instanceof DB2Dialect && ((DB2Dialect)dialect).getDB2Version().isSameOrAfter(11) || dialect instanceof OracleDialect || dialect instanceof SpannerDialect || dialect instanceof SQLServerDialect;
        }
    }

    public static class SupportsInverseDistributionFunctions
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return (dialect = DialectDelegateWrapper.extractRealDialect((Dialect)dialect)) instanceof H2Dialect || dialect instanceof PostgreSQLDialect || dialect instanceof AbstractHANADialect || dialect instanceof CockroachDialect || dialect instanceof DB2Dialect && ((DB2Dialect)dialect).getDB2Version().isSameOrAfter(11) || dialect instanceof OracleDialect || dialect instanceof SpannerDialect || dialect instanceof SQLServerDialect;
        }
    }

    public static class SupportsStringAggregation
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return (dialect = DialectDelegateWrapper.extractRealDialect((Dialect)dialect)) instanceof H2Dialect || dialect instanceof HSQLDialect || dialect instanceof MySQLDialect || dialect instanceof PostgreSQLDialect || dialect instanceof AbstractHANADialect || dialect instanceof CockroachDialect || dialect instanceof DB2Dialect || dialect instanceof OracleDialect || dialect instanceof SpannerDialect || dialect instanceof SQLServerDialect;
        }
    }

    public static class ForceLobAsLastValue
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.forceLobAsLastValue();
        }
    }

    public static class UsesStandardCurrentTimestampFunction
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsStandardCurrentTimestampFunction();
        }
    }

    public static class CurrentTimestampHasMicrosecondPrecision
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return !dialect.currentTimestamp().contains("6");
        }
    }

    public static class SupportNoWait
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsNoWait();
        }
    }

    public static class SupportsOrderByInCorrelatedSubquery
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return (dialect = DialectDelegateWrapper.extractRealDialect((Dialect)dialect)).supportsOrderByInSubquery() && !(dialect instanceof AbstractHANADialect);
        }
    }

    public static class SupportsOrderByInSubquery
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsOrderByInSubquery();
        }
    }

    public static class SupportsTruncateThroughCast
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            try {
                dialect.appendDatetimeFormat((SqlAppender)new StringBuilderSqlAppender(), "");
                return true;
            }
            catch (Exception ex) {
                return false;
            }
        }
    }

    public static class SupportsFormat
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            try {
                dialect.appendDatetimeFormat((SqlAppender)new StringBuilderSqlAppender(), "");
                return true;
            }
            catch (Exception ex) {
                return false;
            }
        }
    }

    public static class SupportsValuesListForInsert
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsValuesListForInsert();
        }
    }

    public static class SupportsTemporaryTable
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsTemporaryTables();
        }
    }

    public static class SupportsRepeat
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return !((dialect = DialectDelegateWrapper.extractRealDialect((Dialect)dialect)) instanceof DerbyDialect);
        }
    }

    public static class SupportsReplace
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return !((dialect = DialectDelegateWrapper.extractRealDialect((Dialect)dialect)) instanceof DerbyDialect);
        }
    }

    public static class SupportsCharCodeConversion
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return !((dialect = DialectDelegateWrapper.extractRealDialect((Dialect)dialect)) instanceof DerbyDialect);
        }
    }

    public static class SupportsUnion
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsUnionAll();
        }
    }

    public static class SupportsWithTies
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsFetchClause(FetchClauseType.ROWS_WITH_TIES) || dialect.supportsWindowFunctions();
        }
    }

    public static class SupportsOffsetInSubquery
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsOffsetInSubquery();
        }
    }

    public static class SupportsTimezoneTypes
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.getTimeZoneSupport() == TimeZoneSupport.NATIVE;
        }
    }

    public static class SupportsGroupByGroupingSets
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return (dialect = DialectDelegateWrapper.extractRealDialect((Dialect)dialect)) instanceof DB2Dialect || dialect instanceof OracleDialect || dialect instanceof PostgreSQLDialect || dialect instanceof SQLServerDialect;
        }
    }

    public static class SupportsGroupByRollup
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return (dialect = DialectDelegateWrapper.extractRealDialect((Dialect)dialect)) instanceof DB2Dialect || dialect instanceof OracleDialect || dialect instanceof PostgreSQLDialect || dialect instanceof SQLServerDialect || dialect instanceof DerbyDialect || dialect instanceof MySQLDialect && !(dialect instanceof TiDBDialect) || dialect instanceof MariaDBDialect;
        }
    }

    public static class SupportsPadWithChar
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return !((dialect = DialectDelegateWrapper.extractRealDialect((Dialect)dialect)) instanceof DerbyDialect);
        }
    }

    public static class SupportNullPrecedence
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsNullPrecedence();
        }
    }

    public static class SupportDropConstraints
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.dropConstraints();
        }
    }

    public static class SupportPartitionBy
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsPartitionBy();
        }
    }

    public static class SupportFollowOnLocking
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.useFollowOnLocking(null, null);
        }
    }

    public static class SupportCatalogCreation
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.canCreateCatalog();
        }
    }

    public static class SupportSchemaCreation
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.canCreateSchema();
        }
    }

    public static class DoubleQuoteQuoting
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return '\"' == dialect.openQuote() && '\"' == dialect.closeQuote();
        }
    }

    public static class SupportsSkipLocked
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsSkipLocked();
        }
    }

    public static class SupportsLockTimeouts
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsLockTimeouts();
        }
    }

    public static class SupportsLobValueChangePropogation
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsLobValueChangePropagation();
        }
    }

    public static class SupportsExistsInSelectCheck
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsExistsInSelect();
        }
    }

    public static class DoesRepeatableReadCauseReadersToBlockWritersCheck
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.doesRepeatableReadCauseReadersToBlockWriters();
        }
    }

    public static class DoesReadCommittedCauseWritersToBlockReadersCheck
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.doesReadCommittedCauseWritersToBlockReaders();
        }
    }

    public static class SupportsJdbcDriverProxying
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return !((dialect = DialectDelegateWrapper.extractRealDialect((Dialect)dialect)) instanceof DB2Dialect) && !(dialect instanceof DerbyDialect) && !(dialect instanceof FirebirdDialect);
        }
    }

    public static class SupportsRowValueConstructorSyntaxCheck
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return (dialect = DialectDelegateWrapper.extractRealDialect((Dialect)dialect)) instanceof AbstractHANADialect || dialect instanceof CockroachDialect || dialect instanceof MySQLDialect || dialect instanceof PostgreSQLDialect;
        }
    }

    public static class HasSelfReferentialForeignKeyBugCheck
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.hasSelfReferentialForeignKeyBug();
        }
    }

    public static class SupportsParametersInInsertSelectCheck
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsParametersInInsertSelect();
        }
    }

    public static class SupportLimitAndOffsetCheck
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.getLimitHandler().supportsLimit() && dialect.getLimitHandler().supportsLimitOffset();
        }
    }

    public static class SupportLimitCheck
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.getLimitHandler().supportsLimit();
        }
    }

    public static class SupportsSubqueryAsLeftHandSideInPredicate
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsSubselectAsInPredicateLHS();
        }
    }

    public static class SupportsUnboundedLobLocatorMaterializationCheck
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsExpectedLobUsagePattern() && dialect.supportsUnboundedLobLocatorMaterialization();
        }
    }

    public static class SupportsCircularCascadeDeleteCheck
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsCircularCascadeDeleteConstraints();
        }
    }

    public static class SupportsCascadeDeleteCheck
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsCascadeDelete();
        }
    }

    public static class SupportsResultSetPositioningOnForwardOnlyCursorCheck
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsResultSetPositionQueryMethodsOnForwardOnlyCursor();
        }
    }

    public static class SupportsNoColumnInsert
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsNoColumnsInsert();
        }
    }

    public static class SupportsColumnCheck
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsColumnCheck();
        }
    }

    public static class SupportsIdentityColumns
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.getIdentityColumnSupport().supportsIdentityColumns();
        }
    }

    public static class UsesInputStreamToInsertBlob
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.useInputStreamToInsertBlob();
        }
    }

    public static class SupportsNationalizedDataTypes
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.getNationalizationSupport() == NationalizationSupport.EXPLICIT;
        }
    }

    public static class SupportsNationalizedData
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.getNationalizationSupport() != NationalizationSupport.UNSUPPORTED;
        }
    }

    public static class SupportsExpectedLobUsagePattern
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.supportsExpectedLobUsagePattern();
        }
    }

    public static class SupportsSequences
    implements DialectFeatureCheck {
        @Override
        public boolean apply(Dialect dialect) {
            return dialect.getSequenceSupport().supportsSequences();
        }
    }
}

