/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.cache;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.hibernate.Internal;
import org.hibernate.cache.spi.support.DomainDataStorageAccess;
import org.hibernate.engine.spi.SharedSessionContractImplementor;

public class MapStorageAccessImpl
implements DomainDataStorageAccess {
    private ConcurrentMap data;

    @Internal
    public Object getFromData(Object key) {
        if (this.data == null) {
            return null;
        }
        return this.data.get(key);
    }

    public boolean contains(Object key) {
        return this.data != null && this.data.containsKey(key);
    }

    public Object getFromCache(Object key, SharedSessionContractImplementor session) {
        return this.getFromData(key);
    }

    public void putIntoCache(Object key, Object value, SharedSessionContractImplementor session) {
        this.getOrMakeDataMap().put(key, value);
    }

    protected ConcurrentMap getOrMakeDataMap() {
        if (this.data == null) {
            this.data = new ConcurrentHashMap();
        }
        return this.data;
    }

    public void removeFromCache(Object key, SharedSessionContractImplementor session) {
        if (this.data == null) {
            return;
        }
        this.data.remove(key);
    }

    public void clearCache(SharedSessionContractImplementor session) {
        if (this.data == null) {
            return;
        }
        this.data.clear();
    }

    public void evictData() {
        if (this.data != null) {
            this.data.clear();
        }
    }

    public void evictData(Object key) {
        if (this.data != null) {
            this.data.remove(key);
        }
    }

    public void release() {
        if (this.data != null) {
            this.data.clear();
            this.data = null;
        }
    }
}

