/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.orm.domain.gambit;

import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityResult;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Id;
import jakarta.persistence.SqlResultSetMapping;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.net.URL;
import java.sql.Clob;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.UUID;
import org.hibernate.annotations.JdbcTypeCode;
import org.hibernate.testing.orm.domain.gambit.MutableValue;

@SqlResultSetMapping(name="entity-of-basics-implicit", entities={@EntityResult(entityClass=EntityOfBasics.class)})
@Entity
public class EntityOfBasics {
    private Integer id;
    private Boolean theBoolean = false;
    private Boolean theNumericBoolean = false;
    private Boolean theStringBoolean = false;
    private String theString;
    private Integer theInteger;
    private int theInt;
    private short theShort;
    private double theDouble;
    private URL theUrl;
    private Clob theClob;
    private Date theDate;
    private Date theTime;
    private Date theTimestamp;
    private Instant theInstant;
    private Gender gender;
    private Gender singleCharGender;
    private Gender convertedGender;
    private Gender ordinalGender;
    private Duration theDuration;
    private UUID theUuid;
    private LocalDateTime theLocalDateTime;
    private LocalDate theLocalDate;
    private LocalTime theLocalTime;
    private ZonedDateTime theZonedDateTime;
    private OffsetDateTime theOffsetDateTime;
    private MutableValue mutableValue;
    private String theField = "the string";

    public EntityOfBasics() {
    }

    public EntityOfBasics(Integer id) {
        this.id = id;
    }

    @Id
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Column(name="the_string")
    public String getTheString() {
        return this.theString;
    }

    public void setTheString(String theString) {
        this.theString = theString;
    }

    @Column(name="the_integer")
    public Integer getTheInteger() {
        return this.theInteger;
    }

    public void setTheInteger(Integer theInteger) {
        this.theInteger = theInteger;
    }

    @Column(name="the_int")
    public int getTheInt() {
        return this.theInt;
    }

    public void setTheInt(int theInt) {
        this.theInt = theInt;
    }

    @Column(name="the_short")
    public short getTheShort() {
        return this.theShort;
    }

    public void setTheShort(short theShort) {
        this.theShort = theShort;
    }

    @Column(name="the_double")
    public double getTheDouble() {
        return this.theDouble;
    }

    public void setTheDouble(double theDouble) {
        this.theDouble = theDouble;
    }

    @Column(name="the_url")
    public URL getTheUrl() {
        return this.theUrl;
    }

    public void setTheUrl(URL theUrl) {
        this.theUrl = theUrl;
    }

    @Column(name="the_clob")
    public Clob getTheClob() {
        return this.theClob;
    }

    public void setTheClob(Clob theClob) {
        this.theClob = theClob;
    }

    @Enumerated(value=EnumType.STRING)
    public Gender getGender() {
        return this.gender;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
    }

    @Enumerated(value=EnumType.STRING)
    @Column(name="single_char_gender", length=1)
    public Gender getSingleCharGender() {
        return this.singleCharGender;
    }

    public void setSingleCharGender(Gender singleCharGender) {
        this.singleCharGender = singleCharGender;
    }

    @Convert(converter=GenderConverter.class)
    @Column(name="converted_gender", length=1)
    @JdbcTypeCode(value=1)
    public Gender getConvertedGender() {
        return this.convertedGender;
    }

    public void setConvertedGender(Gender convertedGender) {
        this.convertedGender = convertedGender;
    }

    @Column(name="ordinal_gender")
    public Gender getOrdinalGender() {
        return this.ordinalGender;
    }

    public void setOrdinalGender(Gender ordinalGender) {
        this.ordinalGender = ordinalGender;
    }

    @Column(name="the_date")
    @Temporal(value=TemporalType.DATE)
    public Date getTheDate() {
        return this.theDate;
    }

    public void setTheDate(Date theDate) {
        this.theDate = theDate;
    }

    @Column(name="the_time")
    @Temporal(value=TemporalType.TIME)
    public Date getTheTime() {
        return this.theTime;
    }

    public void setTheTime(Date theTime) {
        this.theTime = theTime;
    }

    @Column(name="the_timestamp")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getTheTimestamp() {
        return this.theTimestamp;
    }

    public void setTheTimestamp(Date theTimestamp) {
        this.theTimestamp = theTimestamp;
    }

    @Column(name="the_instant")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Instant getTheInstant() {
        return this.theInstant;
    }

    public void setTheInstant(Instant theInstant) {
        this.theInstant = theInstant;
    }

    @Column(name="the_local_date_time")
    public LocalDateTime getTheLocalDateTime() {
        return this.theLocalDateTime;
    }

    public void setTheLocalDateTime(LocalDateTime theLocalDateTime) {
        this.theLocalDateTime = theLocalDateTime;
    }

    @Column(name="the_local_date")
    public LocalDate getTheLocalDate() {
        return this.theLocalDate;
    }

    public void setTheLocalDate(LocalDate theLocalDate) {
        this.theLocalDate = theLocalDate;
    }

    @Column(name="the_local_time")
    public LocalTime getTheLocalTime() {
        return this.theLocalTime;
    }

    public void setTheLocalTime(LocalTime theLocalTime) {
        this.theLocalTime = theLocalTime;
    }

    @Column(name="the_offset_date_time")
    public OffsetDateTime getTheOffsetDateTime() {
        return this.theOffsetDateTime;
    }

    public void setTheOffsetDateTime(OffsetDateTime theOffsetDateTime) {
        this.theOffsetDateTime = theOffsetDateTime;
    }

    @Column(name="the_zoned_date_time")
    public ZonedDateTime getTheZonedDateTime() {
        return this.theZonedDateTime;
    }

    public void setTheZonedDateTime(ZonedDateTime theZonedDateTime) {
        this.theZonedDateTime = theZonedDateTime;
    }

    @Column(name="the_duration")
    public Duration getTheDuration() {
        return this.theDuration;
    }

    public void setTheDuration(Duration theDuration) {
        this.theDuration = theDuration;
    }

    @Column(name="theuuid")
    public UUID getTheUuid() {
        return this.theUuid;
    }

    public void setTheUuid(UUID theUuid) {
        this.theUuid = theUuid;
    }

    @Column(name="the_boolean")
    public Boolean isTheBoolean() {
        return this.theBoolean;
    }

    public void setTheBoolean(Boolean theBoolean) {
        this.theBoolean = theBoolean;
    }

    @Column(name="the_numeric_boolean")
    @JdbcTypeCode(value=4)
    public Boolean isTheNumericBoolean() {
        return this.theNumericBoolean;
    }

    public void setTheNumericBoolean(Boolean theNumericBoolean) {
        this.theNumericBoolean = theNumericBoolean;
    }

    @Column(name="the_string_boolean")
    @JdbcTypeCode(value=1)
    public Boolean isTheStringBoolean() {
        return this.theStringBoolean;
    }

    public void setTheStringBoolean(Boolean theStringBoolean) {
        this.theStringBoolean = theStringBoolean;
    }

    @Column(name="the_column")
    public String getTheField() {
        return this.theField;
    }

    public void setTheField(String theField) {
        this.theField = theField;
    }

    @Convert(converter=MutableValueConverter.class)
    @Column(name="mutable_value")
    public MutableValue getMutableValue() {
        return this.mutableValue;
    }

    public void setMutableValue(MutableValue mutableValue) {
        this.mutableValue = mutableValue;
    }

    public static enum Gender {
        MALE,
        FEMALE,
        OTHER;

    }

    public static class GenderConverter
    implements AttributeConverter<Gender, Character> {
        public Character convertToDatabaseColumn(Gender attribute) {
            if (attribute == null) {
                return null;
            }
            if (attribute == Gender.OTHER) {
                return Character.valueOf('O');
            }
            if (attribute == Gender.MALE) {
                return Character.valueOf('M');
            }
            return Character.valueOf('F');
        }

        public Gender convertToEntityAttribute(Character dbData) {
            if (dbData == null) {
                return null;
            }
            if ('O' == dbData.charValue()) {
                return Gender.OTHER;
            }
            if ('M' == dbData.charValue()) {
                return Gender.MALE;
            }
            return Gender.FEMALE;
        }
    }

    public static class MutableValueConverter
    implements AttributeConverter<MutableValue, String> {
        public String convertToDatabaseColumn(MutableValue attribute) {
            return attribute == null ? null : attribute.getState();
        }

        public MutableValue convertToEntityAttribute(String dbData) {
            return dbData == null ? null : new MutableValue(dbData);
        }
    }
}

