/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.cleaner;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.Driver;
import java.util.Properties;

public final class JdbcConnectionContext {
    private static final Driver driver;
    private static final String url;
    private static final String user;
    private static final String password;
    private static final Properties properties;

    public static void work(ConnectionConsumer work) {
        try (Connection connection = driver.connect(url, properties);){
            connection.setAutoCommit(false);
            work.consume(connection);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <R> R workReturning(ConnectionFunction<R> work) {
        try (Connection connection = driver.connect(url, properties);){
            connection.setAutoCommit(false);
            R r = work.apply(connection);
            return r;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private JdbcConnectionContext() {
    }

    static {
        Properties connectionProperties = new Properties();
        try (InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("hibernate.properties");){
            connectionProperties.load(inputStream);
            String driverClassName = connectionProperties.getProperty("hibernate.connection.driver_class");
            driver = (Driver)Class.forName(driverClassName).newInstance();
            url = connectionProperties.getProperty("hibernate.connection.url");
            user = connectionProperties.getProperty("hibernate.connection.username");
            password = connectionProperties.getProperty("hibernate.connection.password");
            Properties p = new Properties();
            if (user != null) {
                p.put("user", user);
            }
            if (password != null) {
                p.put("password", password);
            }
            properties = p;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static interface ConnectionConsumer {
        public void consume(Connection var1) throws Exception;
    }

    public static interface ConnectionFunction<R> {
        public R apply(Connection var1) throws Exception;
    }
}

