/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.vibur.internal;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.UnknownUnwrapTypeException;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.Stoppable;
import org.vibur.dbcp.ViburDBCPDataSource;

public class ViburDBCPConnectionProvider
implements ConnectionProvider,
Configurable,
Stoppable {
    private static final String VIBUR_PREFIX = "hibernate.vibur.";
    private ViburDBCPDataSource dataSource = null;

    public void configure(Map<String, Object> configurationValues) {
        this.dataSource = new ViburDBCPDataSource(ViburDBCPConnectionProvider.transform(configurationValues));
        this.dataSource.start();
    }

    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    public void closeConnection(Connection conn) throws SQLException {
        conn.close();
    }

    public void stop() {
        if (this.dataSource != null) {
            this.dataSource.terminate();
            this.dataSource = null;
        }
    }

    public boolean supportsAggressiveRelease() {
        return false;
    }

    public boolean isUnwrappableAs(Class<?> unwrapType) {
        return ConnectionProvider.class.equals(unwrapType) || ViburDBCPConnectionProvider.class.isAssignableFrom(unwrapType);
    }

    public <T> T unwrap(Class<T> unwrapType) {
        if (this.isUnwrappableAs(unwrapType)) {
            return (T)this;
        }
        throw new UnknownUnwrapTypeException(unwrapType);
    }

    private static Properties transform(Map<String, Object> configurationValues) {
        String defaultAutoCommit;
        String defaultTransactionIsolationValue;
        String password;
        String username;
        String jdbcUrl;
        Properties result = new Properties();
        String driverClassName = (String)configurationValues.get("hibernate.connection.driver_class");
        if (driverClassName != null) {
            result.setProperty("driverClassName", driverClassName);
        }
        if ((jdbcUrl = (String)configurationValues.get("hibernate.connection.url")) != null) {
            result.setProperty("jdbcUrl", jdbcUrl);
        }
        if ((username = (String)configurationValues.get("hibernate.connection.username")) != null) {
            result.setProperty("username", username);
        }
        if ((password = (String)configurationValues.get("hibernate.connection.password")) != null) {
            result.setProperty("password", password);
        }
        if ((defaultTransactionIsolationValue = (String)configurationValues.get("hibernate.connection.isolation")) != null) {
            result.setProperty("defaultTransactionIsolationValue", defaultTransactionIsolationValue);
        }
        if ((defaultAutoCommit = (String)configurationValues.get("hibernate.connection.autocommit")) != null) {
            result.setProperty("defaultAutoCommit", defaultAutoCommit);
        }
        for (Map.Entry<String, Object> entry : configurationValues.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith(VIBUR_PREFIX)) continue;
            key = key.substring(VIBUR_PREFIX.length());
            result.setProperty(key, (String)entry.getValue());
        }
        return result;
    }

    public ViburDBCPDataSource getDataSource() {
        return this.dataSource;
    }
}

