/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.aws.impl;

import java.lang.invoke.MethodHandles;
import java.util.Optional;
import org.apache.http.HttpRequestInterceptor;
import org.hibernate.search.backend.elasticsearch.aws.impl.AwsSigningRequestInterceptor;
import org.hibernate.search.backend.elasticsearch.aws.impl.ElasticsearchAwsStaticCredentialsProvider;
import org.hibernate.search.backend.elasticsearch.aws.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.aws.spi.ElasticsearcAwsCredentialsProvider;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchHttpClientConfigurationContext;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchHttpClientConfigurer;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.OptionalConfigurationProperty;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;

public class ElasticsearchAwsHttpClientConfigurer
implements ElasticsearchHttpClientConfigurer {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final ConfigurationProperty<Boolean> SIGNING_ENABLED = ConfigurationProperty.forKey((String)"aws.signing.enabled").asBoolean().withDefault((Object)false).build();
    private static final OptionalConfigurationProperty<String> REGION = ConfigurationProperty.forKey((String)"aws.region").asString().build();
    private static final ConfigurationProperty<BeanReference<? extends ElasticsearcAwsCredentialsProvider>> CREDENTIALS_TYPE = ConfigurationProperty.forKey((String)"aws.credentials.type").asBeanReference(ElasticsearcAwsCredentialsProvider.class).withDefault((Object)BeanReference.of(ElasticsearcAwsCredentialsProvider.class, (String)"default")).build();
    private static final OptionalConfigurationProperty<String> LEGACY_ACCESS_KEY = ConfigurationProperty.forKey((String)"aws.signing.access_key").asString().build();
    private static final OptionalConfigurationProperty<String> LEGACY_SECRET_KEY = ConfigurationProperty.forKey((String)"aws.signing.secret_key").asString().build();

    public void configure(ElasticsearchHttpClientConfigurationContext context) {
        ConfigurationPropertySource propertySource = context.configurationPropertySource();
        if (!((Boolean)SIGNING_ENABLED.get(propertySource)).booleanValue()) {
            log.debug("AWS request signing is disabled.");
            return;
        }
        Region region = (Region)REGION.getAndMapOrThrow(propertySource, Region::of, log::missingPropertyForSigning);
        AwsCredentialsProvider credentialsProvider = this.createCredentialsProvider(context.beanResolver(), propertySource);
        log.debugf("AWS request signing is enabled [region = '%s', credentialsProvider = '%s'].", region, credentialsProvider);
        AwsSigningRequestInterceptor signingInterceptor = new AwsSigningRequestInterceptor(region, credentialsProvider);
        context.clientBuilder().addInterceptorLast((HttpRequestInterceptor)signingInterceptor);
    }

    private AwsCredentialsProvider createCredentialsProvider(BeanResolver beanResolver, ConfigurationPropertySource propertySource) {
        if (((Optional)LEGACY_ACCESS_KEY.get(propertySource)).isPresent() || ((Optional)LEGACY_SECRET_KEY.get(propertySource)).isPresent()) {
            throw log.obsoleteAccessKeyIdOrSecretAccessKeyForSigning(LEGACY_ACCESS_KEY.resolveOrRaw(propertySource), LEGACY_SECRET_KEY.resolveOrRaw(propertySource), CREDENTIALS_TYPE.resolveOrRaw(propertySource), "static", ElasticsearchAwsStaticCredentialsProvider.CREDENTIALS_ACCESS_KEY_ID.resolveOrRaw(propertySource), ElasticsearchAwsStaticCredentialsProvider.CREDENTIALS_SECRET_ACCESS_KEY.resolveOrRaw(propertySource));
        }
        try (BeanHolder credentialsProviderHolder = (BeanHolder)CREDENTIALS_TYPE.getAndTransform(propertySource, arg_0 -> ((BeanResolver)beanResolver).resolve(arg_0));){
            AwsCredentialsProvider awsCredentialsProvider = ((ElasticsearcAwsCredentialsProvider)credentialsProviderHolder.get()).create(propertySource);
            return awsCredentialsProvider;
        }
    }
}

