/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.aws.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.NameValuePair;
import org.apache.http.RequestLine;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;
import org.hibernate.search.backend.elasticsearch.aws.impl.HttpEntityContentStreamProvider;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.http.ContentStreamProvider;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4HttpSigner;
import software.amazon.awssdk.http.auth.spi.signer.SignRequest;
import software.amazon.awssdk.http.auth.spi.signer.SignedRequest;
import software.amazon.awssdk.identity.spi.Identity;
import software.amazon.awssdk.regions.Region;

class AwsSigningRequestInterceptor
implements HttpRequestInterceptor {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final AwsV4HttpSigner signer = AwsV4HttpSigner.create();
    private final Region region;
    private final String service;
    private final AwsCredentialsProvider credentialsProvider;

    AwsSigningRequestInterceptor(Region region, String service, AwsCredentialsProvider credentialsProvider) {
        this.region = region;
        this.service = service;
        this.credentialsProvider = credentialsProvider;
    }

    public void process(HttpRequest request, HttpContext context) throws IOException {
        try (HttpEntityContentStreamProvider contentStreamProvider = this.extractEntityContent(request);){
            this.sign(request, context, contentStreamProvider);
        }
    }

    private void sign(HttpRequest request, HttpContext context, HttpEntityContentStreamProvider contentStreamProvider) {
        SdkHttpFullRequest awsRequest = this.toAwsRequest(request, context, contentStreamProvider);
        if (log.isTraceEnabled()) {
            log.tracef("HTTP request (before signing): %s", (Object)request);
            log.tracef("AWS request (before signing): %s", (Object)awsRequest);
        }
        AwsCredentials credentials = this.credentialsProvider.resolveCredentials();
        log.tracef("AWS credentials: %s", (Object)credentials);
        SignedRequest signedRequest = this.signer.sign(r -> ((SignRequest.Builder)((SignRequest.Builder)((SignRequest.Builder)((SignRequest.Builder)r.identity((Identity)credentials)).request((SdkHttpRequest)awsRequest)).payload((Object)awsRequest.contentStreamProvider().orElse(null))).putProperty(AwsV4HttpSigner.SERVICE_SIGNING_NAME, (Object)this.service)).putProperty(AwsV4HttpSigner.REGION_NAME, (Object)this.region.id()));
        for (Map.Entry header : signedRequest.request().headers().entrySet()) {
            String name = (String)header.getKey();
            boolean first = true;
            for (String value : (List)header.getValue()) {
                if (first) {
                    request.setHeader(name, value);
                    first = false;
                    continue;
                }
                request.addHeader(name, value);
            }
        }
        if (log.isTraceEnabled()) {
            log.tracef("AWS request (after signing): %s", (Object)signedRequest);
            log.tracef("HTTP request (after signing): %s", (Object)request);
        }
    }

    private SdkHttpFullRequest toAwsRequest(HttpRequest request, HttpContext context, ContentStreamProvider contentStreamProvider) {
        List queryParameters;
        String path;
        SdkHttpFullRequest.Builder awsRequestBuilder = SdkHttpFullRequest.builder();
        HttpCoreContext coreContext = HttpCoreContext.adapt((HttpContext)context);
        HttpHost targetHost = coreContext.getTargetHost();
        awsRequestBuilder.host(targetHost.getHostName());
        awsRequestBuilder.port(Integer.valueOf(targetHost.getPort()));
        awsRequestBuilder.protocol(targetHost.getSchemeName());
        RequestLine requestLine = request.getRequestLine();
        awsRequestBuilder.method(SdkHttpMethod.fromValue((String)requestLine.getMethod()));
        String pathAndQuery = requestLine.getUri();
        int queryStart = pathAndQuery.indexOf(63);
        if (queryStart >= 0) {
            path = pathAndQuery.substring(0, queryStart);
            queryParameters = URLEncodedUtils.parse((String)pathAndQuery.substring(queryStart + 1), (Charset)StandardCharsets.UTF_8);
        } else {
            path = pathAndQuery;
            queryParameters = Collections.emptyList();
        }
        if ("aoss".equals(this.service)) {
            awsRequestBuilder.appendHeader("x-amz-content-sha256", "required");
        }
        awsRequestBuilder.encodedPath(path);
        for (NameValuePair param : queryParameters) {
            awsRequestBuilder.appendRawQueryParameter(param.getName(), param.getValue());
        }
        awsRequestBuilder.contentStreamProvider(contentStreamProvider);
        return awsRequestBuilder.build();
    }

    private HttpEntityContentStreamProvider extractEntityContent(HttpRequest request) {
        if (request instanceof HttpEntityEnclosingRequest) {
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity == null) {
                return null;
            }
            if (!entity.isRepeatable()) {
                throw new AssertionFailure("Cannot sign AWS requests with non-repeatable entities");
            }
            return new HttpEntityContentStreamProvider(entity);
        }
        return null;
    }
}

