/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.aws.logging.impl;

import java.lang.invoke.MethodHandles;
import org.apache.http.HttpRequest;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.CategorizedLogger;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;
import org.jboss.logging.annotations.ValidIdRanges;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.auth.spi.signer.SignedRequest;
import software.amazon.awssdk.regions.Region;

@CategorizedLogger(category="org.hibernate.search.elasticsearch.aws", description="Logs related to the AWS integration of the Elasticsearch backend.\n")
@MessageLogger(projectCode="HSEARCH")
@ValidIdRanges(value={@ValidIdRange(min=409000, max=409999)})
public interface AwsLog
extends BasicLogger {
    public static final String CATEGORY_NAME = "org.hibernate.search.elasticsearch.aws";
    public static final AwsLog INSTANCE = (AwsLog)LoggerFactory.make(AwsLog.class, (String)"org.hibernate.search.elasticsearch.aws", (MethodHandles.Lookup)MethodHandles.lookup());
    public static final int ID_OFFSET = 409000;

    @Message(id=409000, value="When AWS request signing is enabled, this property must be set.")
    public SearchException missingPropertyForSigning();

    @Message(id=409001, value="When AWS request signing is enabled with credentials of type '%1$s', this property must be set.")
    public SearchException missingPropertyForSigningWithCredentialsType(String var1);

    @Message(id=409002, value="Invalid credentials configuration for AWS request signing. The configuration properties '%1$s' and ' '%2$s' are now obsolete. In order to specify static credentials, set property '%3$s' to '%4$s', then set the access key ID using property '%5$s' and the secret access key using property '%6$s'.")
    public SearchException obsoleteAccessKeyIdOrSecretAccessKeyForSigning(String var1, String var2, String var3, String var4, String var5, String var6);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=409003, value="HTTP request (before signing): %s")
    public void httpRequestBeforeSigning(HttpRequest var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=409004, value="AWS request (before signing): %s")
    public void awsRequestBeforeSigning(SdkHttpFullRequest var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=409005, value="AWS credentials: %s")
    public void awsCredentials(AwsCredentials var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=409006, value="AWS request (after signing): %s")
    public void httpRequestAfterSigning(SignedRequest var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=409007, value="HTTP request (after signing): %s")
    public void awsRequestAfterSigning(HttpRequest var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=409008, value="AWS request signing is disabled.")
    public void signingDisabled();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=409009, value="AWS request signing is enabled [region = '%s', service = '%s', credentialsProvider = '%s'].")
    public void signingEnabled(Region var1, String var2, AwsCredentialsProvider var3);
}

