/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.aws.logging.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.apache.http.HttpRequest;
import org.hibernate.search.backend.elasticsearch.aws.logging.impl.AwsLog;
import org.hibernate.search.util.common.SearchException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.auth.spi.signer.SignedRequest;
import software.amazon.awssdk.regions.Region;

public class AwsLog_$logger
extends DelegatingBasicLogger
implements AwsLog,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = AwsLog_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public AwsLog_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String missingPropertyForSigning$str() {
        return "HSEARCH409000: When AWS request signing is enabled, this property must be set.";
    }

    @Override
    public final SearchException missingPropertyForSigning() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingPropertyForSigning$str(), new Object[0]));
        AwsLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) {
            e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        }
    }

    protected String missingPropertyForSigningWithCredentialsType$str() {
        return "HSEARCH409001: When AWS request signing is enabled with credentials of type '%1$s', this property must be set.";
    }

    @Override
    public final SearchException missingPropertyForSigningWithCredentialsType(String credentialsType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingPropertyForSigningWithCredentialsType$str(), credentialsType));
        AwsLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String obsoleteAccessKeyIdOrSecretAccessKeyForSigning$str() {
        return "HSEARCH409002: Invalid credentials configuration for AWS request signing. The configuration properties '%1$s' and ' '%2$s' are now obsolete. In order to specify static credentials, set property '%3$s' to '%4$s', then set the access key ID using property '%5$s' and the secret access key using property '%6$s'.";
    }

    @Override
    public final SearchException obsoleteAccessKeyIdOrSecretAccessKeyForSigning(String legacyAccessKeyIdPropertyKey, String legacySecretAccessKeyPropertyKey, String credentialsTypePropertyKey, String credentialsTypePropertyValueStatic, String accessKeyIdPropertyKey, String secretAccessKeyPropertyKey) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.obsoleteAccessKeyIdOrSecretAccessKeyForSigning$str(), legacyAccessKeyIdPropertyKey, legacySecretAccessKeyPropertyKey, credentialsTypePropertyKey, credentialsTypePropertyValueStatic, accessKeyIdPropertyKey, secretAccessKeyPropertyKey));
        AwsLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void httpRequestBeforeSigning(HttpRequest request) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.httpRequestBeforeSigning$str(), (Object)request);
    }

    protected String httpRequestBeforeSigning$str() {
        return "HSEARCH409003: HTTP request (before signing): %s";
    }

    @Override
    public final void awsRequestBeforeSigning(SdkHttpFullRequest awsRequest) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.awsRequestBeforeSigning$str(), (Object)awsRequest);
    }

    protected String awsRequestBeforeSigning$str() {
        return "HSEARCH409004: AWS request (before signing): %s";
    }

    @Override
    public final void awsCredentials(AwsCredentials credentials) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.awsCredentials$str(), (Object)credentials);
    }

    protected String awsCredentials$str() {
        return "HSEARCH409005: AWS credentials: %s";
    }

    @Override
    public final void httpRequestAfterSigning(SignedRequest signedRequest) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.httpRequestAfterSigning$str(), (Object)signedRequest);
    }

    protected String httpRequestAfterSigning$str() {
        return "HSEARCH409006: AWS request (after signing): %s";
    }

    @Override
    public final void awsRequestAfterSigning(HttpRequest request) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.awsRequestAfterSigning$str(), (Object)request);
    }

    protected String awsRequestAfterSigning$str() {
        return "HSEARCH409007: HTTP request (after signing): %s";
    }

    @Override
    public final void signingDisabled() {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.signingDisabled$str(), new Object[0]);
    }

    protected String signingDisabled$str() {
        return "HSEARCH409008: AWS request signing is disabled.";
    }

    @Override
    public final void signingEnabled(Region region, String service, AwsCredentialsProvider credentialsProvider) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.signingEnabled$str(), (Object)region, (Object)service, (Object)credentialsProvider);
    }

    protected String signingEnabled$str() {
        return "HSEARCH409009: AWS request signing is enabled [region = '%s', service = '%s', credentialsProvider = '%s'].";
    }
}

