package org.hibernate.search.backend.elasticsearch.logging.impl;

import java.util.Locale;
import java.io.Serializable;
import org.hibernate.search.util.AssertionFailure;
import org.jboss.logging.DelegatingBasicLogger;
import org.hibernate.search.backend.elasticsearch.types.sort.impl.ElasticsearchFieldSortBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.projection.impl.ElasticsearchFieldProjectionBuilderFactory;
import org.hibernate.search.util.SearchException;
import org.hibernate.search.backend.elasticsearch.index.ElasticsearchIndexManager;
import java.lang.String;
import org.hibernate.search.engine.search.SearchPredicate;
import org.jboss.logging.Logger;
import java.lang.Exception;
import org.hibernate.search.util.EventContext;
import org.hibernate.search.engine.backend.index.spi.IndexSearchTargetContextBuilder;
import com.google.gson.JsonElement;
import org.jboss.logging.BasicLogger;
import java.lang.Object;
import java.util.Arrays;
import org.hibernate.search.engine.search.SearchSort;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchFieldPredicateBuilderFactory;


import static org.jboss.logging.Logger.Level.TRACE;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String tokenizerNamingConflict = "HSEARCH400055: Multiple tokenizer definitions with the same name: '%1$s'. The tokenizer names must be unique.";
    protected String tokenizerNamingConflict$str() {
        return tokenizerNamingConflict;
    }
    @Override
    public final SearchException tokenizerNamingConflict(final String remoteName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), tokenizerNamingConflict$str(), remoteName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String charFilterNamingConflict = "HSEARCH400056: Multiple char filter definitions with the same name: '%1$s'. The char filter names must be unique.";
    protected String charFilterNamingConflict$str() {
        return charFilterNamingConflict;
    }
    @Override
    public final SearchException charFilterNamingConflict(final String remoteName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), charFilterNamingConflict$str(), remoteName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String tokenFilterNamingConflict = "HSEARCH400057: Multiple token filter definitions with the same name: '%1$s'. The token filter names must be unique.";
    protected String tokenFilterNamingConflict$str() {
        return tokenFilterNamingConflict;
    }
    @Override
    public final SearchException tokenFilterNamingConflict(final String remoteName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), tokenFilterNamingConflict$str(), remoteName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void usingPasswordOverHttp(final String serverUris) {
        super.log.logf(FQCN, WARN, null, usingPasswordOverHttp$str(), serverUris);
    }
    private static final String usingPasswordOverHttp = "HSEARCH400073: Hibernate Search will connect to Elasticsearch server '%1$s' with authentication over plain HTTP (not HTTPS). The password will be sent in clear text over the network.";
    protected String usingPasswordOverHttp$str() {
        return usingPasswordOverHttp;
    }
    private static final String analyzerNamingConflict = "HSEARCH400074: Multiple analyzer definitions with the same name: '%1$s'. The analyzer names must be unique.";
    protected String analyzerNamingConflict$str() {
        return analyzerNamingConflict;
    }
    @Override
    public final SearchException analyzerNamingConflict(final String remoteName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), analyzerNamingConflict$str(), remoteName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToApplyAnalysisConfiguration = "HSEARCH400075: Error while applying analysis configuration: %1$s";
    protected String unableToApplyAnalysisConfiguration$str() {
        return unableToApplyAnalysisConfiguration;
    }
    @Override
    public final SearchException unableToApplyAnalysisConfiguration(final String errorMessage, final EventContext context, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToApplyAnalysisConfiguration$str(), errorMessage), e, context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidElasticsearchAnalyzerDefinition = "HSEARCH400076: Invalid analyzer definition for name '%1$s'. Analyzer definitions must at least define the tokenizer.";
    protected String invalidElasticsearchAnalyzerDefinition$str() {
        return invalidElasticsearchAnalyzerDefinition;
    }
    @Override
    public final SearchException invalidElasticsearchAnalyzerDefinition(final String name) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidElasticsearchAnalyzerDefinition$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidElasticsearchTokenizerDefinition = "HSEARCH400077: Invalid tokenizer definition for name '%1$s'. Tokenizer definitions must at least define the tokenizer type.";
    protected String invalidElasticsearchTokenizerDefinition$str() {
        return invalidElasticsearchTokenizerDefinition;
    }
    @Override
    public final SearchException invalidElasticsearchTokenizerDefinition(final String name) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidElasticsearchTokenizerDefinition$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidElasticsearchCharFilterDefinition = "HSEARCH400078: Invalid char filter definition for name '%1$s'. Char filter definitions must at least define the char filter type.";
    protected String invalidElasticsearchCharFilterDefinition$str() {
        return invalidElasticsearchCharFilterDefinition;
    }
    @Override
    public final SearchException invalidElasticsearchCharFilterDefinition(final String name) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidElasticsearchCharFilterDefinition$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidElasticsearchTokenFilterDefinition = "HSEARCH400079: Invalid token filter definition for name '%1$s'. Token filter definitions must at least define the token filter type.";
    protected String invalidElasticsearchTokenFilterDefinition$str() {
        return invalidElasticsearchTokenFilterDefinition;
    }
    @Override
    public final SearchException invalidElasticsearchTokenFilterDefinition(final String name) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidElasticsearchTokenFilterDefinition$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void executedRequest(final String method, final String path, final java.util.Map<String, String> getParameters, final long timeInMs, final int responseStatusCode, final String responseStatusMessage) {
        super.log.logf(FQCN, DEBUG, null, executedRequest6$str(), method, path, getParameters, timeInMs, responseStatusCode, responseStatusMessage);
    }
    private static final String executedRequest6 = "HSEARCH400082: Executed Elasticsearch HTTP %s request to path '%s' with query parameters %s in %dms. Response had status %d '%s'.";
    protected String executedRequest6$str() {
        return executedRequest6;
    }
    private static final String normalizerNamingConflict = "HSEARCH400086: Multiple normalizer definitions with the same name: '%1$s'. The normalizer names must be unique.";
    protected String normalizerNamingConflict$str() {
        return normalizerNamingConflict;
    }
    @Override
    public final SearchException normalizerNamingConflict(final String remoteName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), normalizerNamingConflict$str(), remoteName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToParseElasticsearchResponse = "HSEARCH400089: Failed to parse Elasticsearch response. Status code was '%1$d', status phrase was '%2$s'.";
    protected String failedToParseElasticsearchResponse$str() {
        return failedToParseElasticsearchResponse;
    }
    @Override
    public final SearchException failedToParseElasticsearchResponse(final int statusCode, final String statusPhrase, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), failedToParseElasticsearchResponse$str(), statusCode, statusPhrase), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void executedRequest(final String method, final String path, final java.util.Map<String, String> getParameters, final long timeInMs, final int responseStatusCode, final String responseStatusMessage, final String requestBodyParts, final String responseBody) {
        super.log.logf(FQCN, TRACE, null, executedRequest8$str(), method, path, getParameters, timeInMs, responseStatusCode, responseStatusMessage, requestBodyParts, responseBody);
    }
    private static final String executedRequest8 = "HSEARCH400093: Executed Elasticsearch HTTP %s request to path '%s' with query parameters %s in %dms. Response had status %d '%s'. Request body: <%s>. Response body: <%s>";
    protected String executedRequest8$str() {
        return executedRequest8;
    }
    private static final String cannotMixElasticsearchSearchTargetWithOtherType = "HSEARCH400502: A search query cannot target both an Elasticsearch index and other types of index. First target was: '%1$s', other target was: '%2$s'";
    protected String cannotMixElasticsearchSearchTargetWithOtherType$str() {
        return cannotMixElasticsearchSearchTargetWithOtherType;
    }
    @Override
    public final SearchException cannotMixElasticsearchSearchTargetWithOtherType(final IndexSearchTargetContextBuilder firstTarget, final ElasticsearchIndexManager otherTarget, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixElasticsearchSearchTargetWithOtherType$str(), firstTarget, otherTarget), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotMixElasticsearchSearchTargetWithOtherBackend = "HSEARCH400503: A search query cannot target multiple Elasticsearch backends. First target was: '%1$s', other target was: '%2$s'";
    protected String cannotMixElasticsearchSearchTargetWithOtherBackend$str() {
        return cannotMixElasticsearchSearchTargetWithOtherBackend;
    }
    @Override
    public final SearchException cannotMixElasticsearchSearchTargetWithOtherBackend(final IndexSearchTargetContextBuilder firstTarget, final ElasticsearchIndexManager otherTarget, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixElasticsearchSearchTargetWithOtherBackend$str(), firstTarget, otherTarget), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownFieldForSearch = "HSEARCH400504: Unknown field '%1$s'.";
    protected String unknownFieldForSearch$str() {
        return unknownFieldForSearch;
    }
    @Override
    public final SearchException unknownFieldForSearch(final String absoluteFieldPath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownFieldForSearch$str(), absoluteFieldPath), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String elasticsearchExtensionOnUnknownType = "HSEARCH400506: The Elasticsearch extension can only be applied to objects derived from the Elasticsearch backend. Was applied to '%1$s' instead.";
    protected String elasticsearchExtensionOnUnknownType$str() {
        return elasticsearchExtensionOnUnknownType;
    }
    @Override
    public final SearchException elasticsearchExtensionOnUnknownType(final Object context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), elasticsearchExtensionOnUnknownType$str(), context));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidProjectionUnknownField = "HSEARCH400507: Invalid projection on unknown field '%1$s'.";
    protected String invalidProjectionUnknownField$str() {
        return invalidProjectionUnknownField;
    }
    @Override
    public final SearchException invalidProjectionUnknownField(final String absoluteFieldPath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidProjectionUnknownField$str(), absoluteFieldPath), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotMixElasticsearchSearchQueryWithOtherPredicates = "HSEARCH400508: An Elasticsearch query cannot include search predicates built using a non-Elasticsearch search target. Given predicate was: '%1$s'";
    protected String cannotMixElasticsearchSearchQueryWithOtherPredicates$str() {
        return cannotMixElasticsearchSearchQueryWithOtherPredicates;
    }
    @Override
    public final SearchException cannotMixElasticsearchSearchQueryWithOtherPredicates(final SearchPredicate predicate) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixElasticsearchSearchQueryWithOtherPredicates$str(), predicate));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nonObjectFieldForNestedQuery = "HSEARCH400509: Field '%1$s' is not an object field.";
    protected String nonObjectFieldForNestedQuery$str() {
        return nonObjectFieldForNestedQuery;
    }
    @Override
    public final SearchException nonObjectFieldForNestedQuery(final String absoluteFieldPath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), nonObjectFieldForNestedQuery$str(), absoluteFieldPath), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nonNestedFieldForNestedQuery = "HSEARCH400510: Object field '%1$s' is not stored as nested.";
    protected String nonNestedFieldForNestedQuery$str() {
        return nonNestedFieldForNestedQuery;
    }
    @Override
    public final SearchException nonNestedFieldForNestedQuery(final String absoluteFieldPath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), nonNestedFieldForNestedQuery$str(), absoluteFieldPath), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotMixElasticsearchSearchSortWithOtherSorts = "HSEARCH400511: An Elasticsearch query cannot include search sorts built using a non-Elasticsearch search target. Given sort was: '%1$s'";
    protected String cannotMixElasticsearchSearchSortWithOtherSorts$str() {
        return cannotMixElasticsearchSearchSortWithOtherSorts;
    }
    @Override
    public final SearchException cannotMixElasticsearchSearchSortWithOtherSorts(final SearchSort sort) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixElasticsearchSearchSortWithOtherSorts$str(), sort));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String multiTenancyRequiredButNotSupportedByBackend = "HSEARCH400514: Index '%1$s' requires multi-tenancy but the backend does not support it in its current configuration.";
    protected String multiTenancyRequiredButNotSupportedByBackend$str() {
        return multiTenancyRequiredButNotSupportedByBackend;
    }
    @Override
    public final SearchException multiTenancyRequiredButNotSupportedByBackend(final String indexName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), multiTenancyRequiredButNotSupportedByBackend$str(), indexName), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownMultiTenancyStrategyConfiguration = "HSEARCH400515: Unknown multi-tenancy strategy '%1$s'.";
    protected String unknownMultiTenancyStrategyConfiguration$str() {
        return unknownMultiTenancyStrategyConfiguration;
    }
    @Override
    public final SearchException unknownMultiTenancyStrategyConfiguration(final String multiTenancyStrategy) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownMultiTenancyStrategyConfiguration$str(), multiTenancyStrategy));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String tenantIdProvidedButMultiTenancyDisabled = "HSEARCH400516: Tenant identifier '%1$s' is provided, but multi-tenancy is disabled for this backend.";
    protected String tenantIdProvidedButMultiTenancyDisabled$str() {
        return tenantIdProvidedButMultiTenancyDisabled;
    }
    @Override
    public final SearchException tenantIdProvidedButMultiTenancyDisabled(final String tenantId, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), tenantIdProvidedButMultiTenancyDisabled$str(), tenantId), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String multiTenancyEnabledButNoTenantIdProvided = "HSEARCH400517: Backend has multi-tenancy enabled, but no tenant identifier is provided.";
    protected String multiTenancyEnabledButNoTenantIdProvided$str() {
        return multiTenancyEnabledButNoTenantIdProvided;
    }
    @Override
    public final SearchException multiTenancyEnabledButNoTenantIdProvided(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), multiTenancyEnabledButNoTenantIdProvided$str()), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String clientUnwrappingWithUnkownType = "HSEARCH400518: Attempt to unwrap the Elasticsearch low-level client to %1$s, but the client can only be unwrapped to %2$s.";
    protected String clientUnwrappingWithUnkownType$str() {
        return clientUnwrappingWithUnkownType;
    }
    @Override
    public final SearchException clientUnwrappingWithUnkownType(final Class<?> requestedClass, final Class<?> actualClass) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), clientUnwrappingWithUnkownType$str(), requestedClass, actualClass));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String backendUnwrappingWithUnknownType = "HSEARCH400519: Attempt to unwrap an Elasticsearch backend to '%1$s', but this backend can only be unwrapped to '%2$s'.";
    protected String backendUnwrappingWithUnknownType$str() {
        return backendUnwrappingWithUnknownType;
    }
    @Override
    public final SearchException backendUnwrappingWithUnknownType(final Class<?> requestedClass, final Class<?> actualClass, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), backendUnwrappingWithUnknownType$str(), new org.hibernate.search.util.impl.common.logging.ClassFormatter(requestedClass), new org.hibernate.search.util.impl.common.logging.ClassFormatter(actualClass)), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String indexSchemaNodeNameConflict = "HSEARCH400520: The index schema node '%1$s' was added twice. Multiple bridges may be trying to access the same index field,  or two indexed-embeddeds may have prefixes that lead to conflicting field names, or you may have declared multiple conflicting mappings. In any case, there is something wrong with your mapping and you should fix it.";
    protected String indexSchemaNodeNameConflict$str() {
        return indexSchemaNodeNameConflict;
    }
    @Override
    public final SearchException indexSchemaNodeNameConflict(final String name, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), indexSchemaNodeNameConflict$str(), name), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String rangePredicatesNotSupportedByGeoPoint = "HSEARCH400523: Range predicates are not supported by the GeoPoint field type, use spatial predicates instead.";
    protected String rangePredicatesNotSupportedByGeoPoint$str() {
        return rangePredicatesNotSupportedByGeoPoint;
    }
    @Override
    public final SearchException rangePredicatesNotSupportedByGeoPoint(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), rangePredicatesNotSupportedByGeoPoint$str()), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String matchPredicatesNotSupportedByGeoPoint = "HSEARCH400524: Match predicates are not supported by the GeoPoint field type, use spatial predicates instead.";
    protected String matchPredicatesNotSupportedByGeoPoint$str() {
        return matchPredicatesNotSupportedByGeoPoint;
    }
    @Override
    public final SearchException matchPredicatesNotSupportedByGeoPoint(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), matchPredicatesNotSupportedByGeoPoint$str()), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidParentDocumentObjectState = "HSEARCH400525: Invalid parent object for this field accessor; expected path '%1$s', got '%2$s'.";
    protected String invalidParentDocumentObjectState$str() {
        return invalidParentDocumentObjectState;
    }
    @Override
    public final SearchException invalidParentDocumentObjectState(final String expectedPath, final String actualPath) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidParentDocumentObjectState$str(), expectedPath, actualPath));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String elasticsearchResponseMissingData = "HSEARCH400526: Expected data was missing in the Elasticsearch response.";
    protected String elasticsearchResponseMissingData$str() {
        return elasticsearchResponseMissingData;
    }
    @Override
    public final AssertionFailure elasticsearchResponseMissingData() {
        final AssertionFailure result = new AssertionFailure(String.format(getLoggingLocale(), elasticsearchResponseMissingData$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String spatialPredicatesNotSupportedByFieldType = "HSEARCH400527: Spatial predicates are not supported by this field's type.";
    protected String spatialPredicatesNotSupportedByFieldType$str() {
        return spatialPredicatesNotSupportedByFieldType;
    }
    @Override
    public final SearchException spatialPredicatesNotSupportedByFieldType(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), spatialPredicatesNotSupportedByFieldType$str()), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String distanceOperationsNotSupportedByFieldType = "HSEARCH400528: Distance related operations are not supported by this field's type.";
    protected String distanceOperationsNotSupportedByFieldType$str() {
        return distanceOperationsNotSupportedByFieldType;
    }
    @Override
    public final SearchException distanceOperationsNotSupportedByFieldType(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), distanceOperationsNotSupportedByFieldType$str()), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String minimumShouldMatchConflictingConstraints = "HSEARCH400529: Multiple conflicting minimumShouldMatch constraints for ceiling '%1$s'";
    protected String minimumShouldMatchConflictingConstraints$str() {
        return minimumShouldMatchConflictingConstraints;
    }
    @Override
    public final SearchException minimumShouldMatchConflictingConstraints(final int ceiling) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), minimumShouldMatchConflictingConstraints$str(), ceiling));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicateNormalizedIndexNames = "HSEARCH400530: Duplicate index names when normalized to conform to Elasticsearch rules: '%1$s' and '%2$s' both become '%3$s'";
    protected String duplicateNormalizedIndexNames$str() {
        return duplicateNormalizedIndexNames;
    }
    @Override
    public final SearchException duplicateNormalizedIndexNames(final String firstHibernateSearchIndexName, final String secondHibernateSearchIndexName, final String elasticsearchIndexName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), duplicateNormalizedIndexNames$str(), firstHibernateSearchIndexName, secondHibernateSearchIndexName, elasticsearchIndexName), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String elasticsearchResponseUnknownIndexName = "HSEARCH400531: Unknown index name encountered in Elasticsearch response: '%1$s'";
    protected String elasticsearchResponseUnknownIndexName$str() {
        return elasticsearchResponseUnknownIndexName;
    }
    @Override
    public final SearchException elasticsearchResponseUnknownIndexName(final String elasticsearchIndexName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), elasticsearchResponseUnknownIndexName$str(), elasticsearchIndexName), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotConvertDslParameter = "HSEARCH400532: Unable to convert DSL parameter: %1$s";
    protected String cannotConvertDslParameter$str() {
        return cannotConvertDslParameter;
    }
    @Override
    public final SearchException cannotConvertDslParameter(final String errorMessage, final Exception cause, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotConvertDslParameter$str(), errorMessage), cause, context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String indexManagerUnwrappingWithUnknownType = "HSEARCH400533: Attempt to unwrap an Elasticsearch index manager to '%1$s', but this index manager can only be unwrapped to '%2$s'.";
    protected String indexManagerUnwrappingWithUnknownType$str() {
        return indexManagerUnwrappingWithUnknownType;
    }
    @Override
    public final SearchException indexManagerUnwrappingWithUnknownType(final Class<?> requestedClass, final Class<?> actualClass, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), indexManagerUnwrappingWithUnknownType$str(), new org.hibernate.search.util.impl.common.logging.ClassFormatter(requestedClass), new org.hibernate.search.util.impl.common.logging.ClassFormatter(actualClass)), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidElasticsearchTypedAnalyzerDefinition = "HSEARCH400534: Invalid typed analyzer definition for name '%1$s'. Typed analyzer definitions must at least define the analyzer type.";
    protected String invalidElasticsearchTypedAnalyzerDefinition$str() {
        return invalidElasticsearchTypedAnalyzerDefinition;
    }
    @Override
    public final SearchException invalidElasticsearchTypedAnalyzerDefinition(final String name) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidElasticsearchTypedAnalyzerDefinition$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotApplyAnalyzerAndNormalizer = "HSEARCH400535: Cannot apply both an analyzer and a normalizer. Analyzer: '%1$s', normalizer: '%2$s'.";
    protected String cannotApplyAnalyzerAndNormalizer$str() {
        return cannotApplyAnalyzerAndNormalizer;
    }
    @Override
    public final SearchException cannotApplyAnalyzerAndNormalizer(final String analyzerName, final String normalizerName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotApplyAnalyzerAndNormalizer$str(), analyzerName, normalizerName), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotUseAnalyzerOnSortableField = "HSEARCH400536: Cannot apply an analyzer on a sortable field. Use a normalizer instead. Analyzer: '%1$s'. If an actual analyzer (with tokenization) is necessary, define two separate fields: one with an analyzer that is not sortable, and one with a normalizer that is sortable.";
    protected String cannotUseAnalyzerOnSortableField$str() {
        return cannotUseAnalyzerOnSortableField;
    }
    @Override
    public final SearchException cannotUseAnalyzerOnSortableField(final String analyzerName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotUseAnalyzerOnSortableField$str(), analyzerName), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String analysisComponentParameterConflict = "HSEARCH400537: Multiple parameters with the same name: '%1$s'. Can't assign both value '%2$s' and '%3$s'";
    protected String analysisComponentParameterConflict$str() {
        return analysisComponentParameterConflict;
    }
    @Override
    public final SearchException analysisComponentParameterConflict(final String name, final JsonElement value1, final JsonElement value2) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), analysisComponentParameterConflict$str(), name, value1, value2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotMixElasticsearchSearchQueryWithOtherProjections = "HSEARCH400538: An Elasticsearch query cannot include search projections built using a non-Elasticsearch search target. Given projection was: '%1$s'";
    protected String cannotMixElasticsearchSearchQueryWithOtherProjections$str() {
        return cannotMixElasticsearchSearchQueryWithOtherProjections;
    }
    @Override
    public final SearchException cannotMixElasticsearchSearchQueryWithOtherProjections(final org.hibernate.search.engine.search.SearchProjection<?> projection) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixElasticsearchSearchQueryWithOtherProjections$str(), projection));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidProjectionInvalidType = "HSEARCH400539: Invalid type '%2$s' for projection on field '%1$s'.";
    protected String invalidProjectionInvalidType$str() {
        return invalidProjectionInvalidType;
    }
    @Override
    public final SearchException invalidProjectionInvalidType(final String absoluteFieldPath, final Class<?> type, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidProjectionInvalidType$str(), absoluteFieldPath, new org.hibernate.search.util.impl.common.logging.ClassFormatter(type)), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String traditionalSortNotSupportedByGeoPoint = "HSEARCH400540: Traditional sorting operations are not supported by the GeoPoint field type, use distance sorting instead.";
    protected String traditionalSortNotSupportedByGeoPoint$str() {
        return traditionalSortNotSupportedByGeoPoint;
    }
    @Override
    public final SearchException traditionalSortNotSupportedByGeoPoint(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), traditionalSortNotSupportedByGeoPoint$str()), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String conflictingFieldTypesForPredicate = "HSEARCH400541: Multiple conflicting types to build a predicate for field '%1$s': '%2$s' vs. '%3$s'.";
    protected String conflictingFieldTypesForPredicate$str() {
        return conflictingFieldTypesForPredicate;
    }
    @Override
    public final SearchException conflictingFieldTypesForPredicate(final String absoluteFieldPath, final ElasticsearchFieldPredicateBuilderFactory component1, final ElasticsearchFieldPredicateBuilderFactory component2, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), conflictingFieldTypesForPredicate$str(), absoluteFieldPath, component1, component2), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String conflictingFieldTypesForSort = "HSEARCH400542: Multiple conflicting types to build a sort for field '%1$s': '%2$s' vs. '%3$s'.";
    protected String conflictingFieldTypesForSort$str() {
        return conflictingFieldTypesForSort;
    }
    @Override
    public final SearchException conflictingFieldTypesForSort(final String absoluteFieldPath, final ElasticsearchFieldSortBuilderFactory component1, final ElasticsearchFieldSortBuilderFactory component2, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), conflictingFieldTypesForSort$str(), absoluteFieldPath, component1, component2), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String conflictingFieldTypesForProjection = "HSEARCH400543: Multiple conflicting types to build a projection for field '%1$s': '%2$s' vs. '%3$s'.";
    protected String conflictingFieldTypesForProjection$str() {
        return conflictingFieldTypesForProjection;
    }
    @Override
    public final SearchException conflictingFieldTypesForProjection(final String absoluteFieldPath, final ElasticsearchFieldProjectionBuilderFactory component1, final ElasticsearchFieldProjectionBuilderFactory component2, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), conflictingFieldTypesForProjection$str(), absoluteFieldPath, component1, component2), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToShutdownBackend = "HSEARCH400544: Failed to shut down the Elasticsearch backend.";
    protected String failedToShutdownBackend$str() {
        return failedToShutdownBackend;
    }
    @Override
    public final SearchException failedToShutdownBackend(final Exception cause, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), failedToShutdownBackend$str()), cause, context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotGuessFieldType = "HSEARCH400545: Cannot guess field type for input type %1$s.";
    protected String cannotGuessFieldType$str() {
        return cannotGuessFieldType;
    }
    @Override
    public final SearchException cannotGuessFieldType(final Class<?> inputType, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotGuessFieldType$str(), new org.hibernate.search.util.impl.common.logging.ClassFormatter(inputType)), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String tryToSetFieldTypeMoreThanOnce = "HSEARCH400546: You cannot set the type of a field more than once.";
    protected String tryToSetFieldTypeMoreThanOnce$str() {
        return tryToSetFieldTypeMoreThanOnce;
    }
    @Override
    public final SearchException tryToSetFieldTypeMoreThanOnce(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), tryToSetFieldTypeMoreThanOnce$str()), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nonProjectableField = "HSEARCH400547: Projections are not enabled for field '%1$s'. Make sure the field is marked as projectable.";
    protected String nonProjectableField$str() {
        return nonProjectableField;
    }
    @Override
    public final SearchException nonProjectableField(final String absoluteFieldPath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), nonProjectableField$str(), absoluteFieldPath), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsortableField = "HSEARCH400548: Sorting is not enabled for field '%1$s'. Make sure the field is marked as sortable.";
    protected String unsortableField$str() {
        return unsortableField;
    }
    @Override
    public final SearchException unsortableField(final String absoluteFieldPath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unsortableField$str(), absoluteFieldPath), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
