/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.analysis.model.dsl.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.elasticsearch.analysis.model.dsl.ElasticsearchAnalyzerDefinitionWithTokenizerContext;
import org.hibernate.search.backend.elasticsearch.analysis.model.dsl.ElasticsearchCustomAnalyzerDefinitionContext;
import org.hibernate.search.backend.elasticsearch.analysis.model.impl.ElasticsearchAnalysisDefinitionCollector;
import org.hibernate.search.backend.elasticsearch.analysis.model.impl.ElasticsearchAnalysisDefinitionContributor;
import org.hibernate.search.backend.elasticsearch.analysis.model.impl.esnative.AnalyzerDefinition;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.util.impl.common.LoggerFactory;
import org.hibernate.search.util.impl.common.StringHelper;

public class ElasticsearchCustomAnalyzerDefinitionContextImpl
implements ElasticsearchCustomAnalyzerDefinitionContext,
ElasticsearchAnalyzerDefinitionWithTokenizerContext,
ElasticsearchAnalysisDefinitionContributor {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final String name;
    private final AnalyzerDefinition definition = new AnalyzerDefinition();

    ElasticsearchCustomAnalyzerDefinitionContextImpl(String name) {
        this.name = name;
        this.definition.setType("custom");
    }

    @Override
    public ElasticsearchAnalyzerDefinitionWithTokenizerContext withTokenizer(String tokenizerName) {
        this.definition.setTokenizer(tokenizerName);
        return this;
    }

    @Override
    public ElasticsearchAnalyzerDefinitionWithTokenizerContext withCharFilters(String ... names) {
        this.definition.setCharFilters(null);
        for (String charFilterName : names) {
            this.definition.addCharFilter(charFilterName);
        }
        return this;
    }

    @Override
    public ElasticsearchAnalyzerDefinitionWithTokenizerContext withTokenFilters(String ... names) {
        this.definition.setTokenFilters(null);
        for (String tokenFilterName : names) {
            this.definition.addTokenFilter(tokenFilterName);
        }
        return this;
    }

    @Override
    public void contribute(ElasticsearchAnalysisDefinitionCollector collector) {
        if (StringHelper.isEmpty((String)this.definition.getTokenizer())) {
            throw log.invalidElasticsearchAnalyzerDefinition(this.name);
        }
        collector.collect(this.name, this.definition);
    }
}

