/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.cfg;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.util.impl.common.LoggerFactory;

public enum MultiTenancyStrategyConfiguration {
    NONE("none"),
    DISCRIMINATOR("discriminator");

    private static final Log log;
    private final String externalRepresentation;

    private MultiTenancyStrategyConfiguration(String externalRepresentation) {
        this.externalRepresentation = externalRepresentation;
    }

    public static MultiTenancyStrategyConfiguration fromExternalRepresentation(String multiTenancyStrategy) {
        if (MultiTenancyStrategyConfiguration.NONE.externalRepresentation.equals(multiTenancyStrategy)) {
            return NONE;
        }
        if (MultiTenancyStrategyConfiguration.DISCRIMINATOR.externalRepresentation.equals(multiTenancyStrategy)) {
            return DISCRIMINATOR;
        }
        throw log.unknownMultiTenancyStrategyConfiguration(multiTenancyStrategy);
    }

    static {
        log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    }
}

