/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.client.impl;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.nio.conn.NoopIOSessionStrategy;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.sniff.ElasticsearchNodesSniffer;
import org.elasticsearch.client.sniff.NodesSniffer;
import org.elasticsearch.client.sniff.Sniffer;
import org.elasticsearch.client.sniff.SnifferBuilder;
import org.hibernate.search.backend.elasticsearch.cfg.SearchBackendElasticsearchSettings;
import org.hibernate.search.backend.elasticsearch.client.impl.ElasticsearchClientFactory;
import org.hibernate.search.backend.elasticsearch.client.impl.ElasticsearchClientImpl;
import org.hibernate.search.backend.elasticsearch.client.impl.ElasticsearchClientImplementor;
import org.hibernate.search.backend.elasticsearch.client.impl.ServerUris;
import org.hibernate.search.backend.elasticsearch.gson.impl.GsonProvider;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.util.impl.common.SearchThreadFactory;

public class ElasticsearchClientFactoryImpl
implements ElasticsearchClientFactory {
    private static final ConfigurationProperty<List<String>> HOST = ConfigurationProperty.forKey((String)"host").asString().multivalued(Pattern.compile("\\s+")).withDefault(SearchBackendElasticsearchSettings.Defaults.HOST).build();
    private static final ConfigurationProperty<Optional<String>> USERNAME = ConfigurationProperty.forKey((String)"username").asString().build();
    private static final ConfigurationProperty<Optional<String>> PASSWORD = ConfigurationProperty.forKey((String)"password").asString().build();
    private static final ConfigurationProperty<Integer> REQUEST_TIMEOUT = ConfigurationProperty.forKey((String)"request_timeout").asInteger().withDefault((Object)60000).build();
    private static final ConfigurationProperty<Integer> READ_TIMEOUT = ConfigurationProperty.forKey((String)"read_timeout").asInteger().withDefault((Object)60000).build();
    private static final ConfigurationProperty<Integer> CONNECTION_TIMEOUT = ConfigurationProperty.forKey((String)"connection_timeout").asInteger().withDefault((Object)3000).build();
    private static final ConfigurationProperty<Integer> MAX_TOTAL_CONNECTION = ConfigurationProperty.forKey((String)"max_total_connection").asInteger().withDefault((Object)20).build();
    private static final ConfigurationProperty<Integer> MAX_TOTAL_CONNECTION_PER_ROUTE = ConfigurationProperty.forKey((String)"max_total_connection_per_route").asInteger().withDefault((Object)2).build();
    private static final ConfigurationProperty<Boolean> DISCOVERY_ENABLED = ConfigurationProperty.forKey((String)"discovery.enabled").asBoolean().withDefault((Object)false).build();
    private static final ConfigurationProperty<Integer> DISCOVERY_REFRESH_INTERVAL = ConfigurationProperty.forKey((String)"discovery.refresh_interval").asInteger().withDefault((Object)10).build();
    private static final ConfigurationProperty<String> DISCOVERY_SCHEME = ConfigurationProperty.forKey((String)"discovery.default_scheme").asString().withDefault((Object)"http").build();

    @Override
    public ElasticsearchClientImplementor create(ConfigurationPropertySource propertySource, GsonProvider initialGsonProvider) {
        int requestTimeoutMs = (Integer)REQUEST_TIMEOUT.get(propertySource);
        RestClient restClient = this.createClient(propertySource, requestTimeoutMs);
        Sniffer sniffer = this.createSniffer(restClient, propertySource);
        return new ElasticsearchClientImpl(restClient, sniffer, requestTimeoutMs, TimeUnit.MILLISECONDS, initialGsonProvider);
    }

    private RestClient createClient(ConfigurationPropertySource propertySource, int maxRetryTimeoutMillis) {
        ServerUris hosts = ServerUris.fromStrings((List)HOST.get(propertySource));
        return RestClient.builder((HttpHost[])hosts.asHostsArray()).setMaxRetryTimeoutMillis(maxRetryTimeoutMillis).setRequestConfigCallback(b -> this.customizeRequestConfig(propertySource, b)).setHttpClientConfigCallback(b -> this.customizeHttpClientConfig(propertySource, hosts, b)).build();
    }

    private Sniffer createSniffer(RestClient client, ConfigurationPropertySource propertySource) {
        boolean discoveryEnabled = (Boolean)DISCOVERY_ENABLED.get(propertySource);
        if (discoveryEnabled) {
            SnifferBuilder builder = Sniffer.builder((RestClient)client).setSniffIntervalMillis((Integer)DISCOVERY_REFRESH_INTERVAL.get(propertySource) * 1000);
            String scheme = (String)DISCOVERY_SCHEME.get(propertySource);
            if (scheme.equals(ElasticsearchNodesSniffer.Scheme.HTTPS.toString())) {
                ElasticsearchNodesSniffer hostsSniffer = new ElasticsearchNodesSniffer(client, ElasticsearchNodesSniffer.DEFAULT_SNIFF_REQUEST_TIMEOUT, ElasticsearchNodesSniffer.Scheme.HTTPS);
                builder.setNodesSniffer((NodesSniffer)hostsSniffer);
            }
            return builder.build();
        }
        return null;
    }

    private HttpAsyncClientBuilder customizeHttpClientConfig(ConfigurationPropertySource propertySource, ServerUris hosts, HttpAsyncClientBuilder builder) {
        Optional username;
        builder = builder.setMaxConnTotal(((Integer)MAX_TOTAL_CONNECTION.get(propertySource)).intValue()).setMaxConnPerRoute(((Integer)MAX_TOTAL_CONNECTION_PER_ROUTE.get(propertySource)).intValue()).setThreadFactory((ThreadFactory)new SearchThreadFactory("Elasticsearch transport thread"));
        if (!hosts.isAnyRequiringSSL()) {
            builder.setSSLStrategy((SchemeIOSessionStrategy)NoopIOSessionStrategy.INSTANCE);
        }
        if ((username = (Optional)USERNAME.get(propertySource)).isPresent()) {
            Optional password = (Optional)PASSWORD.get(propertySource);
            if (password.isPresent()) {
                hosts.warnPasswordsOverHttp();
            }
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, AuthScope.ANY_SCHEME), (Credentials)new UsernamePasswordCredentials((String)username.get(), (String)password.orElse(null)));
            builder = builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
        return builder;
    }

    private RequestConfig.Builder customizeRequestConfig(ConfigurationPropertySource propertySource, RequestConfig.Builder builder) {
        return builder.setConnectionRequestTimeout(0).setSocketTimeout(((Integer)READ_TIMEOUT.get(propertySource)).intValue()).setConnectTimeout(((Integer)CONNECTION_TIMEOUT.get(propertySource)).intValue());
    }
}

