/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.document.impl;

import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaObjectNode;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.util.impl.common.LoggerFactory;

public class ElasticsearchDocumentObjectBuilder
implements DocumentElement {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final ElasticsearchIndexSchemaObjectNode schemaNode;
    private final JsonObject content;

    public ElasticsearchDocumentObjectBuilder() {
        this(ElasticsearchIndexSchemaObjectNode.root(), new JsonObject());
    }

    ElasticsearchDocumentObjectBuilder(ElasticsearchIndexSchemaObjectNode schemaNode, JsonObject content) {
        this.schemaNode = schemaNode;
        this.content = content;
    }

    public <T> void add(JsonAccessor<T> relativeAccessor, T value) {
        relativeAccessor.add(this.content, value);
    }

    public void checkTreeConsistency(ElasticsearchIndexSchemaObjectNode expectedParentNode) {
        if (!Objects.equals(expectedParentNode, this.schemaNode)) {
            throw log.invalidParentDocumentObjectState(expectedParentNode.getAbsolutePath(), this.schemaNode.getAbsolutePath());
        }
    }

    public JsonObject build(MultiTenancyStrategy multiTenancyStrategy, String tenantId, String id) {
        multiTenancyStrategy.contributeToIndexedDocument(this.content, tenantId, id);
        return this.content;
    }
}

