/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.document.impl;

import com.google.gson.JsonElement;
import org.hibernate.search.backend.elasticsearch.document.impl.ElasticsearchDocumentObjectBuilder;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaFieldNode;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.engine.backend.document.IndexFieldAccessor;

public class ElasticsearchIndexFieldAccessor<F>
implements IndexFieldAccessor<F> {
    private final JsonAccessor<JsonElement> accessor;
    private final ElasticsearchIndexSchemaFieldNode<F> schemaNode;

    public ElasticsearchIndexFieldAccessor(JsonAccessor<JsonElement> accessor, ElasticsearchIndexSchemaFieldNode<F> schemaNode) {
        this.accessor = accessor;
        this.schemaNode = schemaNode;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[schemaNode=" + this.schemaNode + ", accessor=" + this.accessor + "]";
    }

    public void write(DocumentElement target, F value) {
        ElasticsearchDocumentObjectBuilder builder = (ElasticsearchDocumentObjectBuilder)target;
        builder.checkTreeConsistency(this.schemaNode.getParent());
        builder.add(this.accessor, this.schemaNode.getCodec().encode(value));
    }
}

