/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.document.model.dsl.impl;

import java.lang.invoke.MethodHandles;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.impl.ElasticsearchIndexSchemaFieldContextImpl;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.impl.ElasticsearchIndexSchemaObjectFieldNodeBuilder;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.impl.ElasticsearchIndexSchemaRootNodeBuilder;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaNodeCollector;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaNodeContributor;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaObjectNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.AbstractTypeMapping;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.PropertyMapping;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaFieldContext;
import org.hibernate.search.engine.backend.document.model.dsl.ObjectFieldStorage;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaObjectFieldNodeBuilder;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaObjectNodeBuilder;
import org.hibernate.search.util.impl.common.LoggerFactory;

abstract class AbstractElasticsearchIndexSchemaObjectNodeBuilder
implements IndexSchemaObjectNodeBuilder {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final Map<String, ElasticsearchIndexSchemaNodeContributor<PropertyMapping>> content = new LinkedHashMap<String, ElasticsearchIndexSchemaNodeContributor<PropertyMapping>>();

    AbstractElasticsearchIndexSchemaObjectNodeBuilder() {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "absolutePath=" + this.getAbsolutePath() + "]";
    }

    public IndexSchemaFieldContext addField(String relativeFieldName) {
        ElasticsearchIndexSchemaFieldContextImpl fieldContext = new ElasticsearchIndexSchemaFieldContextImpl(this, relativeFieldName);
        this.putProperty(relativeFieldName, fieldContext);
        return fieldContext;
    }

    public IndexSchemaFieldContext createExcludedField(String relativeFieldName) {
        return new ElasticsearchIndexSchemaFieldContextImpl(this, relativeFieldName);
    }

    public IndexSchemaObjectFieldNodeBuilder addObjectField(String relativeFieldName, ObjectFieldStorage storage) {
        ElasticsearchIndexSchemaObjectFieldNodeBuilder objectFieldBuilder = new ElasticsearchIndexSchemaObjectFieldNodeBuilder(this, relativeFieldName, storage);
        this.putProperty(relativeFieldName, objectFieldBuilder);
        return objectFieldBuilder;
    }

    public IndexSchemaObjectFieldNodeBuilder createExcludedObjectField(String relativeFieldName, ObjectFieldStorage storage) {
        return new ElasticsearchIndexSchemaObjectFieldNodeBuilder(this, relativeFieldName, storage);
    }

    final void contributeChildren(AbstractTypeMapping mapping, ElasticsearchIndexSchemaObjectNode node, ElasticsearchIndexSchemaNodeCollector collector) {
        for (Map.Entry<String, ElasticsearchIndexSchemaNodeContributor<PropertyMapping>> entry : this.content.entrySet()) {
            String propertyName = entry.getKey();
            ElasticsearchIndexSchemaNodeContributor<PropertyMapping> propertyContributor = entry.getValue();
            PropertyMapping propertyMapping = propertyContributor.contribute(collector, node);
            mapping.addProperty(propertyName, propertyMapping);
        }
    }

    abstract ElasticsearchIndexSchemaRootNodeBuilder getRootNodeBuilder();

    abstract String getAbsolutePath();

    private void putProperty(String name, ElasticsearchIndexSchemaNodeContributor<PropertyMapping> contributor) {
        ElasticsearchIndexSchemaNodeContributor<PropertyMapping> previous = this.content.putIfAbsent(name, contributor);
        if (previous != null) {
            throw log.indexSchemaNodeNameConflict(name, this.getEventContext());
        }
    }
}

