/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.document.model.dsl.impl;

import java.lang.invoke.MethodHandles;
import java.time.Instant;
import java.time.LocalDate;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.ElasticsearchIndexSchemaFieldContext;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.ElasticsearchJsonStringIndexSchemaFieldTypedContext;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.impl.AbstractElasticsearchIndexSchemaObjectNodeBuilder;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaNodeCollector;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaNodeContributor;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaObjectNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.PropertyMapping;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchBooleanIndexSchemaFieldContext;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchGeoPointIndexSchemaFieldContext;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchInstantIndexSchemaFieldContext;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchIntegerIndexSchemaFieldContext;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchJsonStringIndexSchemaFieldContext;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchLocalDateIndexSchemaFieldContext;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchLongIndexSchemaFieldContext;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchStringIndexSchemaFieldContext;
import org.hibernate.search.backend.elasticsearch.util.impl.ElasticsearchFields;
import org.hibernate.search.engine.backend.document.model.dsl.StandardIndexSchemaFieldTypedContext;
import org.hibernate.search.engine.backend.document.model.dsl.StringIndexSchemaFieldTypedContext;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaContext;
import org.hibernate.search.engine.logging.spi.EventContexts;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.util.EventContext;
import org.hibernate.search.util.impl.common.LoggerFactory;

class ElasticsearchIndexSchemaFieldContextImpl
implements ElasticsearchIndexSchemaFieldContext,
ElasticsearchIndexSchemaNodeContributor<PropertyMapping>,
IndexSchemaContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final AbstractElasticsearchIndexSchemaObjectNodeBuilder parent;
    private final String relativeFieldName;
    private final String absoluteFieldPath;
    private ElasticsearchIndexSchemaNodeContributor<PropertyMapping> delegate;

    ElasticsearchIndexSchemaFieldContextImpl(AbstractElasticsearchIndexSchemaObjectNodeBuilder parent, String relativeFieldName) {
        this.parent = parent;
        this.relativeFieldName = relativeFieldName;
        this.absoluteFieldPath = ElasticsearchFields.compose(parent.getAbsolutePath(), relativeFieldName);
    }

    public <F> StandardIndexSchemaFieldTypedContext<?, F> as(Class<F> inputType) {
        if (String.class.equals(inputType)) {
            return this.asString();
        }
        if (Integer.class.equals(inputType)) {
            return this.asInteger();
        }
        if (Long.class.equals(inputType)) {
            return this.asLong();
        }
        if (Boolean.class.equals(inputType)) {
            return this.asBoolean();
        }
        if (LocalDate.class.equals(inputType)) {
            return this.asLocalDate();
        }
        if (Instant.class.equals(inputType)) {
            return this.asInstant();
        }
        if (GeoPoint.class.equals(inputType)) {
            return this.asGeoPoint();
        }
        throw log.cannotGuessFieldType(inputType, this.getEventContext());
    }

    public StringIndexSchemaFieldTypedContext<?> asString() {
        return this.setDelegate(new ElasticsearchStringIndexSchemaFieldContext((IndexSchemaContext)this, this.relativeFieldName));
    }

    public StandardIndexSchemaFieldTypedContext<?, Integer> asInteger() {
        return this.setDelegate(new ElasticsearchIntegerIndexSchemaFieldContext((IndexSchemaContext)this, this.relativeFieldName));
    }

    public StandardIndexSchemaFieldTypedContext<?, Long> asLong() {
        return this.setDelegate(new ElasticsearchLongIndexSchemaFieldContext((IndexSchemaContext)this, this.relativeFieldName));
    }

    public StandardIndexSchemaFieldTypedContext<?, Boolean> asBoolean() {
        return this.setDelegate(new ElasticsearchBooleanIndexSchemaFieldContext((IndexSchemaContext)this, this.relativeFieldName));
    }

    public StandardIndexSchemaFieldTypedContext<?, LocalDate> asLocalDate() {
        return this.setDelegate(new ElasticsearchLocalDateIndexSchemaFieldContext((IndexSchemaContext)this, this.relativeFieldName));
    }

    public StandardIndexSchemaFieldTypedContext<?, Instant> asInstant() {
        return this.setDelegate(new ElasticsearchInstantIndexSchemaFieldContext((IndexSchemaContext)this, this.relativeFieldName));
    }

    public StandardIndexSchemaFieldTypedContext<?, GeoPoint> asGeoPoint() {
        return this.setDelegate(new ElasticsearchGeoPointIndexSchemaFieldContext((IndexSchemaContext)this, this.relativeFieldName));
    }

    @Override
    public ElasticsearchJsonStringIndexSchemaFieldTypedContext asJsonString(String mappingJsonString) {
        return this.setDelegate(new ElasticsearchJsonStringIndexSchemaFieldContext(this, this.relativeFieldName, mappingJsonString));
    }

    @Override
    public PropertyMapping contribute(ElasticsearchIndexSchemaNodeCollector collector, ElasticsearchIndexSchemaObjectNode parentNode) {
        return this.delegate.contribute(collector, parentNode);
    }

    public EventContext getEventContext() {
        return this.parent.getRootNodeBuilder().getIndexEventContext().append(EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath));
    }

    private <T extends ElasticsearchIndexSchemaNodeContributor<PropertyMapping>> T setDelegate(T context) {
        if (this.delegate != null) {
            throw log.tryToSetFieldTypeMoreThanOnce(this.getEventContext());
        }
        this.delegate = context;
        return context;
    }
}

