/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.document.model.dsl.impl;

import org.hibernate.search.backend.elasticsearch.document.impl.ElasticsearchIndexObjectFieldAccessor;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.impl.AbstractElasticsearchIndexSchemaObjectNodeBuilder;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.impl.ElasticsearchIndexSchemaRootNodeBuilder;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaNodeCollector;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaNodeContributor;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaObjectNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.DataType;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.DynamicType;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.PropertyMapping;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.util.impl.ElasticsearchFields;
import org.hibernate.search.engine.backend.document.IndexObjectFieldAccessor;
import org.hibernate.search.engine.backend.document.model.dsl.ObjectFieldStorage;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaContext;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaObjectFieldNodeBuilder;
import org.hibernate.search.engine.backend.document.spi.IndexSchemaObjectFieldDefinitionHelper;
import org.hibernate.search.engine.logging.spi.EventContexts;
import org.hibernate.search.util.EventContext;

class ElasticsearchIndexSchemaObjectFieldNodeBuilder
extends AbstractElasticsearchIndexSchemaObjectNodeBuilder
implements IndexSchemaObjectFieldNodeBuilder,
ElasticsearchIndexSchemaNodeContributor<PropertyMapping> {
    private final AbstractElasticsearchIndexSchemaObjectNodeBuilder parent;
    private final String absoluteFieldPath;
    private final String relativeFieldName;
    private final ObjectFieldStorage storage;
    private final IndexSchemaObjectFieldDefinitionHelper helper;

    ElasticsearchIndexSchemaObjectFieldNodeBuilder(AbstractElasticsearchIndexSchemaObjectNodeBuilder parent, String relativeFieldName, ObjectFieldStorage storage) {
        this.parent = parent;
        String parentAbsolutePath = parent.getAbsolutePath();
        this.absoluteFieldPath = parentAbsolutePath == null ? relativeFieldName : ElasticsearchFields.compose(parentAbsolutePath, relativeFieldName);
        this.relativeFieldName = relativeFieldName;
        this.storage = storage;
        this.helper = new IndexSchemaObjectFieldDefinitionHelper((IndexSchemaContext)this);
    }

    public EventContext getEventContext() {
        return this.getRootNodeBuilder().getIndexEventContext().append(EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath));
    }

    public IndexObjectFieldAccessor createAccessor() {
        return this.helper.createAccessor();
    }

    @Override
    public PropertyMapping contribute(ElasticsearchIndexSchemaNodeCollector collector, ElasticsearchIndexSchemaObjectNode parentNode) {
        ElasticsearchIndexSchemaObjectNode node = new ElasticsearchIndexSchemaObjectNode(parentNode, this.absoluteFieldPath, this.storage);
        collector.collect(this.absoluteFieldPath, node);
        JsonObjectAccessor jsonAccessor = JsonAccessor.root().property(this.relativeFieldName).asObject();
        this.helper.initialize((IndexObjectFieldAccessor)new ElasticsearchIndexObjectFieldAccessor(jsonAccessor, node));
        PropertyMapping mapping = new PropertyMapping();
        DataType dataType = DataType.OBJECT;
        switch (this.storage) {
            case DEFAULT: {
                break;
            }
            case FLATTENED: {
                dataType = DataType.OBJECT;
                break;
            }
            case NESTED: {
                dataType = DataType.NESTED;
            }
        }
        mapping.setType(dataType);
        mapping.setDynamic(DynamicType.STRICT);
        this.contributeChildren(mapping, node, collector);
        return mapping;
    }

    @Override
    ElasticsearchIndexSchemaRootNodeBuilder getRootNodeBuilder() {
        return this.parent.getRootNodeBuilder();
    }

    @Override
    String getAbsolutePath() {
        return this.absoluteFieldPath;
    }
}

