/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.document.model.dsl.impl;

import org.hibernate.search.backend.elasticsearch.document.model.dsl.impl.AbstractElasticsearchIndexSchemaObjectNodeBuilder;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaNodeCollector;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaObjectNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchRootIndexSchemaContributor;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.DynamicType;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.RootTypeMapping;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.RoutingType;
import org.hibernate.search.backend.elasticsearch.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaRootNodeBuilder;
import org.hibernate.search.engine.logging.spi.EventContexts;
import org.hibernate.search.util.EventContext;

public class ElasticsearchIndexSchemaRootNodeBuilder
extends AbstractElasticsearchIndexSchemaObjectNodeBuilder
implements IndexSchemaRootNodeBuilder,
ElasticsearchRootIndexSchemaContributor {
    private final String hibernateSearchIndexName;
    private final MultiTenancyStrategy multiTenancyStrategy;
    private RoutingType routing = null;

    public ElasticsearchIndexSchemaRootNodeBuilder(String hibernateSearchIndexName, MultiTenancyStrategy multiTenancyStrategy) {
        this.hibernateSearchIndexName = hibernateSearchIndexName;
        this.multiTenancyStrategy = multiTenancyStrategy;
    }

    public EventContext getEventContext() {
        return this.getIndexEventContext().append(EventContexts.indexSchemaRoot());
    }

    public void explicitRouting() {
        this.routing = RoutingType.REQUIRED;
    }

    @Override
    public RootTypeMapping contribute(ElasticsearchIndexSchemaNodeCollector collector) {
        ElasticsearchIndexSchemaObjectNode node = ElasticsearchIndexSchemaObjectNode.root();
        RootTypeMapping mapping = new RootTypeMapping();
        if (this.routing != null) {
            mapping.setRouting(this.routing);
        }
        this.multiTenancyStrategy.contributeToMapping(mapping);
        mapping.setDynamic(DynamicType.STRICT);
        this.contributeChildren(mapping, node, collector);
        return mapping;
    }

    @Override
    ElasticsearchIndexSchemaRootNodeBuilder getRootNodeBuilder() {
        return this;
    }

    @Override
    String getAbsolutePath() {
        return null;
    }

    EventContext getIndexEventContext() {
        return EventContexts.fromIndexName((String)this.hibernateSearchIndexName);
    }
}

