/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.document.model.impl;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaFieldNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaNodeCollector;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaObjectNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchRootIndexSchemaContributor;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.RootTypeMapping;
import org.hibernate.search.backend.elasticsearch.index.settings.impl.ElasticsearchIndexSettingsBuilder;
import org.hibernate.search.backend.elasticsearch.index.settings.impl.esnative.IndexSettings;
import org.hibernate.search.backend.elasticsearch.util.impl.URLEncodedString;
import org.hibernate.search.engine.logging.spi.EventContexts;
import org.hibernate.search.util.EventContext;

public class ElasticsearchIndexModel {
    private final String hibernateSearchIndexName;
    private final URLEncodedString elasticsearchIndexName;
    private final RootTypeMapping mapping;
    private final Map<String, ElasticsearchIndexSchemaObjectNode> objectNodes = new HashMap<String, ElasticsearchIndexSchemaObjectNode>();
    private final Map<String, ElasticsearchIndexSchemaFieldNode<?>> fieldNodes = new HashMap();
    private final IndexSettings settings;

    public ElasticsearchIndexModel(String hibernateSearchIndexName, URLEncodedString elasticsearchIndexName, ElasticsearchRootIndexSchemaContributor contributor, ElasticsearchIndexSettingsBuilder settingsBuilder) {
        this.hibernateSearchIndexName = hibernateSearchIndexName;
        this.elasticsearchIndexName = elasticsearchIndexName;
        this.mapping = contributor.contribute(new ElasticsearchIndexSchemaNodeCollector(){

            @Override
            public void collect(String absolutePath, ElasticsearchIndexSchemaObjectNode node) {
                ElasticsearchIndexModel.this.objectNodes.put(absolutePath, node);
            }

            @Override
            public void collect(String absoluteFieldPath, ElasticsearchIndexSchemaFieldNode<?> node) {
                ElasticsearchIndexModel.this.fieldNodes.put(absoluteFieldPath, node);
            }
        });
        this.settings = settingsBuilder.build();
    }

    public String getHibernateSearchIndexName() {
        return this.hibernateSearchIndexName;
    }

    public URLEncodedString getElasticsearchIndexName() {
        return this.elasticsearchIndexName;
    }

    public EventContext getEventContext() {
        return EventContexts.fromIndexName((String)this.hibernateSearchIndexName);
    }

    public RootTypeMapping getMapping() {
        return this.mapping;
    }

    public IndexSettings getSettings() {
        return this.settings;
    }

    public ElasticsearchIndexSchemaObjectNode getObjectNode(String absolutePath) {
        return this.objectNodes.get(absolutePath);
    }

    public ElasticsearchIndexSchemaFieldNode<?> getFieldNode(String absoluteFieldPath) {
        return this.fieldNodes.get(absoluteFieldPath);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "elasticsearchIndexName=" + this.elasticsearchIndexName + ", mapping=" + this.mapping + "]";
    }
}

