/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.gson.impl;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonElementType;
import org.hibernate.search.util.AssertionFailure;

public class UnexpectedJsonElementTypeException
extends AssertionFailure {
    private final JsonAccessor<?> accessor;
    private final List<JsonElementType<?>> expectedTypes;
    private final JsonElement actualElement;

    public UnexpectedJsonElementTypeException(JsonAccessor<?> accessor, JsonElementType<?> expectedType, JsonElement actualElement) {
        this(accessor, Arrays.asList(expectedType), actualElement);
    }

    public UnexpectedJsonElementTypeException(JsonAccessor<?> accessor, List<? extends JsonElementType<?>> expectedTypes, JsonElement actualElement) {
        super("Unexpected type at '" + accessor + "'. Expected one of " + expectedTypes + ", got '" + actualElement + "'");
        this.accessor = accessor;
        this.expectedTypes = Collections.unmodifiableList(new ArrayList(expectedTypes));
        this.actualElement = actualElement;
    }

    public JsonAccessor<?> getAccessor() {
        return this.accessor;
    }

    public List<JsonElementType<?>> getExpectedTypes() {
        return this.expectedTypes;
    }

    public JsonElement getActualElement() {
        return this.actualElement;
    }
}

