/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.impl;

import com.google.gson.GsonBuilder;
import java.io.Closeable;
import java.lang.invoke.MethodHandles;
import java.util.Locale;
import java.util.Optional;
import org.hibernate.search.backend.elasticsearch.analysis.ElasticsearchAnalysisConfigurer;
import org.hibernate.search.backend.elasticsearch.analysis.model.dsl.impl.ElasticsearchAnalysisDefinitionContainerContextImpl;
import org.hibernate.search.backend.elasticsearch.analysis.model.impl.ElasticsearchAnalysisDefinitionRegistry;
import org.hibernate.search.backend.elasticsearch.cfg.MultiTenancyStrategyConfiguration;
import org.hibernate.search.backend.elasticsearch.cfg.SearchBackendElasticsearchSettings;
import org.hibernate.search.backend.elasticsearch.client.impl.ElasticsearchClientFactoryImpl;
import org.hibernate.search.backend.elasticsearch.client.impl.ElasticsearchClientImplementor;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.FieldDataType;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.IndexType;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.NormsType;
import org.hibernate.search.backend.elasticsearch.gson.impl.DefaultGsonProvider;
import org.hibernate.search.backend.elasticsearch.gson.impl.ES5FieldDataTypeJsonAdapter;
import org.hibernate.search.backend.elasticsearch.gson.impl.ES5IndexTypeJsonAdapter;
import org.hibernate.search.backend.elasticsearch.gson.impl.ES5NormsTypeJsonAdapter;
import org.hibernate.search.backend.elasticsearch.gson.impl.GsonProvider;
import org.hibernate.search.backend.elasticsearch.impl.ElasticsearchBackendImpl;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.multitenancy.impl.DiscriminatorMultiTenancyStrategy;
import org.hibernate.search.backend.elasticsearch.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.elasticsearch.multitenancy.impl.NoMultiTenancyStrategy;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchStubWorkFactory;
import org.hibernate.search.engine.backend.spi.BackendBuildContext;
import org.hibernate.search.engine.backend.spi.BackendFactory;
import org.hibernate.search.engine.backend.spi.BackendImplementor;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.environment.bean.BeanProvider;
import org.hibernate.search.engine.logging.spi.EventContexts;
import org.hibernate.search.util.AssertionFailure;
import org.hibernate.search.util.EventContext;
import org.hibernate.search.util.impl.common.LoggerFactory;
import org.hibernate.search.util.impl.common.SuppressingCloser;

public class ElasticsearchBackendFactory
implements BackendFactory {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final ConfigurationProperty<MultiTenancyStrategyConfiguration> MULTI_TENANCY_STRATEGY = ConfigurationProperty.forKey((String)"multi_tenancy_strategy").as(MultiTenancyStrategyConfiguration.class, MultiTenancyStrategyConfiguration::fromExternalRepresentation).withDefault((Object)SearchBackendElasticsearchSettings.Defaults.MULTI_TENANCY_STRATEGY).build();
    private static final ConfigurationProperty<Boolean> LOG_JSON_PRETTY_PRINTING = ConfigurationProperty.forKey((String)"log.json_pretty_printing").asBoolean().withDefault((Object)false).build();

    public BackendImplementor<?> create(String name, BackendBuildContext buildContext, ConfigurationPropertySource propertySource) {
        EventContext backendContext = EventContexts.fromBackendName((String)name);
        ElasticsearchClientFactoryImpl clientFactory = new ElasticsearchClientFactoryImpl();
        boolean logPrettyPrinting = (Boolean)LOG_JSON_PRETTY_PRINTING.get(propertySource);
        GsonProvider initialGsonProvider = DefaultGsonProvider.create(GsonBuilder::new, logPrettyPrinting);
        ElasticsearchClientImplementor client = clientFactory.create(propertySource, initialGsonProvider);
        try {
            GsonProvider dialectSpecificGsonProvider = DefaultGsonProvider.create(this::createES5GsonBuilderBase, logPrettyPrinting);
            client.init(dialectSpecificGsonProvider);
            ElasticsearchStubWorkFactory workFactory = new ElasticsearchStubWorkFactory(dialectSpecificGsonProvider);
            ElasticsearchAnalysisDefinitionRegistry analysisDefinitionRegistry = this.getAnalysisDefinitionRegistry(backendContext, buildContext, propertySource);
            return new ElasticsearchBackendImpl(client, name, workFactory, analysisDefinitionRegistry, this.getMultiTenancyStrategy(name, propertySource));
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).push(Closeable::close, (Object)client);
            throw e;
        }
    }

    private GsonBuilder createES5GsonBuilderBase() {
        return new GsonBuilder().registerTypeAdapter(IndexType.class, (Object)new ES5IndexTypeJsonAdapter().nullSafe()).registerTypeAdapter(FieldDataType.class, (Object)new ES5FieldDataTypeJsonAdapter().nullSafe()).registerTypeAdapter(NormsType.class, (Object)new ES5NormsTypeJsonAdapter().nullSafe());
    }

    private MultiTenancyStrategy getMultiTenancyStrategy(String backendName, ConfigurationPropertySource propertySource) {
        MultiTenancyStrategyConfiguration multiTenancyStrategyConfiguration = (MultiTenancyStrategyConfiguration)((Object)MULTI_TENANCY_STRATEGY.get(propertySource));
        switch (multiTenancyStrategyConfiguration) {
            case NONE: {
                return new NoMultiTenancyStrategy();
            }
            case DISCRIMINATOR: {
                return new DiscriminatorMultiTenancyStrategy();
            }
        }
        throw new AssertionFailure(String.format(Locale.ROOT, "Unsupported multi-tenancy strategy '%2$s' for backend '%1$s'", new Object[]{backendName, multiTenancyStrategyConfiguration}));
    }

    private ElasticsearchAnalysisDefinitionRegistry getAnalysisDefinitionRegistry(EventContext backendContext, BackendBuildContext buildContext, ConfigurationPropertySource propertySource) {
        try {
            BeanProvider beanProvider = buildContext.getServiceManager().getBeanProvider();
            ConfigurationProperty analysisConfigurerProperty = ConfigurationProperty.forKey((String)"analysis_configurer").as(ElasticsearchAnalysisConfigurer.class, reference -> (ElasticsearchAnalysisConfigurer)beanProvider.getBean(reference, ElasticsearchAnalysisConfigurer.class)).build();
            return ((Optional)analysisConfigurerProperty.get(propertySource)).map(configurer -> {
                ElasticsearchAnalysisDefinitionContainerContextImpl collector = new ElasticsearchAnalysisDefinitionContainerContextImpl();
                configurer.configure(collector);
                return new ElasticsearchAnalysisDefinitionRegistry(collector);
            }).orElseGet(ElasticsearchAnalysisDefinitionRegistry::new);
        }
        catch (Exception e) {
            throw log.unableToApplyAnalysisConfiguration(e.getMessage(), backendContext, e);
        }
    }
}

