/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.impl;

import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.hibernate.search.backend.elasticsearch.ElasticsearchBackend;
import org.hibernate.search.backend.elasticsearch.analysis.model.impl.ElasticsearchAnalysisDefinitionRegistry;
import org.hibernate.search.backend.elasticsearch.client.impl.ElasticsearchClient;
import org.hibernate.search.backend.elasticsearch.document.impl.ElasticsearchDocumentObjectBuilder;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.impl.ElasticsearchIndexSchemaRootNodeBuilder;
import org.hibernate.search.backend.elasticsearch.impl.ElasticsearchIndexNameNormalizer;
import org.hibernate.search.backend.elasticsearch.index.impl.ElasticsearchIndexManagerBuilder;
import org.hibernate.search.backend.elasticsearch.index.impl.IndexingBackendContext;
import org.hibernate.search.backend.elasticsearch.index.settings.impl.ElasticsearchIndexSettingsBuilder;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchStubWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.search.query.impl.SearchBackendContext;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWorkFactory;
import org.hibernate.search.engine.backend.Backend;
import org.hibernate.search.engine.backend.index.spi.IndexManagerBuilder;
import org.hibernate.search.engine.backend.spi.BackendBuildContext;
import org.hibernate.search.engine.backend.spi.BackendImplementor;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.logging.spi.EventContexts;
import org.hibernate.search.util.EventContext;
import org.hibernate.search.util.impl.common.Closer;
import org.hibernate.search.util.impl.common.LoggerFactory;

class ElasticsearchBackendImpl
implements BackendImplementor<ElasticsearchDocumentObjectBuilder>,
ElasticsearchBackend {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final ElasticsearchClient client;
    private final String name;
    private final ElasticsearchAnalysisDefinitionRegistry analysisDefinitionRegistry;
    private final MultiTenancyStrategy multiTenancyStrategy;
    private final ElasticsearchWorkOrchestrator streamOrchestrator;
    private final ElasticsearchWorkOrchestrator queryOrchestrator;
    private final Map<String, String> hibernateSearchIndexNamesByElasticsearchIndexNames = new ConcurrentHashMap<String, String>();
    private final EventContext eventContext;
    private final IndexingBackendContext indexingContext;
    private final SearchBackendContext searchContext;

    ElasticsearchBackendImpl(ElasticsearchClient client, String name, ElasticsearchWorkFactory workFactory, ElasticsearchAnalysisDefinitionRegistry analysisDefinitionRegistry, MultiTenancyStrategy multiTenancyStrategy) {
        this.client = client;
        this.name = name;
        this.analysisDefinitionRegistry = analysisDefinitionRegistry;
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.streamOrchestrator = new ElasticsearchStubWorkOrchestrator(client);
        this.queryOrchestrator = new ElasticsearchStubWorkOrchestrator(client);
        this.eventContext = EventContexts.fromBackendName((String)name);
        this.indexingContext = new IndexingBackendContext(this.eventContext, client, workFactory, multiTenancyStrategy, this.streamOrchestrator);
        this.searchContext = new SearchBackendContext(this.eventContext, workFactory, new Function<String, String>(){

            @Override
            public String apply(String elasticsearchIndexName) {
                String result = (String)ElasticsearchBackendImpl.this.hibernateSearchIndexNamesByElasticsearchIndexNames.get(elasticsearchIndexName);
                if (result == null) {
                    throw log.elasticsearchResponseUnknownIndexName(elasticsearchIndexName, ElasticsearchBackendImpl.this.eventContext);
                }
                return result;
            }
        }, multiTenancyStrategy, this.queryOrchestrator);
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(ElasticsearchBackend.class)) {
            return (T)this;
        }
        throw log.backendUnwrappingWithUnknownType(clazz, ElasticsearchBackend.class, this.eventContext);
    }

    public Backend toAPI() {
        return this;
    }

    @Override
    public <T> T getClient(Class<T> clientClass) {
        return this.client.unwrap(clientClass);
    }

    public IndexManagerBuilder<ElasticsearchDocumentObjectBuilder> createIndexManagerBuilder(String hibernateSearchIndexName, boolean multiTenancyEnabled, BackendBuildContext buildContext, ConfigurationPropertySource propertySource) {
        if (multiTenancyEnabled && !this.multiTenancyStrategy.isMultiTenancySupported()) {
            throw log.multiTenancyRequiredButNotSupportedByBackend(hibernateSearchIndexName, this.eventContext);
        }
        String elasticsearchIndexName = ElasticsearchIndexNameNormalizer.normalize(hibernateSearchIndexName);
        String existingHibernateSearchIndexName = this.hibernateSearchIndexNamesByElasticsearchIndexNames.putIfAbsent(elasticsearchIndexName, hibernateSearchIndexName);
        if (existingHibernateSearchIndexName != null) {
            throw log.duplicateNormalizedIndexNames(existingHibernateSearchIndexName, hibernateSearchIndexName, elasticsearchIndexName, this.eventContext);
        }
        ElasticsearchIndexSchemaRootNodeBuilder indexSchemaRootNodeBuilder = new ElasticsearchIndexSchemaRootNodeBuilder(hibernateSearchIndexName, this.multiTenancyStrategy);
        ElasticsearchIndexSettingsBuilder settingsBuilder = new ElasticsearchIndexSettingsBuilder(this.analysisDefinitionRegistry);
        return new ElasticsearchIndexManagerBuilder(this.indexingContext, this.searchContext, hibernateSearchIndexName, elasticsearchIndexName, indexSchemaRootNodeBuilder, settingsBuilder);
    }

    public void close() {
        try (Closer closer = new Closer();){
            closer.push(ElasticsearchWorkOrchestrator::close, (Object)this.streamOrchestrator);
            closer.push(ElasticsearchWorkOrchestrator::close, (Object)this.queryOrchestrator);
            closer.push(Closeable::close, (Object)this.client);
        }
        catch (IOException | RuntimeException e) {
            throw log.failedToShutdownBackend(e, this.eventContext);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "name=" + this.name + "]";
    }
}

