/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.index.impl;

import org.hibernate.search.backend.elasticsearch.document.impl.ElasticsearchDocumentObjectBuilder;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.impl.ElasticsearchIndexSchemaRootNodeBuilder;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexModel;
import org.hibernate.search.backend.elasticsearch.index.impl.ElasticsearchIndexManagerImpl;
import org.hibernate.search.backend.elasticsearch.index.impl.IndexingBackendContext;
import org.hibernate.search.backend.elasticsearch.index.settings.impl.ElasticsearchIndexSettingsBuilder;
import org.hibernate.search.backend.elasticsearch.search.query.impl.SearchBackendContext;
import org.hibernate.search.backend.elasticsearch.util.impl.URLEncodedString;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaRootNodeBuilder;
import org.hibernate.search.engine.backend.index.spi.IndexManagerBuilder;

public class ElasticsearchIndexManagerBuilder
implements IndexManagerBuilder<ElasticsearchDocumentObjectBuilder> {
    private final IndexingBackendContext indexingBackendContext;
    private final SearchBackendContext searchBackendContext;
    private final String hibernateSearchIndexName;
    private final String elasticsearchIndexName;
    private final ElasticsearchIndexSchemaRootNodeBuilder schemaRootNodeBuilder;
    private final ElasticsearchIndexSettingsBuilder settingsBuilder;

    public ElasticsearchIndexManagerBuilder(IndexingBackendContext indexingBackendContext, SearchBackendContext searchBackendContext, String hibernateSearchIndexName, String elasticsearchIndexName, ElasticsearchIndexSchemaRootNodeBuilder schemaRootNodeBuilder, ElasticsearchIndexSettingsBuilder settingsBuilder) {
        this.indexingBackendContext = indexingBackendContext;
        this.searchBackendContext = searchBackendContext;
        this.hibernateSearchIndexName = hibernateSearchIndexName;
        this.elasticsearchIndexName = elasticsearchIndexName;
        this.schemaRootNodeBuilder = schemaRootNodeBuilder;
        this.settingsBuilder = settingsBuilder;
    }

    public void closeOnFailure() {
    }

    public IndexSchemaRootNodeBuilder getSchemaRootNodeBuilder() {
        return this.schemaRootNodeBuilder;
    }

    public ElasticsearchIndexManagerImpl build() {
        URLEncodedString encodedElasticsearchIndexName = URLEncodedString.fromString(this.elasticsearchIndexName);
        URLEncodedString encodedTypeName = URLEncodedString.fromString("typeName");
        ElasticsearchIndexModel model = new ElasticsearchIndexModel(this.hibernateSearchIndexName, encodedElasticsearchIndexName, this.schemaRootNodeBuilder, this.settingsBuilder);
        this.indexingBackendContext.initializeIndex(encodedElasticsearchIndexName, encodedTypeName, model).join();
        return new ElasticsearchIndexManagerImpl(this.indexingBackendContext, this.searchBackendContext, this.hibernateSearchIndexName, encodedElasticsearchIndexName, encodedTypeName, model);
    }
}

